/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class GridContextMenuTest {
    @Mock
    protected LIElement insertRowAboveLIElementMock;
    @Mock
    protected LIElement insertRowBelowLIElementMock;
    @Mock
    protected LIElement duplicateRowLIElementMock;
    @Mock
    protected LIElement deleteRowLIElementMock;
    @Mock
    protected LIElement createdElementMock;
    @Mock
    protected LIElement gridTitleElementMock;
    protected GridContextMenu gridContextMenuSpy;

    @Before
    public void setup() {
        this.gridContextMenuSpy = (GridContextMenu)Mockito.spy((Object)new GridContextMenu(){
            {
                this.insertRowAboveLIElement = GridContextMenuTest.this.insertRowAboveLIElementMock;
                this.insertRowBelowLIElement = GridContextMenuTest.this.insertRowBelowLIElementMock;
                this.duplicateRowLIElement = GridContextMenuTest.this.duplicateRowLIElementMock;
                this.deleteRowLIElement = GridContextMenuTest.this.deleteRowLIElementMock;
                this.gridTitleElement = GridContextMenuTest.this.gridTitleElementMock;
            }

            public LIElement addExecutableMenuItem(String id, String label, String i18n) {
                return GridContextMenuTest.this.createdElementMock;
            }

            public void mapEvent(LIElement executableMenuItem, Event toBeMapped) {
            }

            protected void updateExecutableMenuItemAttributes(LIElement toUpdate, String id, String label, String i18n) {
            }

            public LIElement addMenuItem(String id, String label, String i18n) {
                return GridContextMenuTest.this.createdElementMock;
            }

            public void removeMenuItem(LIElement toRemove) {
            }

            public void show(GridWidget gridWidget, int mx, int my) {
            }
        });
    }

    @Test
    public void initMenu() {
        this.initMenu(this.gridContextMenuSpy);
    }

    @Test
    public void show_Simulation() {
        this.show(this.gridContextMenuSpy, GridWidget.SIMULATION, ScenarioSimulationEditorConstants.INSTANCE.scenario(), "scenario", 0, 0, 1);
    }

    @Test
    public void show_Background() {
        this.show(this.gridContextMenuSpy, GridWidget.BACKGROUND, ScenarioSimulationEditorConstants.INSTANCE.background(), "background", 0, 0, 1);
    }

    protected void initMenu(GridContextMenu gridContextMenu) {
        gridContextMenu.initMenu();
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-insert-row-above"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertRowAbove()), (String)Matchers.eq((Object)"insertRowAbove"));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-insert-row-below"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertRowBelow()), (String)Matchers.eq((Object)"insertRowBelow"));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-duplicate-row"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.duplicateRow()), (String)Matchers.eq((Object)"duplicateRow"));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"gridcontextmenu-delete-row"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteRow()), (String)Matchers.eq((Object)"deleteRow"));
    }

    protected void show(GridContextMenu gridContextMenu, GridWidget gridWidget, String expectedLabel, String expectedI18n, int mx, int my, int rowIndex) {
        gridContextMenu.show(gridWidget, mx, my, rowIndex);
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)gridWidget), Matchers.eq((int)0), Matchers.eq((int)0));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((GridContextMenu)Mockito.verify((Object)gridContextMenu, (VerificationMode)Mockito.times((int)1))).updateMenuItemAttributes((LIElement)Matchers.eq((Object)this.gridTitleElementMock), (String)Matchers.eq((Object)"gridcontextmenu-grid-title"), (String)Matchers.eq((Object)expectedLabel), (String)Matchers.eq((Object)expectedI18n));
    }
}

