/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationMainGridPanelMouseMoveHandler;
import org.drools.workbench.screens.scenariosimulation.client.popover.ErrorReportPopoverPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationMainGridPanelMouseMoveHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    private final int ABSOLUTE_LEFT = 0;
    private final int CELL_HEIGHT = 30;
    private static final String BR = "<br>";
    private ScenarioSimulationMainGridPanelMouseMoveHandler mouseMoveHandler;
    @Mock
    private ErrorReportPopoverPresenter errorReportPopupPresenterMock;
    @Mock
    private Scenario scenarioMock;
    @Mock
    private FactMappingValue factMappingValueMock;
    @Mock
    private AbsolutePanel scrollPanelMock;
    @Mock
    private NodeMouseMoveEvent mouseMoveEvent;
    @Mock
    private Element elementMock;
    @Mock
    private DivElement layerElementMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.mouseMoveHandler = (ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.spy((Object)new ScenarioSimulationMainGridPanelMouseMoveHandler(){
            {
                this.errorReportPopupPresenter = ScenarioSimulationMainGridPanelMouseMoveHandlerTest.this.errorReportPopupPresenterMock;
                this.scenarioGrid = ScenarioSimulationMainGridPanelMouseMoveHandlerTest.this.scenarioGridMock;
                this.scenarioGridPanel = ScenarioSimulationMainGridPanelMouseMoveHandlerTest.this.scenarioGridPanelMock;
            }

            protected Point2D retrieveCellMiddleXYPosition(GridColumn<?> column, int uiRowIndex) {
                return new Point2D((double)TestProperties.DX.intValue(), (double)TestProperties.DY.intValue());
            }

            protected Point2D convertDOMToGridCoordinateLocal(double canvasX, double canvasY) {
                return new Point2D((double)TestProperties.MX.intValue(), (double)TestProperties.MY.intValue());
            }

            protected int getCellHeight(GridColumn<?> column, int uiRowIndex) {
                return 30;
            }
        });
        Mockito.when((Object)((Scenario)this.simulationMock.getDataByIndex(((Integer)ArgumentMatchers.isA(Integer.class)).intValue()))).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactMapping)ArgumentMatchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.factMappingValueMock.getRawValue()).thenReturn((Object)"raw");
        Mockito.when((Object)this.factMappingValueMock.getErrorValue()).thenReturn((Object)"error");
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.LARGE_LAYER);
        Mockito.when((Object)this.gridColumnMock.getWidth()).thenReturn((Object)TestProperties.CELL_WIDTH);
        Mockito.when((Object)this.scenarioGridPanelMock.getScrollPanel()).thenReturn((Object)this.scrollPanelMock);
        Mockito.when((Object)this.scrollPanelMock.getElement()).thenReturn((Object)this.elementMock);
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.errorReportPopupPresenterMock.isShown()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.mouseMoveEvent.getX()).thenReturn((Object)TestProperties.MX);
        Mockito.when((Object)this.mouseMoveEvent.getY()).thenReturn((Object)TestProperties.MY);
        Mockito.when((Object)this.layerElementMock.getAbsoluteLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.scenarioGridLayerMock.getElement()).thenReturn((Object)this.layerElementMock);
    }

    @Test
    public void onNodeMouseMove() {
        this.mouseMoveHandler.onNodeMouseMove(this.mouseMoveEvent);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).manageCoordinates(((Integer)ArgumentMatchers.eq((Object)TestProperties.MX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.MY)).intValue());
    }

    @Test
    public void hidePopover() {
        this.mouseMoveHandler.hidePopover();
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void manageBodyCoordinatesNotInGrid() {
        boolean inGrid = this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(-1), Integer.valueOf(-1));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getDataByIndex(((Integer)ArgumentMatchers.isA(Integer.class)).intValue());
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.never())).getFactMappingByIndex(((Integer)ArgumentMatchers.isA(Integer.class)).intValue());
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.never())).getFactMappingValue((FactMapping)ArgumentMatchers.any());
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.never())).retrieveCellMiddleXYPosition((GridColumn)ArgumentMatchers.any(), ((Integer)ArgumentMatchers.isA(Integer.class)).intValue());
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.never())).setup((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Command)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (PopoverView.Position)ArgumentMatchers.any());
        Assert.assertFalse((boolean)inGrid);
    }

    @Test
    public void manageBodyCoordinatesSameCellIsShown() {
        this.mouseMoveHandler.currentlyShownBodyRowIndex = 2;
        this.mouseMoveHandler.currentlyShownBodyColumnIndex = 3;
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)true).when((Object)this.errorReportPopupPresenterMock)).isShown();
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.never())).getDataByIndex(ArgumentMatchers.eq((int)2));
    }

    @Test
    public void manageBodyCoordinatesSameCellNotShown() {
        this.mouseMoveHandler.currentlyShownBodyRowIndex = 2;
        this.mouseMoveHandler.currentlyShownBodyColumnIndex = 3;
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)false).when((Object)this.errorReportPopupPresenterMock)).isShown();
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).manageFactMappingValue((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), Integer.valueOf(ArgumentMatchers.eq((int)2)), Integer.valueOf(ArgumentMatchers.eq((int)3)));
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(ArgumentMatchers.eq((int)2));
    }

    @Test
    public void manageBodyCoordinatesNotShownWithoutFactMappingValue() {
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)false).when((Object)this.errorReportPopupPresenterMock)).isShown();
        ((Scenario)Mockito.doReturn(Optional.empty()).when((Object)this.scenarioMock)).getFactMappingValue((FactMapping)ArgumentMatchers.eq((Object)this.factMappingMock));
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(ArgumentMatchers.eq((int)2));
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(ArgumentMatchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)ArgumentMatchers.eq((Object)this.factMappingMock));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.never())).manageFactMappingValue((FactMappingValue)ArgumentMatchers.isA(FactMappingValue.class), Integer.valueOf(ArgumentMatchers.anyInt()), Integer.valueOf(ArgumentMatchers.anyInt()));
    }

    @Test
    public void manageBodyCoordinatesNotShownWithFactMappingValue() {
        ((ErrorReportPopoverPresenter)Mockito.doReturn((Object)false).when((Object)this.errorReportPopupPresenterMock)).isShown();
        ((Scenario)Mockito.doReturn(Optional.of(this.factMappingValueMock)).when((Object)this.scenarioMock)).getFactMappingValue((FactMapping)ArgumentMatchers.eq((Object)this.factMappingMock));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).manageFactMappingValue((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), Integer.valueOf(ArgumentMatchers.eq((int)2)), Integer.valueOf(ArgumentMatchers.eq((int)3)));
        this.mouseMoveHandler.manageBodyCoordinates(Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(ArgumentMatchers.eq((int)2));
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(ArgumentMatchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)ArgumentMatchers.eq((Object)this.factMappingMock));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).manageFactMappingValue((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), Integer.valueOf(ArgumentMatchers.eq((int)2)), Integer.valueOf(ArgumentMatchers.eq((int)3)));
    }

    @Test
    public void manageFactMappingValueSuccess() {
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.SUCCESS);
        this.mouseMoveHandler.manageFactMappingValue(this.factMappingValueMock, Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.never())).manageFailedFactMappingValue((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), Integer.valueOf(ArgumentMatchers.eq((int)2)), Integer.valueOf(ArgumentMatchers.eq((int)3)));
    }

    @Test
    public void manageFactMappingValueNotSuccess() {
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).manageFailedFactMappingValue((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), Integer.valueOf(ArgumentMatchers.eq((int)2)), Integer.valueOf(ArgumentMatchers.eq((int)3)));
        this.mouseMoveHandler.manageFactMappingValue(this.factMappingValueMock, Integer.valueOf(2), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).manageFailedFactMappingValue((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), Integer.valueOf(ArgumentMatchers.eq((int)2)), Integer.valueOf(ArgumentMatchers.eq((int)3)));
    }

    @Test
    public void manageFailedFactMappingValueRight() {
        int expectedDx = (int)(TestProperties.CELL_WIDTH / 2.0) + TestProperties.DX;
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).setupPopupPresenter((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((int)expectedDx), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
        this.mouseMoveHandler.manageFailedFactMappingValue(this.factMappingValueMock, Integer.valueOf(0), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).setupPopupPresenter((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((int)expectedDx), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void manageFailedFactMappingValueLeft() {
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.TINY_LAYER);
        int expectedDx = (int)((double)TestProperties.DX.intValue() - TestProperties.CELL_WIDTH / 2.0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).setupPopupPresenter((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((int)expectedDx), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
        this.mouseMoveHandler.manageFailedFactMappingValue(this.factMappingValueMock, Integer.valueOf(0), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).setupPopupPresenter((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((int)expectedDx), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.LEFT));
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void manageFailedFactMappingValueTop() {
        Mockito.when((Object)this.scenarioGridLayerMock.getWidth()).thenReturn((Object)TestProperties.SMALLEST_LAYER);
        Mockito.when((Object)this.layerElementMock.getAbsoluteLeft()).thenReturn((Object)4000);
        int expectedDy = TestProperties.DY - 15;
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.doNothing().when((Object)this.mouseMoveHandler)).setupPopupPresenter((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)3), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ArgumentMatchers.eq((int)expectedDy), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
        this.mouseMoveHandler.manageFailedFactMappingValue(this.factMappingValueMock, Integer.valueOf(0), Integer.valueOf(3));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).retrieveCellMiddleXYPosition((GridColumn)this.gridColumnMock, 0);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).setupPopupPresenter((FactMappingValue)ArgumentMatchers.eq((Object)this.factMappingValueMock), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)3), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ArgumentMatchers.eq((int)expectedDy), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.TOP));
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void setupPopupPresenterWithScrollFailedWithError_NullPath() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.factMappingValueMock.getCollectionPathToValue()).thenReturn(null);
        this.mouseMoveHandler.setupPopupPresenter(this.factMappingValueMock, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).showErrorPopoverWithSuggestion(ArgumentMatchers.eq((Object)"raw"), ArgumentMatchers.eq((Object)"error"), ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)3), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void setupPopupPresenterWithScrollFailedWithError_WithPath() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.factMappingValueMock.getCollectionPathToValue()).thenReturn(Arrays.asList("field1"));
        this.mouseMoveHandler.setupPopupPresenter(this.factMappingValueMock, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        String errorMessage = this.mouseMoveHandler.getCollectionHTMLErrorMessage((Object)"error", Arrays.asList("field1"));
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).showErrorPopoverWithoutSuggestion((String)ArgumentMatchers.eq((Object)errorMessage), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void setupPopupPresenterWithScrollFailedWithException() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_EXCEPTION);
        Mockito.when((Object)this.factMappingValueMock.getExceptionMessage()).thenReturn((Object)"GenericException");
        this.mouseMoveHandler.setupPopupPresenter(this.factMappingValueMock, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        ((ScenarioSimulationMainGridPanelMouseMoveHandler)Mockito.verify((Object)this.mouseMoveHandler, (VerificationMode)Mockito.times((int)1))).showErrorPopoverWithoutSuggestion((String)ArgumentMatchers.eq((Object)"GenericException"), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void showErrorPopoverWithoutSuggestion() {
        this.mouseMoveHandler.showErrorPopoverWithoutSuggestion("error", TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).setup((String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)ArgumentMatchers.eq((Object)"error"), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.close()), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void showErrorPopoverWithSuggestion() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.mouseMoveHandler.showErrorPopoverWithSuggestion((Object)"raw", (Object)"error", 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        String expectedValue = this.mouseMoveHandler.decorateWithStrongHTMLTag("raw");
        String wrongValue = this.mouseMoveHandler.decorateWithStrongHTMLTag("error");
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).setup((String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError(expectedValue, wrongValue)), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)ArgumentMatchers.isA(Command.class), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void showErrorPopoverWithSuggestion_NULLValues() {
        Mockito.when((Object)this.elementMock.getScrollTop()).thenReturn((Object)TestProperties.SCROLL_TOP);
        Mockito.when((Object)this.elementMock.getScrollLeft()).thenReturn((Object)TestProperties.SCROLL_LEFT);
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.mouseMoveHandler.showErrorPopoverWithSuggestion(null, null, 2, 3, TestProperties.DX.intValue(), TestProperties.DY.intValue(), PopoverView.Position.RIGHT);
        String expectedValue = this.mouseMoveHandler.decorateWithStrongHTMLTag("null");
        String wrongValue = this.mouseMoveHandler.decorateWithStrongHTMLTag("null");
        ((ErrorReportPopoverPresenter)Mockito.verify((Object)this.errorReportPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).setup((String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorReason()), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError(expectedValue, wrongValue)), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.keep()), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.apply()), (Command)ArgumentMatchers.isA(Command.class), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DX)).intValue(), ((Integer)ArgumentMatchers.eq((Object)TestProperties.DY)).intValue(), (PopoverView.Position)ArgumentMatchers.eq((Object)PopoverView.Position.RIGHT));
    }

    @Test
    public void getCollectionHTMLErrorMessage_EmptyPath() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverGenericCollectionErrorMessage(), (Object)this.mouseMoveHandler.getCollectionHTMLErrorMessage((Object)"error", Collections.emptyList()));
    }

    @Test
    public void getCollectionHTMLErrorMessage_OnePathItemWithWrongValue() {
        String field1 = "Field1";
        Assert.assertEquals((Object)(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLFailureMessage(this.mouseMoveHandler.decorateWithEMHTMLTag(field1)) + BR + ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLValue(this.mouseMoveHandler.decorateWithStrongHTMLTag("error"))), (Object)this.mouseMoveHandler.getCollectionHTMLErrorMessage((Object)"error", Arrays.asList(field1)));
    }

    @Test
    public void getCollectionHTMLErrorMessage_OnePathItemWithoutWrongValue() {
        String field1 = "Field1";
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLFailureMessage(this.mouseMoveHandler.decorateWithEMHTMLTag(field1)), (Object)this.mouseMoveHandler.getCollectionHTMLErrorMessage(null, Arrays.asList(field1)));
    }

    @Test
    public void getCollectionHTMLErrorMessage_PathItemsWithWrongValue() {
        String field1 = "Field1";
        String field2 = "Field2";
        Assert.assertEquals((Object)(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLFailureMessage(this.mouseMoveHandler.decorateWithEMHTMLTag(field1)) + BR + ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLField(this.mouseMoveHandler.decorateWithEMHTMLTag(this.mouseMoveHandler.generateFieldsHierarchy(Arrays.asList(field2)))) + ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLValue(this.mouseMoveHandler.decorateWithStrongHTMLTag("error"))), (Object)this.mouseMoveHandler.getCollectionHTMLErrorMessage((Object)"error", Arrays.asList(field1, field2)));
    }

    @Test
    public void getCollectionHTMLErrorMessage_PathItemsWithoutWrongValue() {
        String field1 = "Field1";
        String field2 = "Field2";
        Assert.assertEquals((Object)(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLFailureMessage(this.mouseMoveHandler.decorateWithEMHTMLTag(field1)) + BR + ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLField(this.mouseMoveHandler.decorateWithEMHTMLTag(this.mouseMoveHandler.generateFieldsHierarchy(Arrays.asList(field2))))), (Object)this.mouseMoveHandler.getCollectionHTMLErrorMessage(null, Arrays.asList(field1, field2)));
    }

    @Test
    public void decorateWithStrongHTMLTag() {
        Assert.assertEquals((Object)"<strong>\"raw\"</strong>", (Object)this.mouseMoveHandler.decorateWithStrongHTMLTag("raw"));
    }

    @Test
    public void decorateWithEMHTMLTag() {
        Assert.assertEquals((Object)"<em>raw</em>", (Object)this.mouseMoveHandler.decorateWithEMHTMLTag("raw"));
    }

    @Test
    public void generateFieldsHierarchy() {
        Assert.assertEquals((Object)"Field1<br>", (Object)this.mouseMoveHandler.generateFieldsHierarchy(Arrays.asList("Field1")));
        Assert.assertEquals((Object)"<ul><li>Field1<ul><li>Field2<ul><li>Field3</li></ul></li></ul></li></ul>", (Object)this.mouseMoveHandler.generateFieldsHierarchy(Arrays.asList("Field1", "Field2", "Field3")));
    }
}

