/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.webapp.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.ScenarioSimulationEditorKogitoWrapper;
import org.drools.workbench.screens.scenariosimulation.webapp.client.editor.AbstractScenarioSimulationEditorKogitoScreen;
import org.drools.workbench.screens.scenariosimulation.webapp.client.popup.ScenarioKogitoCreationPopupPresenter;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractScenarioSimulationEditorKogitoScreenTest {
    @Mock
    private ScenarioSimulationEditorKogitoWrapper scenarioSimulationEditorKogitoWrapperMock;
    @Mock
    private KogitoScenarioSimulationBuilder scenarioSimulationBuilderMock;
    @Mock
    private ScenarioKogitoCreationPopupPresenter scenarioKogitoCreationPopupPresenterMock;
    @Captor
    private ArgumentCaptor<Command> createCommandCaptor;
    @Captor
    private ArgumentCaptor<RemoteCallback> remoteCallbackArgumentCaptor;
    @Captor
    private ArgumentCaptor<Path> pathArgumentCaptor;
    private AbstractScenarioSimulationEditorKogitoScreen abstractScenarioSimulationEditorKogitoScreenSpy;

    @Before
    public void setup() {
        this.abstractScenarioSimulationEditorKogitoScreenSpy = (AbstractScenarioSimulationEditorKogitoScreen)Mockito.spy((Object)new AbstractScenarioSimulationEditorKogitoScreen(){
            {
                this.scenarioKogitoCreationPopupPresenter = AbstractScenarioSimulationEditorKogitoScreenTest.this.scenarioKogitoCreationPopupPresenterMock;
                this.scenarioSimulationBuilder = AbstractScenarioSimulationEditorKogitoScreenTest.this.scenarioSimulationBuilderMock;
                this.scenarioSimulationEditorKogitoWrapper = AbstractScenarioSimulationEditorKogitoScreenTest.this.scenarioSimulationEditorKogitoWrapperMock;
            }

            public PlaceRequest getPlaceRequest() {
                return null;
            }

            protected void showPopover(String title, String content) {
            }
        });
        Mockito.when((Object)this.scenarioKogitoCreationPopupPresenterMock.getSelectedPath()).thenReturn((Object)"selected");
    }

    @Test
    public void newFileEmptySelectedType() {
        PathFactory.PathImpl path = new PathFactory.PathImpl("file.scesim", "path/");
        this.abstractScenarioSimulationEditorKogitoScreenSpy.newFile((Path)path);
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.isA(String.class), (Command)this.createCommandCaptor.capture());
        ((Command)this.createCommandCaptor.getValue()).execute();
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((AbstractScenarioSimulationEditorKogitoScreen)Mockito.verify((Object)this.abstractScenarioSimulationEditorKogitoScreenSpy, (VerificationMode)Mockito.times((int)1))).showPopover((String)Matchers.eq((Object)"ERROR"), (String)Matchers.eq((Object)"Missing selected type"));
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.scenarioSimulationBuilderMock, (VerificationMode)Mockito.never())).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.isA(ScenarioSimulationModel.class), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE), (String)Matchers.eq((Object)""), (RemoteCallback)this.remoteCallbackArgumentCaptor.capture());
    }

    @Test
    public void newFileEmptySelectedDMNPath() {
        Mockito.when((Object)this.scenarioKogitoCreationPopupPresenterMock.getSelectedPath()).thenReturn(null);
        Mockito.when((Object)this.scenarioKogitoCreationPopupPresenterMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        PathFactory.PathImpl path = new PathFactory.PathImpl("file.scesim", "path/");
        this.abstractScenarioSimulationEditorKogitoScreenSpy.newFile((Path)path);
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.isA(String.class), (Command)this.createCommandCaptor.capture());
        ((Command)this.createCommandCaptor.getValue()).execute();
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((AbstractScenarioSimulationEditorKogitoScreen)Mockito.verify((Object)this.abstractScenarioSimulationEditorKogitoScreenSpy, (VerificationMode)Mockito.times((int)1))).showPopover((String)Matchers.eq((Object)"ERROR"), (String)Matchers.eq((Object)"Missing dmn path"));
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.scenarioSimulationBuilderMock, (VerificationMode)Mockito.never())).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.isA(ScenarioSimulationModel.class), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE), (String)Matchers.eq((Object)""), (RemoteCallback)this.remoteCallbackArgumentCaptor.capture());
    }

    @Test
    public void newFileRule() {
        Mockito.when((Object)this.scenarioKogitoCreationPopupPresenterMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        PathFactory.PathImpl path = new PathFactory.PathImpl("file.scesim", "path/");
        this.abstractScenarioSimulationEditorKogitoScreenSpy.newFile((Path)path);
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.isA(String.class), (Command)this.createCommandCaptor.capture());
        ((Command)this.createCommandCaptor.getValue()).execute();
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.scenarioSimulationBuilderMock, (VerificationMode)Mockito.times((int)1))).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.isA(ScenarioSimulationModel.class), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE), (String)Matchers.eq((Object)""), (RemoteCallback)this.remoteCallbackArgumentCaptor.capture());
        ((RemoteCallback)this.remoteCallbackArgumentCaptor.getValue()).callback((Object)"");
        ((AbstractScenarioSimulationEditorKogitoScreen)Mockito.verify((Object)this.abstractScenarioSimulationEditorKogitoScreenSpy, (VerificationMode)Mockito.times((int)1))).saveFile((Path)this.pathArgumentCaptor.capture(), (String)Matchers.isA(String.class));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperMock, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)Matchers.eq((Object)this.pathArgumentCaptor.getValue()));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperMock, (VerificationMode)Mockito.times((int)1))).setContent((String)Matchers.eq((Object)"path/file.scesim"), (String)Matchers.isA(String.class));
        Assert.assertEquals((Object)"path/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
        Assert.assertEquals((Object)"file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
    }

    @Test
    public void newFileDMN() {
        Mockito.when((Object)this.scenarioKogitoCreationPopupPresenterMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        PathFactory.PathImpl path = new PathFactory.PathImpl("file.scesim", "path/");
        this.abstractScenarioSimulationEditorKogitoScreenSpy.newFile((Path)path);
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.isA(String.class), (Command)this.createCommandCaptor.capture());
        ((Command)this.createCommandCaptor.getValue()).execute();
        ((ScenarioKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.scenarioSimulationBuilderMock, (VerificationMode)Mockito.times((int)1))).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.isA(ScenarioSimulationModel.class), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN), (String)Matchers.eq((Object)"selected"), (RemoteCallback)this.remoteCallbackArgumentCaptor.capture());
        ((RemoteCallback)this.remoteCallbackArgumentCaptor.getValue()).callback((Object)"");
        ((AbstractScenarioSimulationEditorKogitoScreen)Mockito.verify((Object)this.abstractScenarioSimulationEditorKogitoScreenSpy, (VerificationMode)Mockito.times((int)1))).saveFile((Path)this.pathArgumentCaptor.capture(), (String)Matchers.isA(String.class));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperMock, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)Matchers.eq((Object)this.pathArgumentCaptor.getValue()));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperMock, (VerificationMode)Mockito.times((int)1))).setContent((String)Matchers.eq((Object)"path/file.scesim"), (String)Matchers.isA(String.class));
        Assert.assertEquals((Object)"path/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
        Assert.assertEquals((Object)"file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
    }
}

