/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.webapp.client.editor;

import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.ScenarioSimulationEditorKogitoWrapper;
import org.drools.workbench.screens.scenariosimulation.webapp.client.popup.ScenarioKogitoCreationPopupPresenter;
import org.gwtbootstrap3.client.ui.Popover;
import org.kie.workbench.common.kogito.webapp.base.client.editor.KogitoScreen;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.Command;

public abstract class AbstractScenarioSimulationEditorKogitoScreen
implements KogitoScreen {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    public static final String TITLE = "Scenario Simulation - Kogito";
    @Inject
    protected ScenarioSimulationEditorKogitoWrapper scenarioSimulationEditorKogitoWrapper;
    @Inject
    protected KogitoScenarioSimulationBuilder scenarioSimulationBuilder;
    @Inject
    protected ScenarioKogitoCreationPopupPresenter scenarioKogitoCreationPopupPresenter;

    protected void newFile(Path path) {
        Command createCommand = () -> {
            ScenarioSimulationModel.Type selectedType = this.scenarioKogitoCreationPopupPresenter.getSelectedType();
            if (selectedType == null) {
                this.showPopover("ERROR", "Missing selected type");
                return;
            }
            String value = "";
            if (ScenarioSimulationModel.Type.DMN.equals((Object)selectedType) && ((value = this.scenarioKogitoCreationPopupPresenter.getSelectedPath()) == null || value.isEmpty())) {
                this.showPopover("ERROR", "Missing dmn path");
                return;
            }
            this.scenarioSimulationBuilder.populateScenarioSimulationModel(new ScenarioSimulationModel(), selectedType, value, content -> {
                this.saveFile(path, (String)content);
                this.scenarioSimulationEditorKogitoWrapper.gotoPath(path);
                this.scenarioSimulationEditorKogitoWrapper.setContent(path.toURI() + path.getFileName(), content);
            });
        };
        this.scenarioKogitoCreationPopupPresenter.show("Create new Test Scenario", createCommand);
    }

    protected void showPopover(String title, String content) {
        new Popover(title, content).show();
    }

    protected void saveFile(Path path, String content) {
    }
}

