/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.webapp.client.popup;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.popup.AbstractScenarioPopupView;
import org.drools.workbench.screens.scenariosimulation.webapp.client.dropdown.ScenarioKogitoCreationAssetsDropdown;
import org.drools.workbench.screens.scenariosimulation.webapp.client.popup.ScenarioKogitoCreationPopup;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ScenarioKogitoCreationPopupView
extends AbstractScenarioPopupView
implements ScenarioKogitoCreationPopup {
    @Inject
    @DataField(value="rule-button")
    protected HTMLInputElement ruleButton;
    @Inject
    @DataField(value="dmn-button")
    protected HTMLInputElement dmnButton;
    @Inject
    @DataField(value="dmn-assets")
    protected HTMLDivElement divElement;
    protected ScenarioSimulationModel.Type selectedType = null;
    protected String selectedPath = null;
    @Inject
    protected ScenarioKogitoCreationAssetsDropdown scenarioKogitoCreationAssetsDropdown;

    @Override
    public void show(String mainTitleText, Command okCommand) {
        this.initialize();
        super.show(mainTitleText, "Create", okCommand);
    }

    protected void initialize() {
        this.okButton.setEnabled(false);
        this.cancelButton.setText("Cancel");
        this.divElement.setAttribute("hidden", "");
        this.ruleButton.checked = false;
        this.dmnButton.checked = false;
        this.divElement.appendChild((Node)this.scenarioKogitoCreationAssetsDropdown.getElement());
        this.scenarioKogitoCreationAssetsDropdown.clear();
        this.scenarioKogitoCreationAssetsDropdown.init();
        this.scenarioKogitoCreationAssetsDropdown.initializeDropdown();
        this.scenarioKogitoCreationAssetsDropdown.registerOnChangeHandler(() -> {
            Optional value = this.scenarioKogitoCreationAssetsDropdown.getValue();
            this.selectedPath = value.map(KieAssetsDropdownItem::getValue).orElse(null);
        });
    }

    @Override
    public ScenarioSimulationModel.Type getSelectedType() {
        return this.selectedType;
    }

    @Override
    public String getSelectedPath() {
        return this.selectedPath;
    }

    @EventHandler(value={"dmn-button"})
    public void onDmnClick(ClickEvent event) {
        if (this.dmnButton.checked) {
            this.selectedType = ScenarioSimulationModel.Type.DMN;
            this.divElement.removeAttribute("hidden");
            this.okButton.setEnabled(true);
        }
    }

    @EventHandler(value={"rule-button"})
    public void onRuleClick(ClickEvent event) {
        if (this.ruleButton.checked) {
            this.selectedType = ScenarioSimulationModel.Type.RULE;
            this.divElement.setAttribute("hidden", "");
            this.okButton.setEnabled(true);
        }
    }
}

