/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.testscenario.model.Failure;
import org.drools.workbench.screens.testscenario.model.TestResultMessage;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class CustomJUnitRunNotifier
extends RunNotifier {
    private final Event<TestResultMessage> testResultMessageEvent;

    public CustomJUnitRunNotifier(Event<TestResultMessage> testResultMessageEvent) {
        this.testResultMessageEvent = testResultMessageEvent;
        this.addListener(new RunListener(){

            public void testFinished(Description description) throws Exception {
                CustomJUnitRunNotifier.this.reportTestSuccess();
            }

            public void testFailure(org.junit.runner.notification.Failure failure) throws Exception {
                CustomJUnitRunNotifier.this.reportTestFailure(failure);
            }

            public void testAssumptionFailure(org.junit.runner.notification.Failure failure) {
                CustomJUnitRunNotifier.this.reportTestFailure(failure);
            }

            public void testRunFinished(Result result) throws Exception {
                CustomJUnitRunNotifier.this.reportTestRunResult(result);
            }
        });
    }

    private void reportTestRunResult(Result result) {
        this.testResultMessageEvent.fire((Object)new TestResultMessage(result.wasSuccessful(), result.getRunCount(), result.getFailureCount(), this.getFailures(result.getFailures())));
    }

    private void reportTestSuccess() {
        this.testResultMessageEvent.fire((Object)new TestResultMessage(true, 1, 1, new ArrayList()));
    }

    private void reportTestFailure(org.junit.runner.notification.Failure failure) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        failures.add(this.failureToFailure(failure));
        this.testResultMessageEvent.fire((Object)new TestResultMessage(false, 1, 1, failures));
    }

    private List<Failure> getFailures(List<org.junit.runner.notification.Failure> failures) {
        ArrayList<Failure> result = new ArrayList<Failure>();
        for (org.junit.runner.notification.Failure failure : failures) {
            result.add(this.failureToFailure(failure));
        }
        return result;
    }

    private Failure failureToFailure(org.junit.runner.notification.Failure failure) {
        return new Failure(failure.getDescription().getDisplayName(), failure.getMessage());
    }
}

