/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.testscenarios.backend.util.ScenarioXMLPersistence;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerWrapper;
import org.drools.workbench.screens.testscenario.backend.server.TestScenarioModelVisitor;
import org.drools.workbench.screens.testscenario.model.TestResultMessage;
import org.drools.workbench.screens.testscenario.model.TestScenarioModelContent;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedFilter;
import org.guvnor.common.services.backend.file.LinkedMetaInfFolderFilter;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.runtime.KieSession;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ScenarioTestEditorServiceImpl
implements ScenarioTestEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private SessionService sessionService;
    @Inject
    private ProjectService projectService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<TestResultMessage> testResultMessageEvent;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private ConfigurationService configurationService;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, Scenario content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, ScenarioXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Scenario load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            Scenario scenario = ScenarioXMLPersistence.getInstance().unmarshal(content);
            scenario.setName(path.getFileName());
            return scenario;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, Scenario content, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), ScenarioXMLPersistence.getInstance().marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        return new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
    }

    public TestScenarioModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            Scenario scenario = this.load(path);
            String packageName = this.projectService.resolvePackage(path).getPackageName();
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
            TestScenarioModelVisitor visitor = new TestScenarioModelVisitor(dataModel, scenario);
            DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, visitor.visit());
            return new TestScenarioModelContent(scenario, packageName, dataModel);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void runScenario(org.uberfire.backend.vfs.Path path, Scenario scenario) {
        try {
            Project project = this.projectService.resolveProject(path);
            KieSession session = this.sessionService.newKieSession(project);
            ScenarioRunnerWrapper runner = new ScenarioRunnerWrapper(this.testResultMessageEvent, this.getMaxRuleFirings());
            runner.run(scenario, session);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private int getMaxRuleFirings() {
        for (ConfigGroup editorConfigGroup : this.configurationService.getConfiguration(ConfigType.EDITOR)) {
            if (!"test-scenario-editor-settings".equals(editorConfigGroup.getName())) continue;
            for (ConfigItem item : editorConfigGroup.getItems()) {
                String itemName = item.getName();
                if (!itemName.equals("max-rule-firings")) continue;
                return (Integer)item.getValue();
            }
        }
        return 0;
    }

    public void runAllScenarios(org.uberfire.backend.vfs.Path testResourcePath) {
        this.runAllScenarios(testResourcePath, this.testResultMessageEvent);
    }

    public void runAllScenarios(org.uberfire.backend.vfs.Path testResourcePath, Event<TestResultMessage> customTestResultEvent) {
        try {
            Project project = this.projectService.resolveProject(testResourcePath);
            List<org.uberfire.backend.vfs.Path> scenarioPaths = this.loadScenarioPaths(testResourcePath);
            ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
            for (org.uberfire.backend.vfs.Path path : scenarioPaths) {
                Scenario s = this.load(path);
                scenarios.add(s);
            }
            new ScenarioRunnerWrapper(this.testResultMessageEvent, this.getMaxRuleFirings()).run(scenarios, this.sessionService.newKieSession(project));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<org.uberfire.backend.vfs.Path> loadScenarioPaths(org.uberfire.backend.vfs.Path path) {
        try {
            ArrayList<org.uberfire.backend.vfs.Path> items = new ArrayList<org.uberfire.backend.vfs.Path>();
            if (!Files.exists((Path)Paths.convert((org.uberfire.backend.vfs.Path)path), (LinkOption[])new LinkOption[0])) {
                return items;
            }
            Path pPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            if (!Files.isDirectory((Path)pPath, (LinkOption[])new LinkOption[0])) {
                pPath = pPath.getParent();
            }
            LinkedDotFileFilter filter = new LinkedDotFileFilter();
            LinkedMetaInfFolderFilter metaInfFolderFilter = new LinkedMetaInfFolderFilter();
            filter.setNextFilter((LinkedFilter)metaInfFolderFilter);
            FileExtensionFilter fileExtensionFilter = new FileExtensionFilter(".scenario");
            DirectoryStream directoryStream = this.ioService.newDirectoryStream(pPath);
            for (Path p : directoryStream) {
                if (!filter.accept((Object)p) || !fileExtensionFilter.accept(p)) continue;
                if (Files.isRegularFile((Path)p, (LinkOption[])new LinkOption[0])) {
                    items.add(Paths.convert((Path)p));
                    continue;
                }
                if (!Files.isDirectory((Path)p, (LinkOption[])new LinkOption[0])) continue;
                items.add(Paths.convert((Path)p));
            }
            return items;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

