/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Field;
import org.drools.workbench.models.testscenarios.shared.FieldData;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyFact;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.drools.workbench.models.testscenarios.shared.VerifyRuleFired;

public class TestScenarioFactory {
    public static Scenario makeTestScenarioWithVerifyFact(String packageName, Collection<Import> imports, String name) {
        Scenario model = new Scenario();
        model.getImports().getImports().addAll(imports);
        model.setPackageName(packageName);
        model.setName(name);
        model.getFixtures().add(new FactData("Applicant", "$a", (List)new ArrayList<Field>(){
            {
                this.add(new FieldData("age", "33"));
            }
        }, false));
        model.getFixtures().add(new VerifyFact("Mortgage", (List)new ArrayList<VerifyField>(){
            {
                this.add(new VerifyField("amount", "10000", "=="));
            }
        }, true));
        return model;
    }

    public static Scenario makeTestScenarioWithoutVerifyFact(String packageName, Collection<Import> imports, String name) {
        Scenario model = new Scenario();
        model.getImports().getImports().addAll(imports);
        model.setPackageName(packageName);
        model.setName(name);
        model.getFixtures().add(new FactData("Applicant", "$a", (List)new ArrayList<Field>(){
            {
                this.add(new FieldData("age", "33"));
            }
        }, false));
        return model;
    }

    public static Scenario makeTestScenarioWithVerifyRuleFired(String packageName, Collection<Import> imports, String name) {
        Scenario model = new Scenario();
        model.getImports().getImports().addAll(imports);
        model.setPackageName(packageName);
        model.setName(name);
        model.getFixtures().add(new VerifyRuleFired("test", Integer.valueOf(1), Boolean.valueOf(true)));
        return model;
    }
}

