/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.HashSet;
import java.util.Set;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;

public class AuditLogger {
    private final Set<String> logs = new HashSet<String>();
    private final KieSession ksession;

    public AuditLogger(KieSession ksession) {
        this.ksession = ksession;
        this.addRuleRuntimeEventListener();
        this.addAgendaEventListener();
        this.addProcessEventListener();
    }

    public Set<String> getLog() {
        return this.logs;
    }

    private void addProcessEventListener() {
        this.ksession.addEventListener(new ProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent processStartedEvent) {
                AuditLogger.this.log(processStartedEvent);
            }

            public void afterProcessStarted(ProcessStartedEvent processStartedEvent) {
                AuditLogger.this.log(processStartedEvent);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent processCompletedEvent) {
                AuditLogger.this.log(processCompletedEvent);
            }

            public void afterProcessCompleted(ProcessCompletedEvent processCompletedEvent) {
                AuditLogger.this.log(processCompletedEvent);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent processNodeTriggeredEvent) {
                AuditLogger.this.log(processNodeTriggeredEvent);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent processNodeTriggeredEvent) {
                AuditLogger.this.log(processNodeTriggeredEvent);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent processNodeLeftEvent) {
                AuditLogger.this.log(processNodeLeftEvent);
            }

            public void afterNodeLeft(ProcessNodeLeftEvent processNodeLeftEvent) {
                AuditLogger.this.log(processNodeLeftEvent);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent processVariableChangedEvent) {
                AuditLogger.this.log(processVariableChangedEvent);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent processVariableChangedEvent) {
                AuditLogger.this.log(processVariableChangedEvent);
            }
        });
    }

    private void addAgendaEventListener() {
        this.ksession.addEventListener(new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent matchCreatedEvent) {
                AuditLogger.this.log(matchCreatedEvent);
            }

            public void matchCancelled(MatchCancelledEvent matchCancelledEvent) {
                AuditLogger.this.log(matchCancelledEvent);
            }

            public void beforeMatchFired(BeforeMatchFiredEvent beforeMatchFiredEvent) {
            }

            public void afterMatchFired(AfterMatchFiredEvent afterMatchFiredEvent) {
                AuditLogger.this.logs.add("Rule " + afterMatchFiredEvent.getMatch().getRule() + " fired.");
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent agendaGroupPoppedEvent) {
                AuditLogger.this.log(agendaGroupPoppedEvent);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent agendaGroupPushedEvent) {
                AuditLogger.this.log(agendaGroupPushedEvent);
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent ruleFlowGroupActivatedEvent) {
                AuditLogger.this.log(ruleFlowGroupActivatedEvent);
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent ruleFlowGroupActivatedEvent) {
                AuditLogger.this.log(ruleFlowGroupActivatedEvent);
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent ruleFlowGroupDeactivatedEvent) {
                AuditLogger.this.log(ruleFlowGroupDeactivatedEvent);
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent ruleFlowGroupDeactivatedEvent) {
                AuditLogger.this.log(ruleFlowGroupDeactivatedEvent);
            }
        });
    }

    private void addRuleRuntimeEventListener() {
        this.ksession.addEventListener(new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent objectInsertedEvent) {
                Object object = objectInsertedEvent.getObject();
                Rule rule = objectInsertedEvent.getRule();
                if (rule == null) {
                    AuditLogger.this.logs.add("Fact " + object.getClass().getName() + " inserted.");
                } else {
                    AuditLogger.this.logs.add("Fact " + object.getClass().getName() + " inserted in rule " + rule.getName() + ". Fact[ " + object.toString() + " ].");
                }
            }

            public void objectUpdated(ObjectUpdatedEvent objectUpdatedEvent) {
                Object object = objectUpdatedEvent.getObject();
                Rule rule = objectUpdatedEvent.getRule();
                Object oldObject = objectUpdatedEvent.getOldObject();
                if (rule == null) {
                    AuditLogger.this.logs.add("Object " + object.getClass().getName() + " updated. Old fact[ " + oldObject.toString() + " ]. New fact[ " + object.toString() + " ].");
                } else {
                    AuditLogger.this.logs.add("Object " + object.getClass().getName() + " updated in rule " + rule.getName() + ". Old fact[ " + oldObject.toString() + " ]. New fact[ " + object.toString() + " ].");
                }
            }

            public void objectDeleted(ObjectDeletedEvent objectDeletedEvent) {
                Object oldObject = objectDeletedEvent.getOldObject();
                Rule rule = objectDeletedEvent.getRule();
                if (rule == null) {
                    AuditLogger.this.logs.add("Object " + oldObject.getClass().getName() + " deleted. Fact[ " + oldObject.toString() + " ].");
                } else {
                    AuditLogger.this.logs.add("Object " + oldObject.getClass().getName() + " deleted in rule " + rule.getName() + ". Fact[ " + oldObject.toString() + " ].");
                }
            }
        });
    }

    private void log(Object o) {
        this.logs.add(o.toString());
    }
}

