/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class CustomJUnitRunNotifier
extends RunNotifier {
    private String identifier;
    private final Event<TestResultMessage> testResultMessageEvent;
    private ArrayList<Failure> failures = new ArrayList();
    private int testsSucceeded = 0;

    public CustomJUnitRunNotifier(String identifier, Event<TestResultMessage> testResultMessageEvent) {
        this.identifier = identifier;
        this.testResultMessageEvent = testResultMessageEvent;
        this.addListener(new RunListener(){

            public void testFinished(Description description) throws Exception {
                CustomJUnitRunNotifier.this.testsSucceeded++;
            }

            public void testFailure(org.junit.runner.notification.Failure failure) throws Exception {
                CustomJUnitRunNotifier.this.addTestFailure(failure);
            }

            public void testAssumptionFailure(org.junit.runner.notification.Failure failure) {
                CustomJUnitRunNotifier.this.addTestFailure(failure);
            }

            public void testRunFinished(Result result) throws Exception {
            }
        });
    }

    private void reportTestSuccess() {
        this.fireMessageEvent(new TestResultMessage(this.identifier, this.amountOfTestsRan(), new ArrayList()));
    }

    public void fireNotificationEvent() {
        if (this.failures.isEmpty()) {
            this.reportTestSuccess();
        } else {
            this.fireMessageEvent(new TestResultMessage(this.identifier, this.amountOfTestsRan(), this.failures));
        }
    }

    private int amountOfTestsRan() {
        return this.testsSucceeded + this.failures.size();
    }

    private void addTestFailure(org.junit.runner.notification.Failure failure) {
        this.failures.add(this.failureToFailure(failure));
    }

    private void fireMessageEvent(TestResultMessage testResultMessage) {
        this.testResultMessageEvent.fire((Object)testResultMessage);
    }

    private Failure failureToFailure(org.junit.runner.notification.Failure failure) {
        return new Failure(this.getScenarioName(failure), failure.getMessage());
    }

    private String getScenarioName(org.junit.runner.notification.Failure failure) {
        return failure.getDescription().getDisplayName().substring(0, failure.getDescription().getDisplayName().indexOf(".scenario"));
    }
}

