/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.testscenarios.backend.util.ScenarioXMLPersistence;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.indexing.TestScenarioFactory;
import org.drools.workbench.screens.testscenario.backend.server.indexing.TestTestScenarioFileIndexer;
import org.drools.workbench.screens.testscenario.type.TestScenarioResourceTypeDefinition;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.BasicQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IndexTestScenarioTest
extends BaseIndexingTest<TestScenarioResourceTypeDefinition> {
    @Test
    public void testIndexTestScenario() throws IOException, InterruptedException {
        Path path1 = this.basePath.resolve("scenario1.scenario");
        Scenario model1 = TestScenarioFactory.makeTestScenarioWithVerifyFact("org.drools.workbench.screens.testscenario.backend.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Applicant"));
                this.add(new Import("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Mortgage"));
            }
        }, "scenario1");
        String xml1 = ScenarioXMLPersistence.getInstance().marshal(model1);
        this.ioService().write(path1, xml1, new OpenOption[0]);
        Path path2 = this.basePath.resolve("scenario2.scenario");
        Scenario model2 = TestScenarioFactory.makeTestScenarioWithoutVerifyFact("org.drools.workbench.screens.testscenario.backend.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Applicant"));
                this.add(new Import("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Mortgage"));
            }
        }, "scenario2");
        String xml2 = ScenarioXMLPersistence.getInstance().marshal(model2);
        this.ioService().write(path2, xml2, new OpenOption[0]);
        Path path3 = this.basePath.resolve("scenario3.scenario");
        Scenario model3 = TestScenarioFactory.makeTestScenarioWithVerifyRuleFired("org.drools.workbench.screens.testscenario.backend.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Applicant"));
                this.add(new Import("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Mortgage"));
            }
        }, "scenario3");
        String xml3 = ScenarioXMLPersistence.getInstance().marshal(model3);
        this.ioService().write(path3, xml3, new OpenOption[0]);
        Path path4 = this.basePath.resolve("scenario4.scenario");
        Scenario model4 = TestScenarioFactory.makeTestScenarioWithGlobalVerifyGlobal("org.drools.workbench.screens.testscenario.backend.server.indexing", (Collection<Import>)new ArrayList<Import>(){
            {
                this.add(new Import("java.util.Date"));
            }
        }, "scenario1");
        String xml4 = ScenarioXMLPersistence.getInstance().marshal(model4);
        this.ioService().write(path4, xml4, new OpenOption[0]);
        Thread.sleep(5000L);
        Index index = IndexTestScenarioTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Applicant")).build();
        this.searchFor(index, query, 2, new Path[]{path1, path2});
        query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Mortgage")).build();
        this.searchFor(index, query, 1, new Path[]{path1});
        query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("org.drools.workbench.screens.testscenario.backend.server.indexing.classes.Mortgage")).addTerm((ValueIndexTerm)new ValueFieldIndexTerm("amount")).build();
        this.searchFor(index, query, 1, new Path[]{path1});
        query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("java.lang.Integer")).build();
        this.searchFor(index, query, 3, new Path[]{path1, path2});
        query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueRuleIndexTerm("test")).build();
        this.searchFor(index, query, 1, new Path[]{path3});
        query = new BasicQueryBuilder().addTerm((ValueIndexTerm)new ValueTypeIndexTerm("java.util.Date")).build();
        this.searchFor(index, query, 1, new Path[]{path4});
    }

    protected TestIndexer getIndexer() {
        return new TestTestScenarioFileIndexer();
    }

    public Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleAttribute", new RuleAttributeNameAnalyzer());
            }
        };
    }

    protected TestScenarioResourceTypeDefinition getResourceTypeDefinition() {
        return new TestScenarioResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

