/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioLoader;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerService;
import org.drools.workbench.screens.testscenario.model.TestScenarioResult;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.structure.server.config.ConfigurationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerServiceTest {
    @Mock
    ScenarioLoader scenarioLoader;
    private ScenarioRunnerService service;
    @Mock
    private KieSession defaultPseudoClockKieSession;
    @Mock
    private SessionService sessionService;
    private TestResultMessageEventMock defaultTestResultMessageEvent;

    @Before
    public void setUp() throws Exception {
        ConfigurationService configurationService = (ConfigurationService)Mockito.mock(ConfigurationService.class);
        KieProjectService projectService = (KieProjectService)Mockito.mock(KieProjectService.class);
        this.defaultTestResultMessageEvent = (TestResultMessageEventMock)Mockito.spy((Object)new TestResultMessageEventMock());
        this.service = new ScenarioRunnerService(configurationService, (Event)this.defaultTestResultMessageEvent, this.sessionService, projectService, this.scenarioLoader);
        Mockito.when((Object)this.sessionService.newDefaultKieSessionWithPseudoClock((KieProject)Mockito.any(KieProject.class))).thenReturn((Object)this.defaultPseudoClockKieSession);
    }

    @Test
    public void testRunEmptyScenario() throws Exception {
        TestScenarioResult result = this.service.run("userName", this.makeScenario("test.scenario"), new KieProject());
        Assert.assertNotNull((Object)result);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(TestResultMessage.class);
        ((TestResultMessageEventMock)Mockito.verify((Object)this.defaultTestResultMessageEvent)).fire((TestResultMessage)argumentCaptor.capture());
        Assert.assertEquals((Object)"userName", (Object)((TestResultMessage)argumentCaptor.getValue()).getIdentifier());
    }

    @Test
    public void testRunSeveralScenarios() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        scenarios.add(this.makeScenario("test1.scenario"));
        scenarios.add(this.makeScenario("test2.scenario"));
        scenarios.add(this.makeScenario("test3.scenario"));
        Mockito.when((Object)this.scenarioLoader.loadScenarios(path)).thenReturn(scenarios);
        this.service.runAllTests("userName", path);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(TestResultMessage.class);
        ((TestResultMessageEventMock)Mockito.verify((Object)this.defaultTestResultMessageEvent)).fire((TestResultMessage)argumentCaptor.capture());
        Assert.assertEquals((Object)"userName", (Object)((TestResultMessage)argumentCaptor.getValue()).getIdentifier());
    }

    private Scenario makeScenario(String name) {
        Scenario scenario = new Scenario();
        scenario.setName(name);
        return scenario;
    }

    class TestResultMessageEventMock
    implements Event<TestResultMessage> {
        TestResultMessageEventMock() {
        }

        public void fire(TestResultMessage testResultMessage) {
        }

        public Event<TestResultMessage> select(Annotation ... annotations) {
            return null;
        }

        public <U extends TestResultMessage> Event<U> select(Class<U> aClass, Annotation ... annotations) {
            return null;
        }
    }
}

