/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerService;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioTestEditorServiceImpl;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioTestEditorServiceImplTest {
    @Mock
    Scenario scenario;
    @Mock
    Path path;
    @Mock
    PackageDataModelOracle modelOracle;
    @Mock
    DataModelService dataModelService;
    @Mock
    ScenarioRunnerService scenarioRunner;
    @Mock
    KieProjectService projectService;
    @InjectMocks
    ScenarioTestEditorServiceImpl testEditorService = new ScenarioTestEditorServiceImpl();

    @Test
    public void runScenarioWithoutDependentImports() throws Exception {
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.scenario.getImports()).thenReturn((Object)new Imports());
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)0L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void runScenarioWithDependentImports() throws Exception {
        ArrayList<Fixture> fixtures = new ArrayList<Fixture>(){
            {
                this.add(ScenarioTestEditorServiceImplTest.this.factData("java.sql.ClientInfoStatus"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn((Object)fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getProjectModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenReturn((Object)new Imports());
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)2L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void runScenarioWithDependentImportsAndWithoutFactData() throws Exception {
        ArrayList fixtures = new ArrayList();
        Imports imports = new Imports(){
            {
                this.addImport(new Import("java.sql.ClientInfoStatus"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn(fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getProjectModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenReturn((Object)imports);
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)2L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void checkDependentImportsWithPrimitiveTypes() throws Exception {
        ArrayList fixtures = new ArrayList();
        Imports imports = new Imports(){
            {
                this.addImport(new Import("int"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn(fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getProjectModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenCallRealMethod();
        ((Scenario)Mockito.doCallRealMethod().when((Object)this.scenario)).setImports((Imports)Mockito.any(Imports.class));
        this.scenario.setImports(imports);
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)1L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void checkSingleScenarioMultipleExecution() throws Exception {
        ArrayList fixtures = new ArrayList();
        Imports imports = new Imports(){
            {
                this.addImport(new Import("java.sql.ClientInfoStatus"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn(fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getProjectModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenCallRealMethod();
        ((Scenario)Mockito.doCallRealMethod().when((Object)this.scenario)).setImports((Imports)Mockito.any(Imports.class));
        this.scenario.setImports(imports);
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        Assert.assertEquals((long)1L, (long)this.scenario.getImports().getImports().size());
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        Assert.assertEquals((long)1L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void loadBrokenScenario() throws Exception {
        Package pgk = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)pgk.getPackageName()).thenReturn((Object)"org.test");
        Mockito.when((Object)this.projectService.resolvePackage(this.path)).thenReturn((Object)pgk);
        Scenario load = this.testEditorService.load(this.path);
        Assert.assertNotNull((Object)load);
        Assert.assertEquals((Object)"org.test", (Object)load.getPackageName());
        Assert.assertNotNull((Object)load.getImports());
    }

    @Test
    public void loadBrokenScenarioNullPackage() throws Exception {
        Mockito.when((Object)this.projectService.resolvePackage(this.path)).thenReturn(null);
        Scenario load = this.testEditorService.load(this.path);
        Assert.assertNotNull((Object)load);
        Assert.assertNull((Object)load.getPackageName());
        Assert.assertNotNull((Object)load.getImports());
    }

    @Test
    public void checkScenarioRunnerIsRan() throws Exception {
        Imports imports = new Imports(){
            {
                this.addImport(new Import("java.sql.ClientInfoStatus"));
            }
        };
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.scenario.getImports()).thenCallRealMethod();
        ((Scenario)Mockito.doCallRealMethod().when((Object)this.scenario)).setImports((Imports)Mockito.any(Imports.class));
        this.scenario.setImports(imports);
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        KieProject project = (KieProject)Mockito.mock(KieProject.class);
        Mockito.when((Object)this.projectService.resolveProject(this.path)).thenReturn((Object)project);
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        ((ScenarioRunnerService)Mockito.verify((Object)this.scenarioRunner)).run("userName", this.scenario, project);
    }

    private FactData factData(String type) {
        return new FactData(type, "", true);
    }

    private ModelField modelField(String className) {
        return new ModelField(null, className, null, null, null, null);
    }
}

