/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server.indexing;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Field;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.FixtureList;
import org.drools.workbench.models.testscenarios.shared.FixturesMap;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyFact;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.drools.workbench.models.testscenarios.shared.VerifyRuleFired;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.model.KProperty;

public class TestScenarioIndexVisitor
extends ResourceReferenceCollector {
    private final ProjectDataModelOracle dmo;
    private final DefaultIndexBuilder builder;
    private final Scenario model;
    private final Map<String, String> factDataToFullyQualifiedClassNameMap = new HashMap<String, String>();

    public TestScenarioIndexVisitor(ProjectDataModelOracle dmo, DefaultIndexBuilder builder, Scenario model) {
        this.dmo = (ProjectDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.model = (Scenario)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public Set<KProperty<?>> visit() {
        this.visit(this.model);
        return this.builder.build();
    }

    private void visit(Scenario scenario) {
        for (FactData global : scenario.getGlobals()) {
            this.visit((Fixture)global);
        }
        for (Fixture fixture : scenario.getFixtures()) {
            this.visit(fixture);
        }
    }

    private void visit(Fixture fixture) {
        if (fixture instanceof FixtureList) {
            for (Fixture child : (FixtureList)fixture) {
                this.visit(child);
            }
        } else if (fixture instanceof FixturesMap) {
            for (Fixture child : ((FixturesMap)fixture).values()) {
                this.visit(child);
            }
        } else if (fixture instanceof FactData) {
            FactData factData = (FactData)fixture;
            String typeName = factData.getType();
            String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
            ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
            this.factDataToFullyQualifiedClassNameMap.put(factData.getName(), fullyQualifiedClassName);
            for (Field field : factData.getFieldData()) {
                String fieldName = field.getName();
                String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
                resRef.addPartReference(fieldName, PartType.FIELD);
                this.addResourceReference(fieldFullyQualifiedClassName, ResourceType.JAVA);
            }
        } else if (fixture instanceof VerifyFact) {
            VerifyFact verifyFact = (VerifyFact)fixture;
            String typeName = verifyFact.getName();
            String fullyQualifiedClassName = null;
            fullyQualifiedClassName = !verifyFact.anonymous ? this.factDataToFullyQualifiedClassNameMap.get(verifyFact.getName()) : this.getFullyQualifiedClassName(typeName);
            ResourceReference resRef = null;
            if (fullyQualifiedClassName != null) {
                resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
                for (VerifyField field : verifyFact.getFieldValues()) {
                    String fieldName = field.getFieldName();
                    String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
                    resRef.addPartReference(fieldName, PartType.FIELD);
                    this.addResourceReference(fieldFullyQualifiedClassName, ResourceType.JAVA);
                }
            }
        } else if (fixture instanceof VerifyRuleFired) {
            VerifyRuleFired verifyRuleFired = (VerifyRuleFired)fixture;
            this.addResourceReference(verifyRuleFired.getRuleName(), ResourceType.RULE);
        }
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Import i : this.model.getImports().getImports()) {
            if (!i.getType().endsWith(typeName)) continue;
            return i.getType();
        }
        String packageName = this.model.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + "." + typeName : typeName;
    }

    private String getFieldFullyQualifiedClassName(String fullyQualifiedClassName, String fieldName) {
        ModelField[] mfs;
        for (ModelField mf : mfs = (ModelField[])this.dmo.getProjectModelFields().get(fullyQualifiedClassName)) {
            if (!mf.getName().equals(fieldName)) continue;
            return mf.getClassName();
        }
        return "Object";
    }
}

