/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.enterprise.event.Event;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioLoader;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerService;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioTestEditorServiceImpl;
import org.drools.workbench.screens.testscenario.model.TestScenarioResult;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.structure.server.config.ConfigurationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerServiceTest {
    @Mock
    private ScenarioLoader scenarioLoader;
    private ScenarioRunnerService service;
    @Captor
    private ArgumentCaptor<TestResultMessage> testResultMessageCaptor;
    @Spy
    private IOService ioService = new IOServiceDotFileImpl("testIoService");
    @InjectMocks
    private ScenarioTestEditorServiceImpl testEditorService = new ScenarioTestEditorServiceImpl();
    @Mock
    private SessionService sessionService;
    private TestResultMessageEventMock defaultTestResultMessageEvent;
    private KieSession kieSession;
    private KieContainer kieContainer;

    @Before
    public void setUp() throws Exception {
        ConfigurationService configurationService = (ConfigurationService)Mockito.mock(ConfigurationService.class);
        KieProjectService projectService = (KieProjectService)Mockito.mock(KieProjectService.class);
        this.defaultTestResultMessageEvent = (TestResultMessageEventMock)Mockito.spy((Object)new TestResultMessageEventMock());
        this.service = new ScenarioRunnerService(configurationService, (Event)this.defaultTestResultMessageEvent, this.sessionService, projectService, this.scenarioLoader);
    }

    @After
    public void tearDown() throws Exception {
        if (Objects.nonNull(this.kieSession)) {
            this.kieSession.dispose();
            this.kieSession.destroy();
        }
        if (Objects.nonNull(this.kieContainer)) {
            this.kieContainer.dispose();
        }
    }

    @Test
    public void testRunEmptyScenario() throws Exception {
        this.initKieSession(new String[0]);
        TestScenarioResult result = this.service.run("userName", this.makeScenario("test.scenario"), new KieProject());
        Assert.assertNotNull((Object)result);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(TestResultMessage.class);
        ((TestResultMessageEventMock)Mockito.verify((Object)this.defaultTestResultMessageEvent)).fire((TestResultMessage)argumentCaptor.capture());
        Assert.assertEquals((Object)"userName", (Object)((TestResultMessage)argumentCaptor.getValue()).getIdentifier());
    }

    @Test
    public void testGreetings() throws Exception {
        this.initKieSession("HelloEveryOne.gdst");
        this.testScenario("greetings.scenario", true);
    }

    @Test
    public void testHighAndSmall() throws Exception {
        this.initKieSession("thereIsHighPerson.rdrl", "thereAreBothHighAndSmallPerson.rdrl");
        this.testScenario("highAndSmall.scenario", true);
    }

    @Test
    public void testCouples() throws Exception {
        this.initKieSession("couplesWithSameEyes.xls");
        this.testScenario("testCouples.scenario", true);
    }

    @Test
    public void testCouplesNegative() throws Exception {
        this.initKieSession("couplesWithSameEyes.xls");
        this.testScenario("testCouplesNegative.scenario", false);
    }

    @Test
    public void testSimilarPerson() throws Exception {
        this.initKieSession("mostSimilarPerson.gdst");
        this.testScenario("testSimilarPerson.scenario", true);
    }

    @Test
    public void testSimilarPersonNegative() throws Exception {
        this.initKieSession("mostSimilarPerson.gdst");
        this.testScenario("testSimilarPersonNegative.scenario", false);
    }

    @Test
    public void testIsGithubContributor() throws Exception {
        this.initKieSession("isGithubContributor.gdst");
        this.testScenario("testContributors.scenario", true);
    }

    @Test
    public void testIsGithubContributorNegative() throws Exception {
        this.initKieSession("isGithubContributor.gdst");
        this.testScenario("testContributorsNegative.scenario", false);
    }

    @Test
    public void testMergeMolecules() throws Exception {
        this.initKieSession("mergeMolecules.gdst");
        this.testScenario("testMergedMolecules.scenario", true);
    }

    @Test
    public void testMergeMoleculesNegative() throws Exception {
        this.initKieSession("mergeMolecules.gdst");
        this.testScenario("testMergedMoleculesNegative.scenario", false);
    }

    @Test
    public void testAcidReactions() throws Exception {
        this.initKieSession("acidReactions.gdst");
        this.testScenario("testAcid.scenario", true);
    }

    @Test
    public void testAcidReactionsNegative() throws Exception {
        this.initKieSession("acidReactions.gdst");
        this.testScenario("testAcidNegative.scenario", false);
    }

    @Test
    public void testRunSeveralScenarios() throws Exception {
        this.initKieSession(new String[0]);
        Path path = (Path)Mockito.mock(Path.class);
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        scenarios.add(this.makeScenario("test1.scenario"));
        scenarios.add(this.makeScenario("test2.scenario"));
        scenarios.add(this.makeScenario("test3.scenario"));
        Mockito.when((Object)this.scenarioLoader.loadScenarios(path)).thenReturn(scenarios);
        this.service.runAllTests("userName", path);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(TestResultMessage.class);
        ((TestResultMessageEventMock)Mockito.verify((Object)this.defaultTestResultMessageEvent)).fire((TestResultMessage)argumentCaptor.capture());
        Assert.assertEquals((Object)"userName", (Object)((TestResultMessage)argumentCaptor.getValue()).getIdentifier());
    }

    private void testScenario(String scenarioName, boolean isExpectedSuccess) throws Exception {
        KieProject project = (KieProject)Mockito.mock(KieProject.class);
        URL scenarioResource = this.getClass().getResource(scenarioName);
        Path scenarioPath = PathFactory.newPath((String)scenarioResource.getFile(), (String)scenarioResource.toURI().toString());
        Scenario scenario = this.testEditorService.load(scenarioPath);
        Assert.assertFalse((boolean)scenario.wasSuccessful());
        TestScenarioResult result = this.service.run("userName", scenario, project);
        Assert.assertEquals((Object)isExpectedSuccess, (Object)scenario.wasSuccessful());
        Assert.assertEquals((Object)isExpectedSuccess, (Object)result.getScenario().wasSuccessful());
        ((TestResultMessageEventMock)Mockito.verify((Object)this.defaultTestResultMessageEvent)).fire((TestResultMessage)this.testResultMessageCaptor.capture());
        TestResultMessage resultMessage = (TestResultMessage)this.testResultMessageCaptor.getValue();
        Assert.assertEquals((Object)isExpectedSuccess, (Object)(resultMessage.getFailures().size() == 0 ? 1 : 0));
        Assert.assertEquals((Object)isExpectedSuccess, (Object)resultMessage.wasSuccessful());
    }

    private Scenario makeScenario(String name) {
        Scenario scenario = new Scenario();
        scenario.setName(name);
        return scenario;
    }

    private void initKieSession(String ... resourceNames) {
        KieServices kieServices = KieServices.Factory.get();
        KieModuleModel kieModuleModel = kieServices.newKieModuleModel();
        KieBaseModel kieBaseModel = kieModuleModel.newKieBaseModel("defaultKieBase").setDefault(true).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel.newKieSessionModel("defaultKieSession").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"pseudo")).newWorkItemHandlerModel("Rest", "org.drools.workbench.screens.testscenario.backend.server.GithubContributorsWIH");
        KieFileSystem kfs = kieServices.newKieFileSystem();
        kfs.writeKModuleXML(kieModuleModel.toXML());
        for (String resource : resourceNames) {
            kfs.write(ResourceFactory.newUrlResource((String)this.getClass().getResource(resource).toString()));
        }
        kieServices.newKieBuilder(kfs).buildAll();
        this.kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());
        this.kieSession = this.kieContainer.newKieSession();
        ((SessionService)Mockito.doReturn((Object)this.kieSession).when((Object)this.sessionService)).newDefaultKieSessionWithPseudoClock((KieProject)Mockito.any(KieProject.class));
    }

    class TestResultMessageEventMock
    implements Event<TestResultMessage> {
        TestResultMessageEventMock() {
        }

        public void fire(TestResultMessage testResultMessage) {
        }

        public Event<TestResultMessage> select(Annotation ... annotations) {
            return null;
        }

        public <U extends TestResultMessage> Event<U> select(Class<U> aClass, Annotation ... annotations) {
            return null;
        }
    }
}

