/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.testscenarios.shared.ExecutionTrace;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyFact;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerService;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioTestEditorServiceImpl;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioTestEditorServiceImplTest {
    public static final String EMPTY_SCENARIO_FILENAME = "empty.scenario";
    public static final String NEW_FILE_NAME = "newempty.scenario";
    private static final String COMMENT = "comment";
    @Mock
    Scenario scenario;
    @Mock
    org.uberfire.backend.vfs.Path path;
    @Mock
    PackageDataModelOracle modelOracle;
    @Mock
    DataModelService dataModelService;
    @Mock
    ScenarioRunnerService scenarioRunner;
    @Mock
    KieModuleService moduleService;
    @Mock
    CommentedOptionFactory commentedOptionFactory;
    @Mock
    MetadataServerSideService metadataService;
    @Mock
    CommentedOption commentedOption;
    @Mock
    DeleteService deleteService;
    @Mock
    RenameService renameService;
    @Mock
    CopyService copyService;
    @Mock
    SaveAndRenameServiceImpl<Scenario, Metadata> saveAndRenameService;
    @Spy
    IOService ioService = new IOServiceDotFileImpl("testIoService");
    @InjectMocks
    ScenarioTestEditorServiceImpl testEditorService = new ScenarioTestEditorServiceImpl();

    @Test
    public void testCreate() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        ((CommentedOptionFactory)Mockito.doReturn((Object)this.commentedOption).when((Object)this.commentedOptionFactory)).makeCommentedOption(COMMENT);
        ((IOService)Mockito.doReturn(null).when((Object)this.ioService)).write((Path)Mockito.any(), Mockito.anyString(), (OpenOption[])Mockito.any());
        this.testEditorService.create(scenarioPath, EMPTY_SCENARIO_FILENAME, this.scenario, COMMENT);
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)Mockito.any(), Mockito.anyString(), new OpenOption[]{(OpenOption)Mockito.eq((Object)this.commentedOption)});
    }

    @Test
    public void testCreateAlreadyExists() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        ((IOService)Mockito.doReturn((Object)true).when((Object)this.ioService)).exists(Paths.convert((org.uberfire.backend.vfs.Path)scenarioPath).resolve(EMPTY_SCENARIO_FILENAME));
        try {
            this.testEditorService.create(scenarioPath, EMPTY_SCENARIO_FILENAME, this.scenario, COMMENT);
        }
        catch (FileAlreadyExistsException e) {
            ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).write((Path)Mockito.any(), Mockito.anyString(), (OpenOption[])Mockito.any());
        }
    }

    @Test(expected=GenericPortableException.class)
    public void testCreateExceptionThrown() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        ((CommentedOptionFactory)Mockito.doReturn(null).when((Object)this.commentedOptionFactory)).makeCommentedOption(COMMENT);
        ((IOService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("error")}).when((Object)this.ioService)).write((Path)Mockito.any(), Mockito.anyString(), (OpenOption[])Mockito.any());
        this.testEditorService.create(scenarioPath, EMPTY_SCENARIO_FILENAME, this.scenario, COMMENT);
    }

    @Test
    public void testSave() throws Exception {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        Map emptyMap = Collections.emptyMap();
        ((MetadataServerSideService)Mockito.doReturn(emptyMap).when((Object)this.metadataService)).setUpAttributes(scenarioPath, metadata);
        ((CommentedOptionFactory)Mockito.doReturn((Object)this.commentedOption).when((Object)this.commentedOptionFactory)).makeCommentedOption(COMMENT);
        this.testEditorService.save(scenarioPath, this.scenario, metadata, COMMENT);
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)Mockito.any(Path.class), Mockito.anyString(), (Map)Mockito.eq(emptyMap), new OpenOption[]{(OpenOption)Mockito.eq((Object)this.commentedOption)});
    }

    @Test(expected=GenericPortableException.class)
    public void testSaveThrowException() throws Exception {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        Map emptyMap = Collections.emptyMap();
        ((MetadataServerSideService)Mockito.doReturn(emptyMap).when((Object)this.metadataService)).setUpAttributes(scenarioPath, metadata);
        ((CommentedOptionFactory)Mockito.doReturn((Object)this.commentedOption).when((Object)this.commentedOptionFactory)).makeCommentedOption(COMMENT);
        ((IOService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("error")}).when((Object)this.ioService)).write((Path)Mockito.any(Path.class), Mockito.anyString(), (Map)Mockito.eq(emptyMap), new OpenOption[]{(OpenOption)Mockito.eq((Object)this.commentedOption)});
        this.testEditorService.save(scenarioPath, this.scenario, metadata, COMMENT);
    }

    @Test
    public void testDelete() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        this.testEditorService.delete(scenarioPath, COMMENT);
        ((DeleteService)Mockito.verify((Object)this.deleteService)).delete(scenarioPath, COMMENT);
    }

    @Test(expected=GenericPortableException.class)
    public void testDeleteThrowException() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        ((DeleteService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("error")}).when((Object)this.deleteService)).delete(scenarioPath, COMMENT);
        this.testEditorService.delete(scenarioPath, COMMENT);
    }

    @Test
    public void testRename() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        String newFileName = NEW_FILE_NAME;
        this.testEditorService.rename(scenarioPath, NEW_FILE_NAME, COMMENT);
        ((RenameService)Mockito.verify((Object)this.renameService)).rename(scenarioPath, NEW_FILE_NAME, COMMENT);
    }

    @Test(expected=GenericPortableException.class)
    public void testRenameThrowException() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        String newFileName = NEW_FILE_NAME;
        ((RenameService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("error")}).when((Object)this.renameService)).rename(scenarioPath, NEW_FILE_NAME, COMMENT);
        this.testEditorService.rename(scenarioPath, NEW_FILE_NAME, COMMENT);
    }

    @Test
    public void testCopy() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        String newFileName = NEW_FILE_NAME;
        this.testEditorService.copy(scenarioPath, NEW_FILE_NAME, COMMENT);
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(scenarioPath, NEW_FILE_NAME, COMMENT);
    }

    @Test
    public void testCopyWithTarget() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        String newFileName = NEW_FILE_NAME;
        this.testEditorService.copy(scenarioPath, NEW_FILE_NAME, this.path, COMMENT);
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(scenarioPath, NEW_FILE_NAME, this.path, COMMENT);
    }

    @Test(expected=GenericPortableException.class)
    public void testCopyThrowException() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        String newFileName = NEW_FILE_NAME;
        ((CopyService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("error")}).when((Object)this.copyService)).copy(scenarioPath, NEW_FILE_NAME, COMMENT);
        this.testEditorService.copy(scenarioPath, NEW_FILE_NAME, COMMENT);
    }

    @Test(expected=GenericPortableException.class)
    public void testCopyWithTargetThrowException() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        String newFileName = NEW_FILE_NAME;
        ((CopyService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("error")}).when((Object)this.copyService)).copy(scenarioPath, NEW_FILE_NAME, this.path, COMMENT);
        this.testEditorService.copy(scenarioPath, NEW_FILE_NAME, this.path, COMMENT);
    }

    @Test
    public void runScenarioWithoutDependentImports() throws Exception {
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.scenario.getImports()).thenReturn((Object)new Imports());
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)0L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void runScenarioWithDependentImports() throws Exception {
        ArrayList<Fixture> fixtures = new ArrayList<Fixture>(){
            {
                this.add(ScenarioTestEditorServiceImplTest.this.factData("java.sql.ClientInfoStatus"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn((Object)fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getModuleModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenReturn((Object)new Imports());
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)2L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void runScenarioWithDependentImportsAndWithoutFactData() throws Exception {
        ArrayList fixtures = new ArrayList();
        Imports imports = new Imports(){
            {
                this.addImport(new Import("java.sql.ClientInfoStatus"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn(fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getModuleModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenReturn((Object)imports);
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)2L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void checkDependentImportsWithPrimitiveTypes() throws Exception {
        ArrayList fixtures = new ArrayList();
        Imports imports = new Imports(){
            {
                this.addImport(new Import("int"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn(fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getModuleModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenCallRealMethod();
        ((Scenario)Mockito.doCallRealMethod().when((Object)this.scenario)).setImports((Imports)Mockito.any(Imports.class));
        this.scenario.setImports(imports);
        this.testEditorService.addDependentImportsToScenario(this.scenario, this.path);
        Assert.assertEquals((long)1L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void checkSingleScenarioMultipleExecution() throws Exception {
        ArrayList fixtures = new ArrayList();
        Imports imports = new Imports(){
            {
                this.addImport(new Import("java.sql.ClientInfoStatus"));
            }
        };
        HashMap<String, ModelField[]> modelFields = new HashMap<String, ModelField[]>(){
            {
                this.put("java.sql.ClientInfoStatus", new ModelField[]{ScenarioTestEditorServiceImplTest.this.modelField("java.sql.JDBCType")});
            }
        };
        Mockito.when((Object)this.scenario.getFixtures()).thenReturn(fixtures);
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.modelOracle.getModuleModelFields()).thenReturn((Object)modelFields);
        Mockito.when((Object)this.scenario.getImports()).thenCallRealMethod();
        ((Scenario)Mockito.doCallRealMethod().when((Object)this.scenario)).setImports((Imports)Mockito.any(Imports.class));
        this.scenario.setImports(imports);
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        Assert.assertEquals((long)1L, (long)this.scenario.getImports().getImports().size());
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        Assert.assertEquals((long)1L, (long)this.scenario.getImports().getImports().size());
    }

    @Test
    public void loadEmptyScenario() throws Exception {
        org.uberfire.backend.vfs.Path scenarioPath = this.getEmptyScenarioPath();
        Scenario loadedScenario = this.testEditorService.load(scenarioPath);
        Assert.assertNotNull((Object)loadedScenario);
    }

    @Test
    public void loadScenario() throws Exception {
        URL scenarioResource = this.getClass().getResource("Are they old enough.scenario");
        org.uberfire.backend.vfs.Path scenarioPath = PathFactory.newPath((String)scenarioResource.getFile(), (String)scenarioResource.toURI().toString());
        Scenario loadedScenario = this.testEditorService.load(scenarioPath);
        Assert.assertNotNull((Object)loadedScenario);
        Assert.assertEquals((Object)"mortgages.mortgages", (Object)loadedScenario.getPackageName());
        Assert.assertEquals((long)5L, (long)loadedScenario.getFixtures().size());
        Assert.assertTrue((boolean)(loadedScenario.getFixtures().get(0) instanceof FactData));
        Assert.assertTrue((boolean)(loadedScenario.getFixtures().get(1) instanceof FactData));
        Assert.assertTrue((boolean)(loadedScenario.getFixtures().get(2) instanceof FactData));
        Assert.assertTrue((boolean)(loadedScenario.getFixtures().get(3) instanceof ExecutionTrace));
        Assert.assertTrue((boolean)(loadedScenario.getFixtures().get(4) instanceof VerifyFact));
    }

    @Test
    public void loadBrokenScenario() throws Exception {
        Package pgk = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)pgk.getPackageName()).thenReturn((Object)"org.test");
        Mockito.when((Object)this.moduleService.resolvePackage(this.path)).thenReturn((Object)pgk);
        Scenario load = this.testEditorService.load(this.path);
        Assert.assertNotNull((Object)load);
        Assert.assertEquals((Object)"org.test", (Object)load.getPackageName());
        Assert.assertNotNull((Object)load.getImports());
    }

    @Test
    public void loadBrokenScenarioNullPackage() throws Exception {
        Mockito.when((Object)this.moduleService.resolvePackage(this.path)).thenReturn(null);
        Scenario load = this.testEditorService.load(this.path);
        Assert.assertNotNull((Object)load);
        Assert.assertNull((Object)load.getPackageName());
        Assert.assertNotNull((Object)load.getImports());
    }

    @Test
    public void checkScenarioRunnerIsRan() throws Exception {
        Imports imports = new Imports(){
            {
                this.addImport(new Import("java.sql.ClientInfoStatus"));
            }
        };
        Mockito.when((Object)this.dataModelService.getDataModel(this.path)).thenReturn((Object)this.modelOracle);
        Mockito.when((Object)this.scenario.getImports()).thenCallRealMethod();
        ((Scenario)Mockito.doCallRealMethod().when((Object)this.scenario)).setImports((Imports)Mockito.any(Imports.class));
        this.scenario.setImports(imports);
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        KieModule module = (KieModule)Mockito.mock(KieModule.class);
        Mockito.when((Object)this.moduleService.resolveModule(this.path)).thenReturn((Object)module);
        this.testEditorService.runScenario("userName", this.path, this.scenario);
        ((ScenarioRunnerService)Mockito.verify((Object)this.scenarioRunner)).run("userName", this.scenario, module);
    }

    @Test
    public void testInit() throws Exception {
        this.testEditorService.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)this.testEditorService);
    }

    @Test
    public void testSaveAndRename() throws Exception {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String newFileName = "newFileName";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Scenario content = (Scenario)Mockito.mock(Scenario.class);
        String comment = COMMENT;
        this.testEditorService.saveAndRename(path, "newFileName", metadata, content, COMMENT);
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(path, "newFileName", (Object)metadata, (Object)content, COMMENT);
    }

    private FactData factData(String type) {
        return new FactData(type, "", true);
    }

    private ModelField modelField(String className) {
        return new ModelField(null, className, null, null, null, null);
    }

    private org.uberfire.backend.vfs.Path getEmptyScenarioPath() throws URISyntaxException {
        URL scenarioResource = this.getClass().getResource(EMPTY_SCENARIO_FILENAME);
        return PathFactory.newPath((String)scenarioResource.getFile(), (String)scenarioResource.toURI().toString());
    }
}

