/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.testscenarios.backend.ScenarioRunner4JUnit;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.AuditLogger;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioLoader;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioUtil;
import org.drools.workbench.screens.testscenario.model.TestScenarioResult;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.InitializationError;
import org.kie.api.runtime.KieSession;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ScenarioRunnerService
implements TestService {
    protected KieModuleService moduleService;
    private ScenarioLoader scenarioLoader;
    private SessionService sessionService;
    private Event<TestResultMessage> defaultTestResultMessageEvent;
    private ConfigurationService configurationService;

    public ScenarioRunnerService() {
    }

    @Inject
    public ScenarioRunnerService(ConfigurationService configurationService, Event<TestResultMessage> defaultTestResultMessageEvent, SessionService sessionService, KieModuleService moduleService, ScenarioLoader scenarioLoader) {
        this.configurationService = configurationService;
        this.defaultTestResultMessageEvent = defaultTestResultMessageEvent;
        this.sessionService = sessionService;
        this.moduleService = moduleService;
        this.scenarioLoader = scenarioLoader;
    }

    public TestScenarioResult run(String identifier, Scenario scenario, KieModule module) {
        try {
            HashMap<String, KieSession> ksessions = new HashMap<String, KieSession>();
            String ksessionName = ScenarioUtil.getKSessionName(scenario.getKSessions());
            ksessions.put(ksessionName, this.loadKSession(module, ksessionName));
            AuditLogger auditLogger = new AuditLogger(ksessions);
            ScenarioRunner4JUnit scenarioRunner = new ScenarioRunner4JUnit(scenario, ksessions, this.getMaxRuleFirings());
            this.run(identifier, scenarioRunner, this.defaultTestResultMessageEvent);
            return new TestScenarioResult(scenario, auditLogger.getLog());
        }
        catch (InitializationError initializationError) {
            throw new GenericPortableException(initializationError.getMessage());
        }
    }

    public void runAllTests(String indentifier, Path path) {
        this.runAllTests(indentifier, path, this.defaultTestResultMessageEvent);
    }

    public void runAllTests(String identifier, Path path, Event<TestResultMessage> customTestResultEvent) {
        try {
            List<Scenario> scenarios = this.scenarioLoader.loadScenarios(path);
            ScenarioRunner4JUnit scenarioRunner = new ScenarioRunner4JUnit(scenarios, this.getKSessions(path, scenarios), this.getMaxRuleFirings());
            this.run(identifier, scenarioRunner, customTestResultEvent);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private void run(String identifier, ScenarioRunner4JUnit scenarioRunner, Event<TestResultMessage> testResultMessageEvent) {
        final ArrayList<org.guvnor.common.services.shared.test.Failure> failures = new ArrayList<org.guvnor.common.services.shared.test.Failure>();
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener(new RunListener(){

            public void testAssumptionFailure(Failure failure) {
                failures.add(ScenarioUtil.failureToFailure(failure));
            }
        });
        Result result = jUnitCore.run((Runner)scenarioRunner);
        failures.addAll(ScenarioUtil.failuresToFailures(result.getFailures()));
        testResultMessageEvent.fire((Object)new TestResultMessage(identifier, result.getRunCount(), result.getRunTime(), failures));
    }

    private int getMaxRuleFirings() {
        for (ConfigGroup editorConfigGroup : this.configurationService.getConfiguration(ConfigType.EDITOR)) {
            if (!"test-scenario-editor-settings".equals(editorConfigGroup.getName())) continue;
            for (ConfigItem item : editorConfigGroup.getItems()) {
                String itemName = item.getName();
                if (!itemName.equals("max-rule-firings")) continue;
                return (Integer)item.getValue();
            }
        }
        return 0;
    }

    private Map<String, KieSession> getKSessions(Path path, List<Scenario> scenarios) {
        HashMap<String, KieSession> ksessions = new HashMap<String, KieSession>();
        for (Scenario scenario : scenarios) {
            String ksessionName = ScenarioUtil.getKSessionName(scenario.getKSessions());
            ksessions.put(ksessionName, this.loadKSession((KieModule)this.moduleService.resolveModule(path), ksessionName));
        }
        return ksessions;
    }

    private KieSession loadKSession(KieModule module, String ksessionName) {
        KieSession ksession = null;
        try {
            ksession = ksessionName == null || ksessionName.equals("defaultKieSession") ? this.sessionService.newDefaultKieSessionWithPseudoClock(module) : this.sessionService.newKieSession(module, ksessionName);
        }
        catch (Exception e) {
            return null;
        }
        return ksession;
    }
}

