/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.testutil;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.services.verifier.plugin.client.fromfile.DecisionTableAnalyzerFromFileTest;
import org.junit.Assert;

public class TestUtil {
    public static String loadResource(String name) throws Exception {
        InputStream in = DecisionTableAnalyzerFromFileTest.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    public static void assertOnlyContains(Set<Issue> result, CheckType ... expected) {
        if (result.isEmpty()) {
            Assert.fail((String)"Data is empty.");
        }
        Set resultTitles = result.stream().map(issue -> issue.getCheckType()).collect(Collectors.toSet());
        Assertions.assertThat(resultTitles).containsOnly((Object[])expected);
    }

    public static void assertResultIsEmpty(Set<Issue> analysisReport) {
        StringBuilder foundIssues = new StringBuilder();
        if (!analysisReport.isEmpty()) {
            analysisReport.stream().forEach(i -> foundIssues.append(i.getCheckType()).append(", "));
        }
        Assert.assertTrue((String)foundIssues.toString(), (boolean)analysisReport.isEmpty());
    }

    public static void assertContains(Set<Issue> result, CheckType expected, Severity severity, Integer ... rowNumbers) {
        Assert.assertTrue((String)("Could not find: " + expected + " for rows: " + rowNumbers + " and severity: " + severity), (result.stream().filter(issue -> issue.getSeverity() == severity).filter(issue -> TestUtil.titleEquals(issue, expected)).filter(issue -> TestUtil.rowNumberContains(issue, Arrays.asList(rowNumbers))).count() > 0L ? 1 : 0) != 0);
    }

    public static void assertDoesNotContain(CheckType notExpected, Set<Issue> result) {
        Assert.assertFalse((String)("Found " + notExpected), (result.stream().filter(issue -> TestUtil.titleEquals(issue, notExpected)).count() > 0L ? 1 : 0) != 0);
    }

    public static void assertDoesNotContain(CheckType notExpected, Set<Issue> result, int rowNumber) {
        Assert.assertFalse((String)("Found " + notExpected), (result.stream().filter(issue -> TestUtil.titleEquals(issue, notExpected)).filter(issue -> TestUtil.rowNumberContains(issue, Arrays.asList(rowNumber))).count() > 0L ? 1 : 0) != 0);
    }

    private static boolean titleEquals(Issue issue, CheckType expected) {
        return issue.getCheckType().equals((Object)expected);
    }

    private static boolean rowNumberContains(Issue issue, List<Integer> rowNumbers) {
        return issue.getRowNumbers().containsAll(rowNumbers);
    }
}

