/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.ModelMetaDataEnhancer;
import org.drools.workbench.services.verifier.plugin.client.testutil.AnalyzerProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Before;
import org.kie.soup.project.datamodel.oracle.DataType;

public abstract class AnalyzerUpdateTestBase {
    protected AnalyzerProvider analyzerProvider;
    protected GuidedDecisionTable52 table52;
    protected Analyzer analyzer;
    private DTableUpdateManager updateManager;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
    }

    protected void fireUpAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = this.analyzerProvider.makeAnalyser(this.table52);
            this.updateManager = this.analyzerProvider.getUpdateManager(this.table52, this.analyzer);
        }
        this.analyzer.resetChecks();
        this.analyzer.analyze();
    }

    protected void removeRow(int rowIndex) {
        this.table52.getData().remove(rowIndex);
        this.analyzer.removeRule(Integer.valueOf(rowIndex));
    }

    protected void removeActionColumn(int columnDataIndex, int columnActionIndex) {
        this.table52.getActionCols().remove(columnActionIndex);
        for (List row : this.table52.getData()) {
            row.remove(columnDataIndex);
        }
        this.updateManager.deleteColumns(columnDataIndex, 1);
    }

    public ValueSetter setCoordinate() {
        return new ValueSetter();
    }

    protected void setValue(int rowIndex, int columnIndex, Date value) {
        DTCellValue52 dtCellValue52 = (DTCellValue52)((List)this.table52.getData().get(rowIndex)).get(columnIndex);
        dtCellValue52.setDateValue(value);
        this.updateManager.update(this.table52, this.getUpdates(rowIndex, columnIndex));
    }

    protected void setValue(int rowIndex, int columnIndex, Number value) {
        DTCellValue52 dtCellValue52 = (DTCellValue52)((List)this.table52.getData().get(rowIndex)).get(columnIndex);
        dtCellValue52.setNumericValue(value);
        this.updateManager.update(this.table52, this.getUpdates(rowIndex, columnIndex));
    }

    protected void setValue(int rowIndex, int columnIndex, String value) {
        ((DTCellValue52)((List)this.table52.getData().get(rowIndex)).get(columnIndex)).setStringValue(value);
        this.updateManager.update(this.table52, this.getUpdates(rowIndex, columnIndex));
    }

    protected void setValue(int rowIndex, int columnIndex, Boolean value) {
        ((DTCellValue52)((List)this.table52.getData().get(rowIndex)).get(columnIndex)).setBooleanValue(value);
        this.updateManager.update(this.table52, this.getUpdates(rowIndex, columnIndex));
    }

    protected void appendActionColumn(int columnNumber, ActionSetFieldCol52 actionSetField, Comparable ... cellValues) throws BuildException {
        this.table52.getActionCols().add(actionSetField);
        for (int i = 0; i < cellValues.length; ++i) {
            ((List)this.table52.getData().get(i)).add(new DTCellValue52((Object)cellValues[i]));
        }
        this.updateManager.newColumn(this.table52, new ModelMetaDataEnhancer(this.table52).getHeaderMetaData(), this.analyzerProvider.getFactTypes(), columnNumber);
    }

    protected void insertConditionColumn(int columnNumber, BRLConditionColumn brlConditionColumn, Comparable ... cellValues) throws BuildException {
        this.table52.getConditions().add(brlConditionColumn);
        for (int i = 0; i < cellValues.length; ++i) {
            ((List)this.table52.getData().get(i)).add(new DTCellValue52((Object)cellValues[i]));
        }
        this.updateManager.newColumn(this.table52, new ModelMetaDataEnhancer(this.table52).getHeaderMetaData(), this.analyzerProvider.getFactTypes(), columnNumber);
    }

    protected void insertRow(int rowNumber, DataType.DataTypes ... dataTypes) throws BuildException {
        this.table52.getData().add(rowNumber, this.newRow(dataTypes));
        this.updateManager.makeRule(this.table52, new ModelMetaDataEnhancer(this.table52).getHeaderMetaData(), this.analyzerProvider.getFactTypes(), rowNumber);
    }

    protected void appendRow(DataType.DataTypes ... dataTypes) throws BuildException {
        ArrayList<DTCellValue52> row = this.newRow(dataTypes);
        this.table52.getData().add(row);
        this.updateManager.makeRule(this.table52, new ModelMetaDataEnhancer(this.table52).getHeaderMetaData(), this.analyzerProvider.getFactTypes(), this.table52.getData().size() - 1);
    }

    private ArrayList<DTCellValue52> newRow(DataType.DataTypes[] dataTypes) {
        ArrayList<DTCellValue52> row = new ArrayList<DTCellValue52>();
        row.add(new DTCellValue52());
        row.add(new DTCellValue52());
        for (DataType.DataTypes dataType : dataTypes) {
            row.add(new DTCellValue52(dataType, true));
        }
        return row;
    }

    protected List<Coordinate> getUpdates(int x, int y) {
        ArrayList<Coordinate> updates = new ArrayList<Coordinate>();
        updates.add(new Coordinate(x, y));
        return updates;
    }

    protected void analyze(String resourceName) throws Exception {
        String xml = TestUtil.loadResource(resourceName);
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
    }

    public class ValueSetter {
        public ColumnValueSetter row(int row) {
            return new ColumnValueSetter(row);
        }

        public class ColumnValueSetter {
            private int row;

            public ColumnValueSetter(int row) {
                this.row = row;
            }

            public CellValueSetter column(int column) {
                return new CellValueSetter(column);
            }

            public class CellValueSetter {
                private int column;

                public CellValueSetter(int column) {
                    this.column = column;
                }

                public void toValue(String value) {
                    AnalyzerUpdateTestBase.this.setValue(ColumnValueSetter.this.row, this.column, value);
                }

                public void toValue(Number value) {
                    AnalyzerUpdateTestBase.this.setValue(ColumnValueSetter.this.row, this.column, value);
                }

                public void toValue(Boolean value) {
                    AnalyzerUpdateTestBase.this.setValue(ColumnValueSetter.this.row, this.column, value);
                }
            }
        }
    }
}

