/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes;
import org.drools.workbench.services.verifier.plugin.client.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Import;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerSubsumptionResolverTest
extends AnalyzerUpdateTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("LoanApplication", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("amount", "Integer"));
                this.add(new FactTypes.Field("lengthYears", "Integer"));
                this.add(new FactTypes.Field("deposit", "Integer"));
                this.add(new FactTypes.Field("approved", "Boolean"));
                this.add(new FactTypes.Field("insuranceCost", "Integer"));
                this.add(new FactTypes.Field("approvedRate", "Integer"));
            }
        }));
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("IncomeSource", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("type", "String"));
            }
        }));
        this.analyzerProvider.getFactTypes().add(new FactTypes.FactType("Person", (Set)new HashSet<FactTypes.Field>(){
            {
                this.add(new FactTypes.Field("name", "String"));
            }
        }));
    }

    @Test
    public void testNoIssues() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("application", "LoanApplication", "amount", ">").withConditionIntegerColumn("application", "LoanApplication", "amount", "<=").withConditionIntegerColumn("application", "LoanApplication", "lengthYears", "==").withConditionIntegerColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Integer").withActionSetField("application", "approvedRate", "Integer").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 10000, 100000, 20, 2000, "Job", true, 0, 4}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}, {4, "description", null, null, null, null, null, null, null, null}, {5, "description", null, null, null, null, null, null, null, null}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testNoIssues2() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("application", "LoanApplication", "amount", ">").withConditionIntegerColumn("application", "LoanApplication", "amount", "<=").withConditionIntegerColumn("application", "LoanApplication", "lengthYears", "==").withConditionIntegerColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Integer").withActionSetField("application", "approvedRate", "Integer").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 1000, 200000, 30, 20000, "Asset", true, 0, 2}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    @Ignore(value="This randomly does not pick up the issue. Better that way, I'm hoping future changes will find the cause. Every other test works 100%")
    public void testRedundantRows001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withNumericColumn("application", "LoanApplication", "amount", ">").withNumericColumn("application", "LoanApplication", "amount", "<=").withNumericColumn("application", "LoanApplication", "lengthYears", "==").withNumericColumn("application", "LoanApplication", "deposit", "<").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "Boolean").withActionSetField("application", "insuranceCost", "Numeric").withActionSetField("application", "approvedRate", "Numeric").withData(new Object[][]{{1, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {2, "description", 131000, 200000, 30, 20000, "Asset", true, 0, 2}, {3, "description", 100001, 130000, 20, 3000, "Job", true, 10, 6}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
    }

    @Test
    public void testRedundantRows002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withStringColumn("application", "LoanApplication", "amount", ">").withStringColumn("person", "Person", "name", "==").withStringColumn("income", "IncomeSource", "type", "==").withActionSetField("application", "approved", "String").withData(new Object[][]{{1, "description", "131000", "Toni", "Asset", "true"}, {2, "description", "131000", "Toni", "Asset", "true"}, {3, "description", "100001", "Michael", "Job", "true"}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
    }

    @Test
    public void testRedundantRows003() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withStringColumn("application", "LoanApplication", "amount", ">").withStringColumn("person", "Person", "name", "==").withEnumColumn("income", "IncomeSource", "type", "==", "Asset,Job").withActionSetField("application", "approved", "String").withData(new Object[][]{{1, "description", "131000", "Toni", "Asset", "true"}, {2, "description", "131000", "Toni", "Asset", "true"}, {3, "description", "100001", "Michael", "Job", "true"}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
    }

    @Test
    public void testRedundantConditions001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withEnumColumn("a", "Person", "name", "==", "Toni,Eder").withConditionIntegerColumn("a", "Person", "name", "==").withData(new Object[][]{{1, "description", "Toni", "Toni"}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_CONDITIONS_TITLE, Severity.NOTE, new Integer[0]);
    }

    @Test
    public void testRedundantRowsWithConflict() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withConditionDoubleColumn("d", "Account", "deposit", "<").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, 0.0, true, true}, {2, "description", 100, 0.0, true, false}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRedundantActionsInOneRow001() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "name", "==").withActionSetField("a", "salary", "Integer").withActionSetField("a", "salary", "Integer").withData(new Object[][]{{1, "description", "Toni", 100, 100}, {2, "description", "Eder", 200, null}, {3, "description", "Michael", null, 300}, {4, "description", null, null, null, null, null}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.VALUE_FOR_ACTION_IS_SET_TWICE, Severity.WARNING, new Integer[0]);
    }

    @Test
    public void testRedundantActionsInOneRow002() throws Exception {
        GuidedDecisionTable52 table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "name", "==").withActionInsertFact("Person", "b", "salary", "Integer").withActionSetField("b", "salary", "Integer").withData(new Object[][]{{1, "description", "Toni", 100, 100}, {2, "description", "Eder", 200, null}, {3, "description", "Michael", null, 300}, {4, "description", null, null, null, null, null}}).buildTable();
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.VALUE_FOR_ACTION_IS_SET_TWICE, Severity.WARNING, new Integer[0]);
    }
}

