/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.services.verifier.plugin.client.testutil.LimitedGuidedDecisionTableBuilder;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Import;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testEmpty() throws Exception {
        this.table52 = new GuidedDecisionTable52();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }

    @Test
    public void testEmptyRow() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", ""}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 1);
    }

    @Test
    public void testMultipleEmptyRows() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", "==").withData(new Object[][]{{1, "description", ""}, {2, "description", ""}}).buildTable();
        this.fireUpAnalyzer();
        Assert.assertEquals((long)4L, (long)this.analyzerProvider.getAnalysisReport().size());
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 2);
        TestUtil.assertOnlyContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, CheckType.SINGLE_HIT_LOST);
    }

    @Test
    public void testRuleHasNoAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", 0}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, new Integer[0]);
    }

    @Test
    public void testMultipleRuleHasNoActions() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withData(new Object[][]{{1, "description", 0}, {2, "description", 1}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, 2);
    }

    @Test
    public void ruleHasNoActionShouldNotIgnoreRetract() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withRetract().withData(DataBuilderProvider.row(0, "a").end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.MISSING_ACTION, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRuleHasNoActionSet() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "age", "Integer").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "name", "String").withData(new Object[][]{{1, "description", 0, null, null, ""}, {2, "description", null, null, null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.EMPTY_RULE, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.MISSING_ACTION, this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testRuleHasNoRestrictions() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withActionInsertFact("Person", "a", "approved", "Boolean").withData(new Object[][]{{1, "description", true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RESTRICTION, Severity.NOTE, new Integer[0]);
    }

    @Test
    public void testRuleHasNoRestrictionsSet() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withStringColumn("a", "Person", "name", "==").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", null, "", true}, {2, "description", null, null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RESTRICTION, Severity.NOTE, 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.EMPTY_RULE, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.MISSING_RESTRICTION, this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testMultipleValuesForOneAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionSetField("a", "approved", "Boolean").withActionSetField("a", "approved", "Boolean").withData(new Object[][]{{1, "description", 100, true, false}}).buildTable();
        this.analyzer = this.analyzerProvider.makeAnalyser(this.table52);
        this.analyzer.start();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MULTIPLE_VALUES_FOR_ONE_ACTION, Severity.WARNING, new Integer[0]);
    }

    @Test
    public void testRedundancy() throws Exception {
        this.table52 = new LimitedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withIntegerColumn("a", "Person", "age", "==", 0).withAction("a", "Person", "approved", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withAction("a", "Person", "approved", new DTCellValue52(){
            {
                this.setBooleanValue(true);
            }
        }).withData(new Object[][]{{1, "description", true, true, false}, {2, "description", true, false, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
        Assert.assertNotNull((Object)this.analyzerProvider.getStatus());
    }

    @Test
    public void testRuleHasNoActionBRLFragmentHasAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionBRLFragment().withData(new Object[][]{{1, "description", 0, true}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertDoesNotContain(CheckType.EMPTY_RULE, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertDoesNotContain(CheckType.MISSING_ACTION, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testMissingActionForBrlAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionBRLFragment().withData(new Object[][]{{1, "description", Integer.MIN_VALUE, null}}).buildTable();
        this.fireUpAnalyzer();
        Assert.assertEquals((long)1L, (long)this.analyzerProvider.getAnalysisReport().size());
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, new Integer[0]);
    }

    @Test
    public void testMissingRestrictionForBrlAction() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionIntegerColumn("a", "Person", "age", ">").withActionBRLFragment().withData(new Object[][]{{1, "description", null, true}}).buildTable();
        this.fireUpAnalyzer();
        Assert.assertEquals((long)1L, (long)this.analyzerProvider.getAnalysisReport().size());
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RESTRICTION, Severity.NOTE, new Integer[0]);
    }

    @Test
    public void testConditionsShouldNotBeIgnored() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBRLColumn().withActionInsertFact("Application", "a", "approved", "Boolean").withData(new Object[][]{{1, "description", null, true}, {2, "description", null, null}}).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.EMPTY_RULE, Severity.WARNING, 2);
        TestUtil.assertDoesNotContain(CheckType.EMPTY_RULE, this.analyzerProvider.getAnalysisReport(), 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RESTRICTION, Severity.NOTE, 1);
        TestUtil.assertDoesNotContain(CheckType.MISSING_RESTRICTION, this.analyzerProvider.getAnalysisReport(), 2);
    }

    @Test
    public void testMissingActionForBrlCondition() throws Exception {
        this.table52 = new ExtendedGuidedDecisionTableBuilder("org.test", new ArrayList<Import>(), "mytable").withConditionBRLColumn().withActionInsertFact("Application", "a", "approved", "Boolean").withData(new Object[][]{{1, "description", "value", null}}).buildTable();
        this.fireUpAnalyzer();
        Assert.assertEquals((long)1L, (long)this.analyzerProvider.getAnalysisReport().size());
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, new Integer[0]);
    }
}

