/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.ExtendedGuidedDecisionTableBuilder;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerUpdateTest
extends AnalyzerUpdateTestBase {
    @Test
    public void updateRetract() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withRetract().withData(DataBuilderProvider.row(1, null).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, new Integer[0]);
        this.setValue(0, 3, "a");
        TestUtil.assertDoesNotContain(CheckType.MISSING_ACTION, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRowValueChange() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(1, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
        this.setValue(1, 2, 0);
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }

    @Test
    public void testUpdateDateEffective() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withAttributeColumn(Attribute.DATE_EFFECTIVE).withAttributeColumn(Attribute.DATE_EXPIRES).withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(new Date(2000, 11, 1), new Date(3000, 11, 2), 1, true).row(new Date(2000, 11, 3), new Date(5000, 11, 4), 1, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
        this.setValue(1, 2, new Date(4000, 11, 5));
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }

    @Test
    public void testUpdateDateExpires() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withAttributeColumn(Attribute.DATE_EFFECTIVE).withAttributeColumn(Attribute.DATE_EXPIRES).withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(new Date(2000, 11, 1), new Date(3000, 11, 2), 1, true).row(new Date(1000, 11, 3), new Date(5000, 11, 4), 1, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
        this.setValue(1, 3, new Date(1500, 11, 5));
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
    }

    @Test
    public void testRemoveRow() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 1, true).row(0, 1, true).row(2, 2, true).row(1, 1, false).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 4);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, 2);
        this.removeRow(1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.CONFLICTING_ROWS, Severity.WARNING, 3);
        TestUtil.assertDoesNotContain(CheckType.IMPOSSIBLE_MATCH, this.analyzerProvider.getAnalysisReport(), 3);
        this.setValue(1, 3, 1);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, 2);
    }

    @Test
    public void testRemoveRow2() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn(">").withPersonAgeColumn("<").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 10, true).row(1, 10, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.REDUNDANT_ROWS, Severity.WARNING, 1, 2);
        this.removeRow(0);
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testRemoveColumn() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(2, true).row(3, true).end()).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
        this.removeActionColumn(3, 0);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_ACTION, Severity.WARNING, new Integer[0]);
    }

    @Test
    public void testAddColumn() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(2, true).row(3, true).end()).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
        this.appendActionColumn(4, ExtendedGuidedDecisionTableBuilder.createActionSetField("a", "approved", "Boolean"), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MULTIPLE_VALUES_FOR_ONE_ACTION, Severity.WARNING, 3);
    }

    @Test
    public void testAddBRLColumn() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, true).row(2, true).row(3, true).end()).buildTable();
        this.fireUpAnalyzer();
        Assert.assertTrue((boolean)this.analyzerProvider.getAnalysisReport().isEmpty());
        this.insertConditionColumn(3, ExtendedGuidedDecisionTableBuilder.createBRLConditionColumn(), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        TestUtil.assertDoesNotContain(CheckType.REDUNDANT_ROWS, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testInsertRow() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 1, true).row(0, 1, true).row(2, 2, true).end()).buildTable();
        this.fireUpAnalyzer();
        this.insertRow(0, DataType.DataTypes.NUMERIC, DataType.DataTypes.NUMERIC, DataType.DataTypes.BOOLEAN);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, 3);
    }

    @Test
    public void testAppendRow() throws Exception {
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn("==").withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(1, 1, true).row(0, 1, true).row(2, 2, true).end()).buildTable();
        this.fireUpAnalyzer();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, 2);
        this.appendRow(DataType.DataTypes.NUMERIC, DataType.DataTypes.NUMERIC, DataType.DataTypes.STRING);
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.IMPOSSIBLE_MATCH, Severity.ERROR, 2);
    }
}

