/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.util.List;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.Pattern;
import org.drools.verifier.core.index.model.Rule;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.kie.soup.commons.validation.PortablePreconditions;

public class CellBuilder {
    private final BuilderFactory builderFactory;
    private int columnIndex;
    private BaseColumn baseColumn;
    private Rule rule;
    private List<DTCellValue52> row;

    public CellBuilder(BuilderFactory builderFactory) {
        this.builderFactory = (BuilderFactory)PortablePreconditions.checkNotNull((String)"builderFactory", (Object)builderFactory);
    }

    public void build() throws BuildException {
        if (this.baseColumn instanceof ActionCol52) {
            Action action = this.builderFactory.getActionBuilder().with(this.rule).with(this.row).with(this.columnIndex).with((ActionCol52)this.baseColumn).build();
            this.rule.getActions().add(action);
        } else if (this.baseColumn instanceof ConditionCol52) {
            if (this.baseColumn instanceof BRLConditionVariableColumn) {
                Condition condition = this.builderFactory.getBRLConditionBuilder().with((BRLConditionVariableColumn)this.baseColumn).with(Utils.getRealCellValue((DTColumnConfig52)((BRLConditionVariableColumn)this.baseColumn), this.row.get(this.columnIndex))).with(this.columnIndex).build();
                this.rule.getConditions().add(condition);
            } else {
                Condition condition = this.builderFactory.getFieldConditionsBuilder().with(this.resolvePattern(this.rule)).with((ConditionCol52)this.baseColumn).with(Utils.getRealCellValue((DTColumnConfig52)((ConditionCol52)this.baseColumn), this.row.get(this.columnIndex))).with(this.columnIndex).build();
                this.rule.getConditions().add(condition);
            }
        }
    }

    private Pattern resolvePattern(Rule rule) {
        return this.builderFactory.getPatternResolver().with(rule).with(this.columnIndex).resolve();
    }

    public CellBuilder with(Rule rule) {
        this.rule = rule;
        return this;
    }

    public CellBuilder with(List<DTCellValue52> row) {
        this.row = row;
        return this;
    }

    public CellBuilder with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }

    public CellBuilder with(BaseColumn baseColumn) {
        this.baseColumn = baseColumn;
        return this;
    }
}

