/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldBase;
import org.drools.verifier.core.index.model.ObjectField;
import org.drools.verifier.core.index.model.ObjectFields;
import org.drools.verifier.core.index.model.ObjectType;
import org.drools.verifier.core.relations.Operator;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;

public class Utils {
    public static Optional<String> findOperatorFromCell(DTCellValue52 realCellValue) {
        String[] split;
        String value = realCellValue.getStringValue();
        if (value != null && (split = value.trim().split(" ")).length >= 2 && !Operator.resolve((String)split[0]).equals((Object)Operator.NONE)) {
            return Optional.of(split[0]);
        }
        return Optional.empty();
    }

    public static ObjectField resolveObjectField(ObjectType objectType, String fieldType, String factField, AnalyzerConfiguration configuration) {
        ObjectField first = (ObjectField)((ObjectFields.FieldSelector)objectType.getFields().where((Matcher)Field.name().is((Comparable)((Object)factField))).select()).first();
        if (first == null) {
            ObjectField objectField = new ObjectField(objectType.getType(), fieldType, factField, configuration);
            objectType.getFields().add((FieldBase)objectField);
            return objectField;
        }
        return first;
    }

    public static DTCellValue52 getRealCellValue(DTColumnConfig52 config52, DTCellValue52 visibleCellValue) {
        if (config52 instanceof LimitedEntryCol) {
            return ((LimitedEntryCol)config52).getValue();
        }
        return visibleCellValue;
    }

    public static Short tryShort(String stringValue) {
        try {
            return new Short(stringValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Long tryLong(String stringValue) {
        try {
            return new Long(stringValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Double tryDouble(String stringValue) {
        try {
            return new Double(stringValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static BigInteger tryBigInteger(String stringValue) {
        try {
            return new BigInteger(stringValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static BigDecimal tryBigDecimal(String stringValue) {
        try {
            return new BigDecimal(stringValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Integer tryInteger(String stringValue) {
        try {
            return new Integer(stringValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Boolean tryBoolean(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (stringValue.toLowerCase().equals("true")) {
            return true;
        }
        if (stringValue.toLowerCase().equals("false")) {
            return false;
        }
        return null;
    }
}

