/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.cache.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.DTableUpdateManager;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.AnalyzerProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DTableUpdateManagerAttributesTest {
    @Captor
    private ArgumentCaptor<Set> setArgumentCaptor;
    private DTableUpdateManager updateManager;
    private GuidedDecisionTable52 table52;
    private AnalyzerProvider analyzerProvider;
    @Mock
    private Analyzer analyzer;

    @Before
    public void setUp() throws Exception {
        this.analyzerProvider = new AnalyzerProvider();
        this.table52 = this.analyzerProvider.makeAnalyser().withAttributeColumn(Attribute.DATE_EFFECTIVE).withAttributeColumn(Attribute.DATE_EXPIRES).withPersonAgeColumn("==").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(new Date(10L), new Date(100L), 1, true).row(new Date(10L), new Date(100L), 1, true).end()).buildTable();
        this.updateManager = this.analyzerProvider.getUpdateManager(this.table52, this.analyzer);
    }

    @Test
    public void testSetDateEffectiveToNull() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setDateValue(null);
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update((Set)this.setArgumentCaptor.capture());
        Set value = (Set)this.setArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)value.size());
        Assert.assertEquals((Object)0, value.iterator().next());
    }

    @Test
    public void testSetDateExpiresToNull() throws Exception {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Coordinate coordinate = new Coordinate(0, 3);
        coordinates.add(coordinate);
        ((DTCellValue52)((List)this.table52.getData().get(0)).get(3)).setDateValue(null);
        this.updateManager.update(this.table52, coordinates);
        ((Analyzer)Mockito.verify((Object)this.analyzer)).update((Set)this.setArgumentCaptor.capture());
        Set value = (Set)this.setArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)value.size());
        Assert.assertEquals((Object)0, value.iterator().next());
    }
}

