/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.DataBuilderProvider;
import org.drools.workbench.services.verifier.plugin.client.testutil.AnalyzerConfigurationMock;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerAllowListTest
extends AnalyzerUpdateTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.table52 = this.analyzerProvider.makeAnalyser().withPersonAgeColumn(">").withPersonApprovedActionSetField().withData(DataBuilderProvider.row(0, true).row(0, true).row(null, null).end()).buildTable();
    }

    @Test
    public void defaultAllowList() throws Exception {
        this.analyzerProvider.setConfiguration(new AnalyzerConfigurationMock());
        this.fireUpAnalyzer();
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertOnlyContains(analysisReport, CheckType.REDUNDANT_ROWS, CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
    }

    @Test
    public void noRedundantRows() throws Exception {
        AnalyzerConfigurationMock analyzerConfiguration = new AnalyzerConfigurationMock();
        analyzerConfiguration.getCheckConfiguration().getCheckConfiguration().remove(CheckType.REDUNDANT_ROWS);
        analyzerConfiguration.getCheckConfiguration().getCheckConfiguration().remove(CheckType.SUBSUMPTANT_ROWS);
        this.analyzerProvider.setConfiguration(analyzerConfiguration);
        this.fireUpAnalyzer();
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertOnlyContains(analysisReport, CheckType.SINGLE_HIT_LOST, CheckType.EMPTY_RULE);
    }

    @Test
    public void noEmptyRule() throws Exception {
        AnalyzerConfigurationMock analyzerConfiguration = new AnalyzerConfigurationMock();
        analyzerConfiguration.getCheckConfiguration().getCheckConfiguration().remove(CheckType.EMPTY_RULE);
        this.analyzerProvider.setConfiguration(analyzerConfiguration);
        this.fireUpAnalyzer();
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertOnlyContains(analysisReport, CheckType.REDUNDANT_ROWS, CheckType.SINGLE_HIT_LOST);
    }
}

