/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.fromfile;

import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.main.Analyzer;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.AnalyzerUpdateTestBase;
import org.drools.workbench.services.verifier.plugin.client.testutil.TestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DatesFromFileTest
extends AnalyzerUpdateTestBase {
    @Test
    public void testLowEdge() throws Exception {
        String xml = TestUtil.loadResource("Dates-missing-edge-low.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 1, 2, 3);
    }

    @Test
    public void testHighEdge() throws Exception {
        String xml = TestUtil.loadResource("Dates-missing-edge-high.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertContains(this.analyzerProvider.getAnalysisReport(), CheckType.MISSING_RANGE, Severity.NOTE, 1, 2, 3);
    }

    @Test
    public void testComplete() throws Exception {
        String xml = TestUtil.loadResource("Dates-complete.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        TestUtil.assertDoesNotContain(CheckType.MISSING_RANGE, this.analyzerProvider.getAnalysisReport());
    }

    @Test
    public void testGap() throws Exception {
        String xml = TestUtil.loadResource("Dates-mid-gap.gdst");
        GuidedDecisionTable52 table52 = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Analyzer analyzer = this.analyzerProvider.makeAnalyser(table52);
        analyzer.resetChecks();
        analyzer.analyze();
        Set<Issue> analysisReport = this.analyzerProvider.getAnalysisReport();
        TestUtil.assertContains(analysisReport, CheckType.MISSING_RANGE, Severity.NOTE, 1, 2);
    }
}

