/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.process.core.WorkDefinition;
import org.drools.workbench.screens.workitems.backend.server.WorkDefinitionsParser;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.server.util.Paths;

public class ResourceWorkDefinitionsLoader {
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    private FileExtensionFilter widFilter = new FileExtensionFilter("wid");

    public Map<String, WorkDefinition> loadWorkDefinitions(org.uberfire.backend.vfs.Path projectRoot) {
        HashMap<String, WorkDefinition> workDefinitions = new HashMap<String, WorkDefinition>();
        Path nioProjectRoot = this.paths.convert(projectRoot);
        Collection widPaths = this.fileDiscoveryService.discoverFiles(nioProjectRoot, (DirectoryStream.Filter)this.widFilter, true);
        if (widPaths == null || widPaths.isEmpty()) {
            return workDefinitions;
        }
        ArrayList<String> definitions = new ArrayList<String>();
        for (Path widPath : widPaths) {
            String definition = this.ioService.readAllString(widPath);
            definitions.add(definition);
        }
        workDefinitions.putAll(WorkDefinitionsParser.parse(definitions));
        return workDefinitions;
    }
}

