/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.process.core.ParameterDefinition;
import org.drools.core.process.core.WorkDefinition;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.BooleanDataType;
import org.drools.core.process.core.datatype.impl.type.FloatDataType;
import org.drools.core.process.core.datatype.impl.type.IntegerDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.datatype.impl.type.StringDataType;
import org.drools.workbench.models.commons.shared.workitems.PortableBooleanParameterDefinition;
import org.drools.workbench.models.commons.shared.workitems.PortableFloatParameterDefinition;
import org.drools.workbench.models.commons.shared.workitems.PortableIntegerParameterDefinition;
import org.drools.workbench.models.commons.shared.workitems.PortableObjectParameterDefinition;
import org.drools.workbench.models.commons.shared.workitems.PortableParameterDefinition;
import org.drools.workbench.models.commons.shared.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.commons.shared.workitems.PortableWorkDefinition;
import org.drools.workbench.screens.workitems.backend.server.ConfigWorkDefinitionsLoader;
import org.drools.workbench.screens.workitems.backend.server.ResourceWorkDefinitionsLoader;
import org.drools.workbench.screens.workitems.model.WorkItemDefinitionElements;
import org.drools.workbench.screens.workitems.model.WorkItemsModelContent;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.drools.workbench.screens.workitems.type.WorkItemsTypeDefinition;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.backend.file.FileExtensionsFilter;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class WorkItemsEditorServiceImpl
implements WorkItemsEditorService {
    private static final Logger log = LoggerFactory.getLogger(WorkItemsEditorServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private ResourceWorkDefinitionsLoader resourceWorkDefinitionsLoader;
    @Inject
    private ConfigWorkDefinitionsLoader configWorkDefinitionsLoader;
    @Inject
    private ProjectService projectService;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private WorkItemsTypeDefinition resourceTypeDefinition;
    private WorkItemDefinitionElements workItemDefinitionElements;
    private FileExtensionsFilter imageFilter = new FileExtensionsFilter(new String[]{"png", "gif", "jpg"});

    @PostConstruct
    public void setupWorkItemDefinitionElements() {
        this.workItemDefinitionElements = new WorkItemDefinitionElements(this.loadWorkItemDefinitionElements());
    }

    private Map<String, String> loadWorkItemDefinitionElements() {
        HashMap<String, String> workItemDefinitionElements = new HashMap<String, String>();
        List editorConfigGroups = this.configurationService.getConfiguration(ConfigType.EDITOR);
        for (ConfigGroup editorConfigGroup : editorConfigGroups) {
            if (!"work-items-editor-settings".equals(editorConfigGroup.getName())) continue;
            for (ConfigItem item : editorConfigGroup.getItems()) {
                String itemName = item.getName();
                String itemValue = editorConfigGroup.getConfigItemValue(itemName);
                workItemDefinitionElements.put(itemName, itemValue);
            }
        }
        return workItemDefinitionElements;
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, String content, String comment) {
        try {
            String defaultDefinition = (String)this.workItemDefinitionElements.getDefinitionElements().get("Definition");
            if (defaultDefinition == null) {
                defaultDefinition = "";
            }
            defaultDefinition.replaceAll("\\|", "");
            Path nioPath = this.paths.convert(context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath, false);
            this.ioService.createFile(nioPath, new FileAttribute[0]);
            this.ioService.write(nioPath, defaultDefinition, new OpenOption[]{this.makeCommentedOption(comment)});
            this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newPath));
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(this.paths.convert(path));
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path));
            return content;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public WorkItemsModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            String definition = this.load(path);
            List<String> workItemImages = this.loadWorkItemImages(path);
            return new WorkItemsModelContent(definition, workItemImages);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private List<String> loadWorkItemImages(org.uberfire.backend.vfs.Path resourcePath) {
        org.uberfire.backend.vfs.Path projectRoot = this.projectService.resolveProject(resourcePath).getRootPath();
        Path nioProjectPath = this.paths.convert(projectRoot);
        Path nioResourceParent = this.paths.convert(resourcePath).getParent();
        Collection imagePaths = this.fileDiscoveryService.discoverFiles(nioProjectPath, (DirectoryStream.Filter)this.imageFilter, true);
        ArrayList<String> images = new ArrayList<String>();
        for (Path imagePath : imagePaths) {
            Path relativePath = nioResourceParent.relativize(imagePath);
            images.add(relativePath.toString());
        }
        return images;
    }

    public WorkItemDefinitionElements loadDefinitionElements() {
        return this.workItemDefinitionElements;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, String content, Metadata metadata, String comment) {
        try {
            this.ioService.write(this.paths.convert(resource), content, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(resource));
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean accepts(org.uberfire.backend.vfs.Path path) {
        return this.resourceTypeDefinition.accept(path);
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(this.paths.convert(path));
            return this.validate(path, content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, String content) {
        return this.doValidation(content);
    }

    private List<ValidationMessage> doValidation(String content) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        try {
            MVEL.eval((String)content, new HashMap());
        }
        catch (Exception e) {
            ValidationMessage msg = new ValidationMessage();
            msg.setLevel(ValidationMessage.Level.ERROR);
            msg.setText(e.getMessage());
            validationMessages.add(msg);
        }
        return validationMessages;
    }

    public Set<PortableWorkDefinition> loadWorkItemDefinitions(org.uberfire.backend.vfs.Path path) {
        HashMap<String, WorkDefinition> workDefinitions = new HashMap<String, WorkDefinition>();
        try {
            org.uberfire.backend.vfs.Path projectRoot = this.projectService.resolveProject(path).getRootPath();
            workDefinitions.putAll(this.resourceWorkDefinitionsLoader.loadWorkDefinitions(projectRoot));
            workDefinitions.putAll(this.configWorkDefinitionsLoader.loadWorkDefinitions());
            HashSet<PortableWorkDefinition> workItems = new HashSet<PortableWorkDefinition>();
            for (Map.Entry entry : workDefinitions.entrySet()) {
                PortableWorkDefinition wid = new PortableWorkDefinition();
                WorkDefinitionImpl wd = (WorkDefinitionImpl)entry.getValue();
                wid.setName(wd.getName());
                wid.setDisplayName(wd.getDisplayName());
                wid.setParameters(this.convertWorkItemParameters(((WorkDefinition)entry.getValue()).getParameters()));
                wid.setResults(this.convertWorkItemParameters(((WorkDefinition)entry.getValue()).getResults()));
                workItems.add(wid);
            }
            return workItems;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Set<PortableParameterDefinition> convertWorkItemParameters(Set<ParameterDefinition> parameters) {
        HashSet<PortableParameterDefinition> pps = new HashSet<PortableParameterDefinition>();
        for (ParameterDefinition pd : parameters) {
            DataType pdt = pd.getType();
            PortableBooleanParameterDefinition ppd = null;
            if (pdt instanceof BooleanDataType) {
                ppd = new PortableBooleanParameterDefinition();
            } else if (pdt instanceof FloatDataType) {
                ppd = new PortableFloatParameterDefinition();
            } else if (pdt instanceof IntegerDataType) {
                ppd = new PortableIntegerParameterDefinition();
            } else if (pdt instanceof ObjectDataType) {
                ppd = new PortableObjectParameterDefinition();
                PortableObjectParameterDefinition oppd = (PortableObjectParameterDefinition)ppd;
                ObjectDataType odt = (ObjectDataType)pdt;
                oppd.setClassName(odt.getClassName());
            } else if (pd.getType() instanceof StringDataType) {
                ppd = new PortableStringParameterDefinition();
            }
            if (ppd == null) continue;
            ppd.setName(pd.getName());
            pps.add((PortableParameterDefinition)ppd);
        }
        return pps;
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

