/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.backend.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.core.process.core.WorkDefinition;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.BooleanDataType;
import org.drools.core.process.core.datatype.impl.type.EnumDataType;
import org.drools.core.process.core.datatype.impl.type.FloatDataType;
import org.drools.core.process.core.datatype.impl.type.IntegerDataType;
import org.drools.core.process.core.datatype.impl.type.ListDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.datatype.impl.type.StringDataType;
import org.drools.core.process.core.datatype.impl.type.UndefinedDataType;
import org.drools.core.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class WorkDefinitionsParser {
    public static Map<String, WorkDefinition> parse(List<String> workItemDefinitions) {
        HashMap<String, WorkDefinition> workDefinitions = new HashMap<String, WorkDefinition>();
        ParserContext context = new ParserContext();
        context.addImport("ObjectDataType", ObjectDataType.class);
        context.addImport("StringDataType", StringDataType.class);
        context.addImport("IntegerDataType", IntegerDataType.class);
        context.addImport("FloatDataType", FloatDataType.class);
        context.addImport("BooleanDataType", BooleanDataType.class);
        context.addImport("ListDataType", ListDataType.class);
        context.addImport("EnumDataType", EnumDataType.class);
        context.addImport("UndefinedDataType", UndefinedDataType.class);
        for (String workItemDefinition : workItemDefinitions) {
            Serializable compiled = MVEL.compileExpression((String)workItemDefinition, (ParserContext)context);
            Object result = MVEL.executeExpression((Object)compiled, new HashMap());
            Map workDefinitionMap = (Map)result;
            if (workDefinitionMap == null) continue;
            WorkDefinitionImpl workDefinition = new WorkDefinitionImpl();
            workDefinition.setName((String)workDefinitionMap.get("name"));
            workDefinition.setDisplayName((String)workDefinitionMap.get("displayName"));
            workDefinition.setIcon((String)workDefinitionMap.get("icon"));
            workDefinition.setCustomEditor((String)workDefinitionMap.get("customEditor"));
            HashSet<ParameterDefinitionImpl> parameters = new HashSet<ParameterDefinitionImpl>();
            if (workDefinitionMap.get("parameters") != null) {
                Map parameterMap = (Map)workDefinitionMap.get("parameters");
                if (parameterMap != null) {
                    for (Map.Entry entry : parameterMap.entrySet()) {
                        parameters.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                    }
                }
                workDefinition.setParameters(parameters);
            }
            if (workDefinitionMap.get("results") != null) {
                HashSet<ParameterDefinitionImpl> results = new HashSet<ParameterDefinitionImpl>();
                Map resultMap = (Map)workDefinitionMap.get("results");
                if (resultMap != null) {
                    for (Map.Entry entry : resultMap.entrySet()) {
                        results.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                    }
                }
                workDefinition.setResults(results);
            }
            if (workDefinitionMap.get("defaultHandler") != null) {
                workDefinition.setDefaultHandler((String)workDefinitionMap.get("defaultHandler"));
            }
            if (workDefinitionMap.get("dependencies") != null) {
                workDefinition.setDependencies(((List)workDefinitionMap.get("dependencies")).toArray(new String[0]));
            }
            workDefinitions.put(workDefinition.getName(), (WorkDefinition)workDefinition);
        }
        return workDefinitions;
    }
}

