/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.backend.server;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.drools.core.process.core.WorkDefinition;
import org.drools.workbench.screens.workitems.backend.server.WorkDefinitionsParser;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.CompileException;

public class WorkDefinitionsParserTest {
    @Test
    public void testValidWorkitemDefinition() throws Exception {
        ArrayList<String> defStrings = new ArrayList<String>();
        defStrings.add(this.loadFile("validWorkItemDefinition.wid"));
        Map defs = WorkDefinitionsParser.parse(defStrings);
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.size());
        WorkDefinition myTaskDef = (WorkDefinition)defs.get("MyTask");
        Assert.assertNotNull((Object)myTaskDef);
        Assert.assertEquals((Object)"MyTask", (Object)myTaskDef.getName());
        Assert.assertNotNull((Object)myTaskDef.getParameter("MyFirstParam"));
        Assert.assertNotNull((Object)myTaskDef.getParameter("MySecondParam"));
        Assert.assertNotNull((Object)myTaskDef.getParameter("MyThirdParam"));
    }

    @Test(expected=CompileException.class)
    public void testInvalidWorkitemDefinition() {
        ArrayList<String> defStrings = new ArrayList<String>();
        defStrings.add(this.loadFile("missingImportWorkItemDefinition.wid"));
        WorkDefinitionsParser.parse(defStrings);
    }

    private String loadFile(String fileName) {
        try {
            URL fileURL = this.getClass().getResource(fileName);
            return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
        }
        catch (Exception e) {
            return null;
        }
    }
}

