/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.backend.server;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.drools.workbench.screens.workitems.backend.server.WorkDefinitionsParser;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.CompileException;

public class WorkDefinitionsParserTest {
    @Test
    public void testValidWorkitemDefinition() throws Exception {
        ArrayList<String> defStrings = new ArrayList<String>();
        defStrings.add(this.loadFile("validWorkItemDefinition.wid"));
        Map defs = WorkDefinitionsParser.parse(defStrings);
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)1L, (long)defs.size());
        WorkDefinitionImpl myTaskDef = (WorkDefinitionImpl)defs.get("MyTask");
        Assert.assertNotNull((Object)myTaskDef);
        Assert.assertEquals((Object)"MyTask", (Object)myTaskDef.getName());
        Assert.assertNotNull((Object)myTaskDef.getParameter("MyFirstParam"));
        Assert.assertNotNull((Object)myTaskDef.getParameter("MySecondParam"));
        Assert.assertNotNull((Object)myTaskDef.getParameter("MyThirdParam"));
        Assert.assertNotNull((Object)myTaskDef.getParameterValues());
        Assert.assertEquals((long)2L, (long)myTaskDef.getParameterValues().size());
        Map paramValues = myTaskDef.getParameterValues();
        Assert.assertTrue((boolean)paramValues.containsKey("MyFirstParam"));
        Assert.assertTrue((boolean)paramValues.containsKey("MySecondParam"));
        Assert.assertNotNull((Object)myTaskDef.getVersion());
        Assert.assertEquals((Object)"1.0", (Object)myTaskDef.getVersion());
        Assert.assertNotNull((Object)myTaskDef.getDocumentation());
        Assert.assertEquals((Object)"documentation for sample workitem", (Object)myTaskDef.getDocumentation());
        Assert.assertNotNull((Object)myTaskDef.getDescription());
        Assert.assertEquals((Object)"this is a sample workitem", (Object)myTaskDef.getDescription());
        Assert.assertNotNull((Object)myTaskDef.getMavenDependencies());
        Assert.assertEquals((long)1L, (long)myTaskDef.getMavenDependencies().length);
        Assert.assertEquals((Object)"org.jboss:somemodule:3.2", (Object)myTaskDef.getMavenDependencies()[0]);
    }

    @Test(expected=CompileException.class)
    public void testMissingCustomDataTypeDefinition() {
        ArrayList<String> defStrings = new ArrayList<String>();
        defStrings.add(this.loadFile("missingCustomDataTypeDefinition.wid"));
        WorkDefinitionsParser.parse(defStrings);
    }

    private String loadFile(String fileName) {
        try {
            URL fileURL = this.getClass().getResource(fileName);
            return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
        }
        catch (Exception e) {
            return null;
        }
    }
}

