/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.backend.server;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.workitems.backend.server.WorkItemsEditorServiceImpl;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkItemsEditorServiceImplTest {
    @Mock
    Path path;
    @Mock
    SaveAndRenameServiceImpl<String, Metadata> saveAndRenameService;
    @InjectMocks
    WorkItemsEditorServiceImpl service = (WorkItemsEditorServiceImpl)Mockito.spy((Object)new WorkItemsEditorServiceImpl());

    private String loadFile(String fileName) throws Exception {
        URL fileURL = this.getClass().getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
    }

    @Test
    public void testValidWid() throws Exception {
        Assert.assertEquals((long)0L, (long)this.service.validate(this.path, this.loadFile("validWorkItemDefinition.wid")).size());
    }

    @Test
    public void testMissingCustomDataType() throws Exception {
        List messages = this.service.validate(this.path, this.loadFile("missingCustomDataTypeDefinition.wid"));
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertTrue((String)"Expected error about missing import", (boolean)((ValidationMessage)messages.get(0)).getText().contains("Error: could not resolve class: MyCustomDataType"));
    }

    @Test
    public void testSetupWorkItemDefinitionElements() throws Exception {
        HashMap expectedDefinitionElements = new HashMap();
        ((WorkItemsEditorServiceImpl)Mockito.doReturn(expectedDefinitionElements).when((Object)this.service)).loadWorkItemDefinitionElements();
        this.service.setupWorkItemDefinitionElements();
        Map actualDefinitionElements = this.service.loadDefinitionElements().getDefinitionElements();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)this.service);
        Assert.assertEquals(expectedDefinitionElements, (Object)actualDefinitionElements);
    }

    @Test
    public void testSaveAndRename() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        String newFileName = "newFileName";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String content = "content";
        String comment = "comment";
        this.service.saveAndRename(path, "newFileName", metadata, "content", "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(path, "newFileName", (Object)metadata, (Object)"content", "comment");
    }
}

