/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.client.widget;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.screens.workitems.client.resources.WorkItemsEditorResources;

public class WorkItemDefinitionEditor
extends Composite {
    private final TextArea textArea = new TextArea();

    public WorkItemDefinitionEditor() {
        this.textArea.setWidth("100%");
        this.textArea.setVisibleLines(25);
        this.textArea.setStyleName(WorkItemsEditorResources.INSTANCE.CSS().defaultTextArea());
        this.textArea.getElement().setAttribute("spellcheck", "false");
        this.textArea.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 9) {
                    event.preventDefault();
                    event.stopPropagation();
                    int pos = WorkItemDefinitionEditor.this.textArea.getCursorPos();
                    WorkItemDefinitionEditor.this.insertText("\t");
                    WorkItemDefinitionEditor.this.textArea.setCursorPos(pos + 1);
                    WorkItemDefinitionEditor.this.textArea.cancelKey();
                    WorkItemDefinitionEditor.this.textArea.setFocus(true);
                }
            }
        });
        this.initWidget((Widget)this.textArea);
    }

    public void setContent(String definition) {
        this.textArea.setText(definition);
    }

    public void insertText(String text) {
        this.insertText(text, false);
    }

    public void insertText(String text, boolean isSpecialPaste) {
        int p;
        String textToInsert = text;
        int i = this.textArea.getCursorPos();
        String left = this.textArea.getText().substring(0, i);
        String right = this.textArea.getText().substring(i, this.textArea.getText().length());
        int cursorPosition = left.toCharArray().length;
        if (isSpecialPaste && (p = text.indexOf("|")) > -1) {
            cursorPosition += p;
            textToInsert = textToInsert.replaceAll("\\|", "");
        }
        this.textArea.setFocus(true);
        this.textArea.setText(left + textToInsert + right);
        this.textArea.setCursorPos(cursorPosition);
    }

    public String getContent() {
        return this.textArea.getValue();
    }
}

