/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.client.widget;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.drools.workbench.screens.workitems.client.resources.i18n.WorkItemsEditorConstants;
import org.drools.workbench.screens.workitems.client.widget.HasWorkItemDefinitionElements;
import org.drools.workbench.screens.workitems.client.widget.WorkItemDefinitionElementSelectedListener;
import org.drools.workbench.screens.workitems.client.widget.WorkItemMetaDataLoader;
import org.drools.workbench.screens.workitems.model.WorkItemDefinitionElements;
import org.uberfire.client.mvp.UberView;

public class WorkItemDefinitionElementsBrowser
extends Composite
implements HasWorkItemDefinitionElements,
UberView<WorkItemDefinitionElementSelectedListener> {
    @Inject
    private WorkItemMetaDataLoader metaDataLoader;
    private final VerticalPanel mainPanel = new VerticalPanel();
    private final VerticalPanel elementsPanel = new VerticalPanel();
    private final ListBox importsList = new ListBox();
    private final ListBox imagesList = new ListBox();
    private WorkItemDefinitionElementSelectedListener presenter;

    public WorkItemDefinitionElementsBrowser() {
        this.mainPanel.add((Widget)new Label(WorkItemsEditorConstants.INSTANCE.BrowserTitle()));
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainPanel.setSpacing(5);
        this.elementsPanel.setSpacing(5);
        this.mainPanel.add((Widget)this.elementsPanel);
        this.mainPanel.add((Widget)this.importsList);
        this.importsList.addItem(WorkItemsEditorConstants.INSTANCE.ChooseImportClass());
        this.importsList.addItem("BooleanDataType", "import org.drools.core.process.core.datatype.impl.type.BooleanDataType;");
        this.importsList.addItem("EnumDataType", "import org.drools.core.process.core.datatype.impl.type.EnumDataType;");
        this.importsList.addItem("FloatDataType", "import org.drools.core.process.core.datatype.impl.type.FloatDataType;");
        this.importsList.addItem("IntegerDataType", "import org.drools.core.process.core.datatype.impl.type.IntegerDataType;");
        this.importsList.addItem("ListDataType", "import org.drools.core.process.core.datatype.impl.type.ListDataType;");
        this.importsList.addItem("ObjectDataType", "import org.drools.core.process.core.datatype.impl.type.ObjectDataType;");
        this.importsList.addItem("StringDataType", "import org.drools.core.process.core.datatype.impl.type.StringDataType;");
        this.importsList.addItem("UndefinedDataType", "import org.drools.core.process.core.datatype.impl.type.UndefinedDataType;");
        this.importsList.setVisibleItemCount(9);
        this.importsList.setSelectedIndex(0);
        this.importsList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                WorkItemDefinitionElementsBrowser.this.elementSelected(WorkItemDefinitionElementsBrowser.this.importsList.getItemText(WorkItemDefinitionElementsBrowser.this.importsList.getSelectedIndex()), WorkItemDefinitionElementsBrowser.this.importsList.getValue(WorkItemDefinitionElementsBrowser.this.importsList.getSelectedIndex()));
            }
        });
        this.mainPanel.add((Widget)this.imagesList);
        this.imagesList.setVisibleItemCount(1);
        this.imagesList.setSelectedIndex(0);
        this.imagesList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                WorkItemDefinitionElementsBrowser.this.elementSelected(WorkItemDefinitionElementsBrowser.this.imagesList.getItemText(WorkItemDefinitionElementsBrowser.this.imagesList.getSelectedIndex()), WorkItemDefinitionElementsBrowser.this.imagesList.getValue(WorkItemDefinitionElementsBrowser.this.imagesList.getSelectedIndex()));
            }
        });
        this.initWidget((Widget)this.mainPanel);
    }

    @PostConstruct
    public void loadMetaData() {
        this.metaDataLoader.loadMetaContent(this);
    }

    public void init(WorkItemDefinitionElementSelectedListener presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setDefinitionElements(WorkItemDefinitionElements metaData) {
        Map workItemElementDefinitions = metaData.getDefinitionElements();
        for (Map.Entry entry : workItemElementDefinitions.entrySet()) {
            this.elementsPanel.add((Widget)new PanelButton(this.getButtonDescription((String)entry.getKey()), (String)entry.getValue()));
        }
    }

    private String getButtonDescription(String buttonKey) {
        if (buttonKey == null || buttonKey.trim().length() == 0) {
            return "";
        }
        if ("Definition".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.Definition();
        }
        if ("DisplayName".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.DisplayName();
        }
        if ("Parameter".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.Parameter();
        }
        if ("Result".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.Result();
        }
        return buttonKey;
    }

    public void setImages(List<String> workItemImages) {
        this.imagesList.clear();
        this.imagesList.addItem(WorkItemsEditorConstants.INSTANCE.ChooseIcon());
        for (String workItemImage : workItemImages) {
            this.imagesList.addItem(workItemImage);
        }
    }

    private void elementSelected(String title, String value) {
        this.presenter.onElementSelected(title, value);
    }

    private class LeafClickHandler
    implements ClickHandler {
        private final String title;
        private final String pasteValue;

        public LeafClickHandler(String title, String pasteValue) {
            this.title = title;
            this.pasteValue = pasteValue;
        }

        public void onClick(ClickEvent event) {
            WorkItemDefinitionElementsBrowser.this.elementSelected(this.title, this.pasteValue);
        }
    }

    private class PanelButton
    extends Button {
        public PanelButton(String html, String pasteValue) {
            super(html);
            this.setWidth("100px");
            this.addClickHandler(new LeafClickHandler(html, pasteValue));
        }
    }
}

