/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.workitems.client.editor.WorkItemsEditorView;
import org.drools.workbench.screens.workitems.client.type.WorkItemsResourceType;
import org.drools.workbench.screens.workitems.model.WorkItemsModelContent;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="WorkItemsEditor", supportedTypes={WorkItemsResourceType.class})
public class WorkItemsEditorPresenter
extends KieEditor {
    @Inject
    private Caller<WorkItemsEditorService> workItemsService;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleNotification;
    @Inject
    private ValidationPopup validationPopup;
    @Inject
    private PlaceManager placeManager;
    private WorkItemsEditorView view;
    @Inject
    private WorkItemsResourceType type;
    @Inject
    private DefaultFileNameValidator fileNameValidator;
    private Metadata metadata;

    @Inject
    public WorkItemsEditorPresenter(WorkItemsEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((WorkItemsEditorService)this.workItemsService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<WorkItemsModelContent> getModelSuccessCallback() {
        return new RemoteCallback<WorkItemsModelContent>(){

            public void callback(WorkItemsModelContent content) {
                if (WorkItemsEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                WorkItemsEditorPresenter.this.resetEditorPages(content.getOverview());
                WorkItemsEditorPresenter.this.metadata = content.getOverview().getMetadata();
                String definition = content.getDefinition();
                List workItemImages = content.getWorkItemImages();
                WorkItemsEditorPresenter.this.view.setReadOnly(WorkItemsEditorPresenter.this.isReadOnly);
                WorkItemsEditorPresenter.this.view.setContent(definition, workItemImages);
                WorkItemsEditorPresenter.this.createOriginalHash(WorkItemsEditorPresenter.this.view.getContent());
                WorkItemsEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((WorkItemsEditorService)WorkItemsEditorPresenter.this.workItemsService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            WorkItemsEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            WorkItemsEditorPresenter.this.validationPopup.showMessages(results);
                        }
                    }
                })).validate((Path)WorkItemsEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)WorkItemsEditorPresenter.this.view.getContent());
            }
        };
    }

    protected void save(String commitMessage) {
        ((WorkItemsEditorService)this.workItemsService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), this.metadata, commitMessage);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

