/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.client.widget;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.workitems.client.resources.i18n.WorkItemsEditorConstants;
import org.drools.workbench.screens.workitems.client.widget.HasWorkItemDefinitionElements;
import org.drools.workbench.screens.workitems.client.widget.WorkItemDefinitionElementSelectedListener;
import org.drools.workbench.screens.workitems.client.widget.WorkItemMetaDataLoader;
import org.drools.workbench.screens.workitems.model.WorkItemDefinitionElements;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Container;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.uberfire.client.mvp.UberView;

@Dependent
public class WorkItemDefinitionElementsBrowser
extends Composite
implements HasWorkItemDefinitionElements,
UberView<WorkItemDefinitionElementSelectedListener> {
    @Inject
    private WorkItemMetaDataLoader metaDataLoader;
    private final Container container = new Container(){
        {
            this.setFluid(true);
        }
    };
    private final ListBox importsList = new ListBox(){
        {
            this.addStyleName(ColumnSize.MD_12.getCssName());
        }
    };
    private final ListBox imagesList = new ListBox(){
        {
            this.addStyleName(ColumnSize.MD_12.getCssName());
        }
    };
    private final FlowPanel elements = new FlowPanel(){
        {
            this.getElement().getStyle().setPaddingBottom(5.0, Style.Unit.PX);
        }
    };
    private WorkItemDefinitionElementSelectedListener presenter;

    public WorkItemDefinitionElementsBrowser() {
        final Heading label = new Heading(HeadingSize.H4, WorkItemsEditorConstants.INSTANCE.BrowserTitle());
        label.getElement().getStyle().setTextAlign(Style.TextAlign.CENTER);
        label.addStyleName(ColumnSize.MD_12.getCssName());
        this.container.add((Widget)new Row(){
            {
                this.add((Widget)label);
            }
        });
        this.container.add((Widget)new Row(){
            {
                this.add((Widget)WorkItemDefinitionElementsBrowser.this.elements);
            }
        });
        this.container.add((Widget)new Row(){
            {
                this.add((Widget)WorkItemDefinitionElementsBrowser.this.importsList);
            }
        });
        this.importsList.addItem(WorkItemsEditorConstants.INSTANCE.ChooseImportClass());
        this.importsList.addItem("BooleanDataType", "import org.drools.core.process.core.datatype.impl.type.BooleanDataType;");
        this.importsList.addItem("EnumDataType", "import org.drools.core.process.core.datatype.impl.type.EnumDataType;");
        this.importsList.addItem("FloatDataType", "import org.drools.core.process.core.datatype.impl.type.FloatDataType;");
        this.importsList.addItem("IntegerDataType", "import org.drools.core.process.core.datatype.impl.type.IntegerDataType;");
        this.importsList.addItem("ListDataType", "import org.drools.core.process.core.datatype.impl.type.ListDataType;");
        this.importsList.addItem("ObjectDataType", "import org.drools.core.process.core.datatype.impl.type.ObjectDataType;");
        this.importsList.addItem("StringDataType", "import org.drools.core.process.core.datatype.impl.type.StringDataType;");
        this.importsList.addItem("UndefinedDataType", "import org.drools.core.process.core.datatype.impl.type.UndefinedDataType;");
        this.importsList.setVisibleItemCount(9);
        this.importsList.setSelectedIndex(0);
        this.importsList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                WorkItemDefinitionElementsBrowser.this.elementSelected(WorkItemDefinitionElementsBrowser.this.importsList.getItemText(WorkItemDefinitionElementsBrowser.this.importsList.getSelectedIndex()), WorkItemDefinitionElementsBrowser.this.importsList.getValue(WorkItemDefinitionElementsBrowser.this.importsList.getSelectedIndex()));
            }
        });
        this.container.add((Widget)new Row(){
            {
                this.add((Widget)WorkItemDefinitionElementsBrowser.this.imagesList);
            }
        });
        this.imagesList.setVisibleItemCount(1);
        this.imagesList.setSelectedIndex(0);
        this.imagesList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                WorkItemDefinitionElementsBrowser.this.elementSelected(WorkItemDefinitionElementsBrowser.this.imagesList.getItemText(WorkItemDefinitionElementsBrowser.this.imagesList.getSelectedIndex()), WorkItemDefinitionElementsBrowser.this.imagesList.getValue(WorkItemDefinitionElementsBrowser.this.imagesList.getSelectedIndex()));
            }
        });
        this.initWidget((Widget)this.container);
    }

    @PostConstruct
    public void loadMetaData() {
        this.metaDataLoader.loadMetaContent(this);
    }

    public void init(WorkItemDefinitionElementSelectedListener presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setDefinitionElements(WorkItemDefinitionElements metaData) {
        for (final Map.Entry entry : metaData.getDefinitionElements().entrySet()) {
            final String description = this.getButtonDescription((String)entry.getKey());
            this.elements.add((Widget)new Button(description){
                {
                    super(x0);
                    this.setBlock(true);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            WorkItemDefinitionElementsBrowser.this.elementSelected(description, (String)entry.getValue());
                        }
                    });
                }
            });
        }
    }

    private String getButtonDescription(String buttonKey) {
        if (buttonKey == null || buttonKey.trim().length() == 0) {
            return "";
        }
        if ("Definition".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.Definition();
        }
        if ("DisplayName".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.DisplayName();
        }
        if ("Parameter".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.Parameter();
        }
        if ("Result".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.Result();
        }
        if ("CustomEditor".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.CustomEditor();
        }
        if ("ParameterValues".equals(buttonKey)) {
            return WorkItemsEditorConstants.INSTANCE.ParameterValues();
        }
        return buttonKey;
    }

    public void setImages(List<String> workItemImages) {
        this.imagesList.clear();
        this.imagesList.addItem(WorkItemsEditorConstants.INSTANCE.ChooseIcon());
        for (String workItemImage : workItemImages) {
            this.imagesList.addItem(workItemImage);
        }
    }

    private void elementSelected(String title, String value) {
        this.presenter.onElementSelected(title, value);
    }
}

