/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.drools.workbench.screens.workitems.client.editor.WorkItemsEditorPresenter;
import org.drools.workbench.screens.workitems.client.editor.WorkItemsEditorView;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.gwtbootstrap3.client.ui.Modal;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.test.MockProvider;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.java.nio.IOException;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Modal.class})
public class WorkItemsEditorPresenterValidationTest {
    @Mock
    WorkItemsEditorService service;
    WorkItemsEditorPresenter presenter;

    @Before
    public void setUp() throws Exception {
        this.presenter = new WorkItemsEditorPresenter((WorkItemsEditorView)Mockito.mock(WorkItemsEditorView.class)){
            {
                this.workItemsService = new CallerMock((Object)WorkItemsEditorPresenterValidationTest.this.service);
                this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
                this.validationPopup = MockProvider.getMockValidationPopup();
            }
        };
    }

    @Test
    public void commandIsCalled() throws Exception {
        ((WorkItemsEditorService)Mockito.doReturn(new ArrayList()).when((Object)this.service)).validate((Path)Mockito.any(Path.class), (Object)Matchers.anyString());
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }

    @Test
    public void callFailsAndCommandIsCalled() throws Exception {
        ((WorkItemsEditorService)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.service)).validate((Path)Mockito.any(Path.class), (Object)Matchers.anyString());
        Command afterValidation = (Command)Mockito.mock(Command.class);
        this.presenter.onValidate(afterValidation);
        ((Command)Mockito.verify((Object)afterValidation)).execute();
    }
}

