/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.workitems.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.drools.workbench.screens.workitems.client.editor.WorkItemsEditorView;
import org.drools.workbench.screens.workitems.client.widget.WorkItemDefinitionEditor;
import org.drools.workbench.screens.workitems.client.widget.WorkItemDefinitionElementSelectedListener;
import org.drools.workbench.screens.workitems.client.widget.WorkItemDefinitionElementsBrowser;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.Row;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;

public class WorkItemsEditorViewImpl
extends KieEditorViewImpl
implements WorkItemsEditorView,
WorkItemDefinitionElementSelectedListener {
    private static int SCROLL_BAR_SIZE = 32;
    private static int CONTAINER_PADDING = 15;
    private static int VERTICAL_MARGIN = SCROLL_BAR_SIZE + CONTAINER_PADDING * 2;
    private static WorkItemsEditorViewBinder uiBinder = (WorkItemsEditorViewBinder)GWT.create(WorkItemsEditorViewBinder.class);
    @UiField
    Row row;
    @UiField
    Column editorContainer;
    @UiField
    WorkItemDefinitionEditor workItemWidget;
    @UiField(provided=true)
    WorkItemDefinitionElementsBrowser workItemBrowser;

    @Inject
    public WorkItemsEditorViewImpl(WorkItemDefinitionElementsBrowser workItemBrowser) {
        this.workItemBrowser = (WorkItemDefinitionElementsBrowser)PortablePreconditions.checkNotNull((String)"workItemBrowser", (Object)workItemBrowser);
    }

    @PostConstruct
    public void bind() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.workItemBrowser.init(this);
    }

    @Override
    public void setContent(String definition, List<String> workItemImages) {
        this.workItemWidget.setContent(definition);
        this.workItemBrowser.setImages(workItemImages);
    }

    @Override
    public String getContent() {
        return this.workItemWidget.getContent();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.workItemWidget.setReadOnly(readOnly);
    }

    @Override
    public void onElementSelected(String title, String value) {
        this.workItemWidget.insertAtCursor(value);
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight() - VERTICAL_MARGIN;
        this.row.setHeight((height > 0 ? height : 0) + "px");
        this.editorContainer.setHeight((height > 0 ? height : 0) + SCROLL_BAR_SIZE + "px");
        this.workItemWidget.onResize();
    }

    static interface WorkItemsEditorViewBinder
    extends UiBinder<Widget, WorkItemsEditorViewImpl> {
    }
}

