/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.imports;

import org.drools.workbench.models.commons.backend.imports.ImportsParser;
import org.drools.workbench.models.commons.shared.imports.Import;
import org.drools.workbench.models.commons.shared.imports.Imports;
import org.junit.Assert;
import org.junit.Test;

public class ImportsParserTest {
    @Test
    public void testNullContent() {
        String content = null;
        Imports imports = ImportsParser.parseImports(content);
        Assert.assertNotNull((Object)imports);
        Assert.assertTrue((boolean)imports.getImports().isEmpty());
    }

    @Test
    public void testEmptyContent() {
        String content = "";
        Imports imports = ImportsParser.parseImports((String)"");
        Assert.assertNotNull((Object)imports);
        Assert.assertTrue((boolean)imports.getImports().isEmpty());
    }

    @Test
    public void testCommentedContent() {
        String content = "#This is a comment";
        Imports imports = ImportsParser.parseImports((String)"#This is a comment");
        Assert.assertNotNull((Object)imports);
        Assert.assertTrue((boolean)imports.getImports().isEmpty());
    }

    @Test
    public void testSingleImportContent() {
        String content = "import java.lang.String;";
        Imports imports = ImportsParser.parseImports((String)"import java.lang.String;");
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)1L, (long)imports.getImports().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((Import)imports.getImports().get(0)).getType());
    }

    @Test
    public void testMultipleImportsContent() {
        String content = "import java.lang.String;\nimport java.lang.Double;\n";
        Imports imports = ImportsParser.parseImports((String)"import java.lang.String;\nimport java.lang.Double;\n");
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)2L, (long)imports.getImports().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((Import)imports.getImports().get(0)).getType());
        Assert.assertEquals((Object)"java.lang.Double", (Object)((Import)imports.getImports().get(1)).getType());
    }

    @Test
    public void testMixedContent() {
        String content = "import java.lang.String;\n#This is a comment\nimport java.lang.Double;\n\nimport java.lang.Byte;\n";
        Imports imports = ImportsParser.parseImports((String)"import java.lang.String;\n#This is a comment\nimport java.lang.Double;\n\nimport java.lang.Byte;\n");
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)3L, (long)imports.getImports().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((Import)imports.getImports().get(0)).getType());
        Assert.assertEquals((Object)"java.lang.Double", (Object)((Import)imports.getImports().get(1)).getType());
        Assert.assertEquals((Object)"java.lang.Byte", (Object)((Import)imports.getImports().get(2)).getType());
    }
}

