/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import junit.framework.Assert;
import org.drools.workbench.models.commons.backend.rule.BRDRLPersistence;
import org.drools.workbench.models.commons.shared.rule.CompositeFieldConstraint;
import org.drools.workbench.models.commons.shared.rule.FactPattern;
import org.drools.workbench.models.commons.shared.rule.IPattern;
import org.drools.workbench.models.commons.shared.rule.RuleModel;
import org.drools.workbench.models.commons.shared.rule.SingleFieldConstraint;
import org.junit.Ignore;
import org.junit.Test;

public class BRDRLPersistenceUnmarshallingTest {
    @Test
    public void testFactPattern() {
        String drl = "rule \"rule1\"\nwhen\nApplicant()\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)0, (int)fp.getNumberOfConstraints());
    }

    @Test
    public void testFactPatternWithBinding() {
        String drl = "rule \"rule1\"\nwhen\n$a : Applicant()\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((String)"$a", (String)fp.getBoundName());
        Assert.assertEquals((int)0, (int)fp.getNumberOfConstraints());
    }

    @Test
    public void testSingleFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age < 55 )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"<", (String)sfp.getOperator());
        Assert.assertEquals((String)"55", (String)sfp.getValue());
        Assert.assertEquals((int)1, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintWithBinding() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( $a : age < 55 )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"<", (String)sfp.getOperator());
        Assert.assertEquals((String)"55", (String)sfp.getValue());
        Assert.assertEquals((int)1, (int)sfp.getConstraintValueType());
        Assert.assertEquals((String)"$a", (String)sfp.getFieldBinding());
    }

    @Test
    public void testCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age < 55 || age > 70 )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp = (CompositeFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"||", (String)cfp.getCompositeJunctionType());
        Assert.assertEquals((int)2, (int)cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)cfp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)sfp1.getFieldName());
        Assert.assertEquals((String)"<", (String)sfp1.getOperator());
        Assert.assertEquals((String)"55", (String)sfp1.getValue());
        Assert.assertEquals((int)1, (int)sfp1.getConstraintValueType());
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)cfp.getConstraint(1);
        Assert.assertEquals((String)"Applicant", (String)sfp2.getFactType());
        Assert.assertEquals((String)"age", (String)sfp2.getFieldName());
        Assert.assertEquals((String)">", (String)sfp2.getOperator());
        Assert.assertEquals((String)"70", (String)sfp2.getValue());
        Assert.assertEquals((int)1, (int)sfp2.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintIsNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age == null )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"== null", (String)sfp.getOperator());
        Assert.assertNull((Object)sfp.getValue());
        Assert.assertEquals((int)0, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintIsNotNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age != null )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"!= null", (String)sfp.getOperator());
        Assert.assertNull((Object)sfp.getValue());
        Assert.assertEquals((int)0, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testCompositeFieldConstraintWithNotNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age != null && age > 70 )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp = (CompositeFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"&&", (String)cfp.getCompositeJunctionType());
        Assert.assertEquals((int)2, (int)cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)cfp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)sfp1.getFieldName());
        Assert.assertEquals((String)"!= null", (String)sfp1.getOperator());
        Assert.assertNull((Object)sfp1.getValue());
        Assert.assertEquals((int)0, (int)sfp1.getConstraintValueType());
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)cfp.getConstraint(1);
        Assert.assertEquals((String)"Applicant", (String)sfp2.getFactType());
        Assert.assertEquals((String)"age", (String)sfp2.getFieldName());
        Assert.assertEquals((String)">", (String)sfp2.getOperator());
        Assert.assertEquals((String)"70", (String)sfp2.getValue());
        Assert.assertEquals((int)1, (int)sfp2.getConstraintValueType());
    }

    @Test
    @Ignore(value="Unmarshalling of CEP is broken")
    public void testSingleFieldConstraintCEPOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( dob after \"26-Jun-2013\" )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"dob", (String)sfp.getFieldName());
        Assert.assertEquals((String)"after", (String)sfp.getOperator());
        Assert.assertEquals((String)"26-Jun-2013", (String)sfp.getValue());
        Assert.assertEquals((int)1, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintContainsOperator() {
        String drl = "rule \"rule1\"\nwhen\n$is : IncomeSource( )\nApplicant( incomes contains $is )\nthen\nend";
        RuleModel m = BRDRLPersistence.getInstance().unmarshal(drl);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)2, (int)m.lhs.length);
        IPattern p0 = m.lhs[0];
        Assert.assertTrue((boolean)(p0 instanceof FactPattern));
        FactPattern fp0 = (FactPattern)p0;
        Assert.assertEquals((String)"IncomeSource", (String)fp0.getFactType());
        Assert.assertEquals((String)"$is", (String)fp0.getBoundName());
        IPattern p1 = m.lhs[1];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((String)"Applicant", (String)fp1.getFactType());
        Assert.assertEquals((int)0, (int)fp0.getNumberOfConstraints());
        Assert.assertEquals((int)1, (int)fp1.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"incomes", (String)sfp.getFieldName());
        Assert.assertEquals((String)"contains", (String)sfp.getOperator());
        Assert.assertEquals((String)"$is", (String)sfp.getValue());
        Assert.assertEquals((int)2, (int)sfp.getConstraintValueType());
    }
}

