/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionGlobalCollectionAdd;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.CEPWindow;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ExpressionField;
import org.drools.workbench.models.datamodel.rule.ExpressionUnboundFact;
import org.drools.workbench.models.datamodel.rule.ExpressionVariable;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RuleModelDRLPersistenceUnmarshallingTest {
    private PackageDataModelOracle dmo;
    private Map<String, ModelField[]> packageModelFields = new HashMap<String, ModelField[]>();

    @Before
    public void setUp() throws Exception {
        this.dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)this.dmo.getProjectModelFields()).thenReturn(this.packageModelFields);
    }

    @After
    public void cleanUp() throws Exception {
        this.packageModelFields.clear();
    }

    private void addModelField(String factName, String fieldName, String clazz, String type) {
        ModelField[] modelFields = new ModelField[]{new ModelField(fieldName, clazz, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type)};
        if (this.packageModelFields.containsKey(factName)) {
            ArrayList<Object> existingModelFields = new ArrayList<Object>(Arrays.asList((Object[])this.packageModelFields.get(factName)));
            existingModelFields.add(modelFields[0]);
            modelFields = existingModelFields.toArray(modelFields);
        }
        this.packageModelFields.put(factName, modelFields);
    }

    @Test
    public void testFactPattern() {
        String drl = "rule \"rule1\"\nwhen\nApplicant()\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)0, (int)fp.getNumberOfConstraints());
    }

    @Test
    public void testFactPatternWithBinding() {
        String drl = "rule \"rule1\"\nwhen\n$a : Applicant()\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((String)"$a", (String)fp.getBoundName());
        Assert.assertEquals((int)0, (int)fp.getNumberOfConstraints());
    }

    @Test
    public void testSingleFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age < 55 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"<", (String)sfp.getOperator());
        Assert.assertEquals((String)"55", (String)sfp.getValue());
        Assert.assertEquals((int)1, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintWithBinding() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( $a : age < 55 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"<", (String)sfp.getOperator());
        Assert.assertEquals((String)"55", (String)sfp.getValue());
        Assert.assertEquals((int)1, (int)sfp.getConstraintValueType());
        Assert.assertEquals((String)"$a", (String)sfp.getFieldBinding());
    }

    @Test
    public void testCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age < 55 || age > 70 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp = (CompositeFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"||", (String)cfp.getCompositeJunctionType());
        Assert.assertEquals((int)2, (int)cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)cfp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)sfp1.getFieldName());
        Assert.assertEquals((String)"<", (String)sfp1.getOperator());
        Assert.assertEquals((String)"55", (String)sfp1.getValue());
        Assert.assertEquals((int)1, (int)sfp1.getConstraintValueType());
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)cfp.getConstraint(1);
        Assert.assertEquals((String)"Applicant", (String)sfp2.getFactType());
        Assert.assertEquals((String)"age", (String)sfp2.getFieldName());
        Assert.assertEquals((String)">", (String)sfp2.getOperator());
        Assert.assertEquals((String)"70", (String)sfp2.getValue());
        Assert.assertEquals((int)1, (int)sfp2.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintIsNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age == null )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"== null", (String)sfp.getOperator());
        Assert.assertNull((Object)sfp.getValue());
        Assert.assertEquals((int)0, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintIsNotNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age != null )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"age", (String)sfp.getFieldName());
        Assert.assertEquals((String)"!= null", (String)sfp.getOperator());
        Assert.assertNull((Object)sfp.getValue());
        Assert.assertEquals((int)0, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testCompositeFieldConstraintWithNotNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age != null && age > 70 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp = (CompositeFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"&&", (String)cfp.getCompositeJunctionType());
        Assert.assertEquals((int)2, (int)cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)cfp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)sfp1.getFieldName());
        Assert.assertEquals((String)"!= null", (String)sfp1.getOperator());
        Assert.assertNull((Object)sfp1.getValue());
        Assert.assertEquals((int)0, (int)sfp1.getConstraintValueType());
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)cfp.getConstraint(1);
        Assert.assertEquals((String)"Applicant", (String)sfp2.getFactType());
        Assert.assertEquals((String)"age", (String)sfp2.getFieldName());
        Assert.assertEquals((String)">", (String)sfp2.getOperator());
        Assert.assertEquals((String)"70", (String)sfp2.getValue());
        Assert.assertEquals((int)1, (int)sfp2.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintCEPOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( dob after \"26-Jun-2013\" )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"dob", (String)sfp.getFieldName());
        Assert.assertEquals((String)"after", (String)sfp.getOperator());
        Assert.assertEquals((String)"26-Jun-2013", (String)sfp.getValue());
        Assert.assertEquals((int)1, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintCEPOperator1Parameter() {
        String drl = "rule \"rule1\"\nwhen\n$e : Event()\nEvent( this after[1d] $e )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)2, (int)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((String)"Event", (String)fp1.getFactType());
        Assert.assertEquals((String)"$e", (String)fp1.getBoundName());
        Assert.assertEquals((int)0, (int)fp1.getNumberOfConstraints());
        IPattern p2 = m.lhs[1];
        Assert.assertTrue((boolean)(p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)p2;
        Assert.assertEquals((String)"Event", (String)fp2.getFactType());
        Assert.assertNull((Object)fp2.getBoundName());
        Assert.assertEquals((int)1, (int)fp2.getNumberOfConstraints());
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((String)"Event", (String)sfp.getFactType());
        Assert.assertEquals((String)"this", (String)sfp.getFieldName());
        Assert.assertEquals((String)"after", (String)sfp.getOperator());
        Assert.assertEquals((String)"$e", (String)sfp.getValue());
        Assert.assertEquals((int)2, (int)sfp.getConstraintValueType());
        Assert.assertEquals((int)3, (int)sfp.getParameters().size());
        Assert.assertEquals((String)"1d", (String)sfp.getParameter("0"));
        Assert.assertEquals((String)"1", (String)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.visibleParameterSet"));
        Assert.assertEquals((String)"org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder", (String)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperator1Parameter() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n$e : Event()\nEvent( this after[1d] $e )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        fp1.setBoundName("$e");
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Event");
        SingleFieldConstraint sfp = new SingleFieldConstraint();
        sfp.setFactType("Event");
        sfp.setFieldName("this");
        sfp.setOperator("after");
        sfp.setValue("$e");
        sfp.setConstraintValueType(2);
        sfp.getParameters().put("0", "1d");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.visibleParameterSet", "1");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder");
        fp2.addConstraint((FieldConstraint)sfp);
        m.addLhsItem((IPattern)fp1);
        m.addLhsItem((IPattern)fp2);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testSingleFieldConstraintCEPOperator2Parameters() {
        String drl = "rule \"rule1\"\nwhen\n$e : Event()\nEvent( this after[1d, 2d] $e )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)2, (int)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((String)"Event", (String)fp1.getFactType());
        Assert.assertEquals((String)"$e", (String)fp1.getBoundName());
        Assert.assertEquals((int)0, (int)fp1.getNumberOfConstraints());
        IPattern p2 = m.lhs[1];
        Assert.assertTrue((boolean)(p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)p2;
        Assert.assertEquals((String)"Event", (String)fp2.getFactType());
        Assert.assertNull((Object)fp2.getBoundName());
        Assert.assertEquals((int)1, (int)fp2.getNumberOfConstraints());
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((String)"Event", (String)sfp.getFactType());
        Assert.assertEquals((String)"this", (String)sfp.getFieldName());
        Assert.assertEquals((String)"after", (String)sfp.getOperator());
        Assert.assertEquals((String)"$e", (String)sfp.getValue());
        Assert.assertEquals((int)2, (int)sfp.getConstraintValueType());
        Assert.assertEquals((int)4, (int)sfp.getParameters().size());
        Assert.assertEquals((String)"1d", (String)sfp.getParameter("0"));
        Assert.assertEquals((String)"2d", (String)sfp.getParameter("1"));
        Assert.assertEquals((String)"2", (String)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.visibleParameterSet"));
        Assert.assertEquals((String)"org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder", (String)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperator2Parameters() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n$e : Event()\nEvent( this after[1d, 2d] $e )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        fp1.setBoundName("$e");
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Event");
        SingleFieldConstraint sfp = new SingleFieldConstraint();
        sfp.setFactType("Event");
        sfp.setFieldName("this");
        sfp.setOperator("after");
        sfp.setValue("$e");
        sfp.setConstraintValueType(2);
        sfp.getParameters().put("0", "1d");
        sfp.getParameters().put("1", "2d");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.visibleParameterSet", "2");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder");
        fp2.addConstraint((FieldConstraint)sfp);
        m.addLhsItem((IPattern)fp1);
        m.addLhsItem((IPattern)fp2);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testSingleFieldConstraintCEPOperatorTimeWindow() {
        String drl = "rule \"rule1\"\nwhen\nEvent() over window:time (1d)\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((String)"Event", (String)fp1.getFactType());
        Assert.assertNull((Object)fp1.getBoundName());
        Assert.assertEquals((int)0, (int)fp1.getNumberOfConstraints());
        Assert.assertNotNull((Object)fp1.getWindow());
        CEPWindow window = fp1.getWindow();
        Assert.assertEquals((String)"over window:time", (String)window.getOperator());
        Assert.assertEquals((int)2, (int)window.getParameters().size());
        Assert.assertEquals((String)"1d", (String)window.getParameter("1"));
        Assert.assertEquals((String)"org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder", (String)window.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperatorTimeWindow() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nEvent() over window:time (1d)\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        CEPWindow window = new CEPWindow();
        window.setOperator("over window:time");
        window.getParameters().put("1", "1d");
        window.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder");
        fp1.setWindow(window);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testSingleFieldConstraintCEPOperatorTimeLength() {
        String drl = "rule \"rule1\"\nwhen\nEvent() over window:length (10)\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((String)"Event", (String)fp1.getFactType());
        Assert.assertNull((Object)fp1.getBoundName());
        Assert.assertEquals((int)0, (int)fp1.getNumberOfConstraints());
        Assert.assertNotNull((Object)fp1.getWindow());
        CEPWindow window = fp1.getWindow();
        Assert.assertEquals((String)"over window:length", (String)window.getOperator());
        Assert.assertEquals((int)2, (int)window.getParameters().size());
        Assert.assertEquals((String)"10", (String)window.getParameter("1"));
        Assert.assertEquals((String)"org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder", (String)window.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperatorTimeLength() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nEvent() over window:length (10)\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        CEPWindow window = new CEPWindow();
        window.setOperator("over window:length");
        window.getParameters().put("1", "10");
        window.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder");
        fp1.setWindow(window);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testExtends() {
        String drl = "rule \"rule1\" extends \"rule2\" \nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((String)"rule2", (String)m.parentName);
    }

    @Test
    public void testRuleNameWithoutTheQuotes() {
        String drl = "rule rule1\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
    }

    @Test
    public void testMetaData() {
        String drl = "rule rule1\n@author( Bob )\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.metadataList.length);
        Assert.assertEquals((String)"author", (String)m.metadataList[0].getAttributeName());
        Assert.assertEquals((String)"Bob", (String)m.metadataList[0].getValue());
    }

    @Test
    public void testAttributes() {
        String drl = "rule rule1\nsalience 42\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.attributes.length);
        Assert.assertEquals((String)"salience", (String)m.attributes[0].getAttributeName());
        Assert.assertEquals((String)"42", (String)m.attributes[0].getValue());
    }

    @Test
    public void testEval() {
        String drl = "rule rule1\nwhen\neval( true )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FreeFormLine));
        Assert.assertEquals((String)"eval( true )", (String)((FreeFormLine)m.lhs[0]).getText());
    }

    @Test
    public void testFreeFormLine() {
        String drl = "rule rule1\nwhen\nthen\nint test = (int)(1-0.8);\nSystem.out.println( \"Hello Mario!\" );\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)2, (int)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof FreeFormLine));
        Assert.assertEquals((String)"int test = (int)(1-0.8);", (String)((FreeFormLine)m.rhs[0]).getText());
        Assert.assertTrue((boolean)(m.rhs[1] instanceof FreeFormLine));
        Assert.assertEquals((String)"System.out.println( \"Hello Mario!\" );", (String)((FreeFormLine)m.rhs[1]).getText());
    }

    @Test
    public void testNestedFieldExpressions() {
        String drl = "rule rule1\nwhen\nPerson( address.postalCode == 12345 )\nthen\nend";
        this.addModelField("org.test.Person", "address", "org.test.Address", "Address");
        this.addModelField("org.test.Address", "postalCode", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((String)"postalCode", (String)ebLeftSide.getFieldName());
        Assert.assertEquals((String)"java.lang.Integer", (String)ebLeftSide.getFieldType());
        Assert.assertEquals((String)"==", (String)ebLeftSide.getOperator());
        Assert.assertEquals((String)"12345", (String)ebLeftSide.getValue());
        Assert.assertEquals((int)3, (int)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getName());
        Assert.assertEquals((String)"org.test.Person", (String)expressionUnboundFact.getClassType());
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((String)"address", (String)expressionField1.getName());
        Assert.assertEquals((String)"Address", (String)expressionField1.getClassType());
        Assert.assertEquals((String)"Address", (String)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((String)"postalCode", (String)expressionField2.getName());
        Assert.assertEquals((String)"java.lang.Integer", (String)expressionField2.getClassType());
        Assert.assertEquals((String)"Integer", (String)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testNestedFieldExpressionsWithAFunction() {
        String drl = "rule rule1\nwhen\nPerson( address.postalCode == myFunction() )\nthen\nend";
        this.addModelField("org.test.Person", "address", "org.test.Address", "Address");
        this.addModelField("org.test.Address", "postalCode", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((String)"postalCode", (String)ebLeftSide.getFieldName());
        Assert.assertEquals((String)"java.lang.Integer", (String)ebLeftSide.getFieldType());
        Assert.assertEquals((String)"==", (String)ebLeftSide.getOperator());
        Assert.assertEquals((String)"myFunction()", (String)ebLeftSide.getValue());
        Assert.assertEquals((int)3, (int)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getName());
        Assert.assertEquals((String)"org.test.Person", (String)expressionUnboundFact.getClassType());
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((String)"address", (String)expressionField1.getName());
        Assert.assertEquals((String)"Address", (String)expressionField1.getClassType());
        Assert.assertEquals((String)"Address", (String)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((String)"postalCode", (String)expressionField2.getName());
        Assert.assertEquals((String)"java.lang.Integer", (String)expressionField2.getClassType());
        Assert.assertEquals((String)"Integer", (String)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testNestedFieldExpressionsWithAnotherExpression() {
        String drl = "rule rule1\nwhen\np : Person( address.postalCode == p.address.postalCode) )\nthen\nend";
        this.addModelField("org.test.Person", "address", "org.test.Address", "Address");
        this.addModelField("org.test.Person", "this", "org.test.Person", "this");
        this.addModelField("org.test.Address", "postalCode", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((String)"postalCode", (String)ebLeftSide.getFieldName());
        Assert.assertEquals((String)"java.lang.Integer", (String)ebLeftSide.getFieldType());
        Assert.assertEquals((String)"==", (String)ebLeftSide.getOperator());
        Assert.assertEquals((String)"", (String)ebLeftSide.getValue());
        Assert.assertEquals((int)3, (int)ebLeftSide.getExpressionValue().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionValue().getParts().get(0) instanceof ExpressionVariable));
        ExpressionVariable expressionVariable = (ExpressionVariable)ebLeftSide.getExpressionValue().getParts().get(0);
        Assert.assertEquals((String)"p", (String)expressionVariable.getName());
        Assert.assertEquals((String)"Person", (String)expressionVariable.getClassType());
        Assert.assertEquals((String)"this", (String)expressionVariable.getGenericType());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionValue().getParts().get(1) instanceof ExpressionField));
        ExpressionField ef1 = (ExpressionField)ebLeftSide.getExpressionValue().getParts().get(1);
        Assert.assertEquals((String)"address", (String)ef1.getName());
        Assert.assertEquals((String)"Address", (String)ef1.getClassType());
        Assert.assertEquals((String)"Address", (String)ef1.getGenericType());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionValue().getParts().get(2) instanceof ExpressionField));
        ExpressionField ef2 = (ExpressionField)ebLeftSide.getExpressionValue().getParts().get(2);
        Assert.assertEquals((String)"postalCode", (String)ef2.getName());
        Assert.assertEquals((String)"java.lang.Integer", (String)ef2.getClassType());
        Assert.assertEquals((String)"Integer", (String)ef2.getGenericType());
        Assert.assertEquals((int)3, (int)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getName());
        Assert.assertEquals((String)"org.test.Person", (String)expressionUnboundFact.getClassType());
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((String)"address", (String)expressionField1.getName());
        Assert.assertEquals((String)"Address", (String)expressionField1.getClassType());
        Assert.assertEquals((String)"Address", (String)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((String)"postalCode", (String)expressionField2.getName());
        Assert.assertEquals((String)"java.lang.Integer", (String)expressionField2.getClassType());
        Assert.assertEquals((String)"Integer", (String)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testSingleFieldConstraintContainsOperator() {
        String drl = "rule \"rule1\"\nwhen\n$is : IncomeSource( )\nApplicant( incomes contains $is )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)2, (int)m.lhs.length);
        IPattern p0 = m.lhs[0];
        Assert.assertTrue((boolean)(p0 instanceof FactPattern));
        FactPattern fp0 = (FactPattern)p0;
        Assert.assertEquals((String)"IncomeSource", (String)fp0.getFactType());
        Assert.assertEquals((String)"$is", (String)fp0.getBoundName());
        IPattern p1 = m.lhs[1];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((String)"Applicant", (String)fp1.getFactType());
        Assert.assertEquals((int)0, (int)fp0.getNumberOfConstraints());
        Assert.assertEquals((int)1, (int)fp1.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((String)"Applicant", (String)sfp.getFactType());
        Assert.assertEquals((String)"incomes", (String)sfp.getFieldName());
        Assert.assertEquals((String)"contains", (String)sfp.getOperator());
        Assert.assertEquals((String)"$is", (String)sfp.getValue());
        Assert.assertEquals((int)2, (int)sfp.getConstraintValueType());
    }

    @Test
    public void testCompositeFactPatternWithOr() {
        String drl = "rule \"rule1\"\nwhen\n( Person( age == 42 ) or Person( age == 43 ) )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof CompositeFactPattern));
        CompositeFactPattern cfp = (CompositeFactPattern)p;
        Assert.assertEquals((String)"or", (String)cfp.getType());
        Assert.assertEquals((int)2, (int)cfp.getPatterns().length);
        IFactPattern cfp_p1 = cfp.getPatterns()[0];
        Assert.assertTrue((boolean)(cfp_p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)cfp_p1;
        Assert.assertEquals((String)"Person", (String)fp1.getFactType());
        Assert.assertEquals((int)1, (int)fp1.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_sfp1 = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((String)"Person", (String)cfp_sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)cfp_sfp1.getFieldName());
        Assert.assertEquals((String)"==", (String)cfp_sfp1.getOperator());
        Assert.assertEquals((String)"42", (String)cfp_sfp1.getValue());
        Assert.assertEquals((int)1, (int)cfp_sfp1.getConstraintValueType());
        IFactPattern cfp_p2 = cfp.getPatterns()[1];
        Assert.assertTrue((boolean)(cfp_p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)cfp_p2;
        Assert.assertEquals((String)"Person", (String)fp2.getFactType());
        Assert.assertTrue((boolean)(fp2.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_sfp2 = (SingleFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((String)"Person", (String)cfp_sfp2.getFactType());
        Assert.assertEquals((String)"age", (String)cfp_sfp2.getFieldName());
        Assert.assertEquals((String)"==", (String)cfp_sfp2.getOperator());
        Assert.assertEquals((String)"43", (String)cfp_sfp2.getValue());
        Assert.assertEquals((int)1, (int)cfp_sfp2.getConstraintValueType());
    }

    @Test
    public void testReciprocal_CompositeFactPatternWithOr() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n( Person( age == 42 ) or Person( age == 43 ) )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        CompositeFactPattern cfp = new CompositeFactPattern();
        cfp.setType("or");
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Person");
        SingleFieldConstraint cfp_sfp1 = new SingleFieldConstraint();
        cfp_sfp1.setFactType("Person");
        cfp_sfp1.setFieldName("age");
        cfp_sfp1.setOperator("==");
        cfp_sfp1.setValue("42");
        cfp_sfp1.setFieldType("Integer");
        cfp_sfp1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)cfp_sfp1);
        cfp.addFactPattern((IFactPattern)fp1);
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Person");
        SingleFieldConstraint cfp_sfp2 = new SingleFieldConstraint();
        cfp_sfp2.setFactType("Person");
        cfp_sfp2.setFieldName("age");
        cfp_sfp2.setOperator("==");
        cfp_sfp2.setValue("43");
        cfp_sfp2.setFieldType("Integer");
        cfp_sfp2.setConstraintValueType(1);
        fp2.addConstraint((FieldConstraint)cfp_sfp2);
        cfp.addFactPattern((IFactPattern)fp2);
        m.addLhsItem((IPattern)cfp);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testCompositeFactPatternWithOrAndCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\n( Person( age == 42 ) or Person( age == 43 || age == 44) )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof CompositeFactPattern));
        CompositeFactPattern cfp = (CompositeFactPattern)p;
        Assert.assertEquals((String)"or", (String)cfp.getType());
        Assert.assertEquals((int)2, (int)cfp.getPatterns().length);
        IFactPattern cfp_p1 = cfp.getPatterns()[0];
        Assert.assertTrue((boolean)(cfp_p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)cfp_p1;
        Assert.assertEquals((String)"Person", (String)fp1.getFactType());
        Assert.assertEquals((int)1, (int)fp1.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_sfp1 = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((String)"Person", (String)cfp_sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)cfp_sfp1.getFieldName());
        Assert.assertEquals((String)"==", (String)cfp_sfp1.getOperator());
        Assert.assertEquals((String)"42", (String)cfp_sfp1.getValue());
        Assert.assertEquals((int)1, (int)cfp_sfp1.getConstraintValueType());
        IFactPattern cfp_p2 = cfp.getPatterns()[1];
        Assert.assertTrue((boolean)(cfp_p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)cfp_p2;
        Assert.assertEquals((int)1, (int)fp2.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp2.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp_p2_cfp = (CompositeFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((String)"||", (String)cfp_p2_cfp.getCompositeJunctionType());
        Assert.assertEquals((int)2, (int)cfp_p2_cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp_p2_cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp_p2_cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_p2_sfp1 = (SingleFieldConstraint)cfp_p2_cfp.getConstraint(0);
        Assert.assertEquals((String)"Person", (String)cfp_p2_sfp1.getFactType());
        Assert.assertEquals((String)"age", (String)cfp_p2_sfp1.getFieldName());
        Assert.assertEquals((String)"==", (String)cfp_p2_sfp1.getOperator());
        Assert.assertEquals((String)"43", (String)cfp_p2_sfp1.getValue());
        Assert.assertEquals((int)1, (int)cfp_p2_sfp1.getConstraintValueType());
        SingleFieldConstraint cfp_p2_sfp2 = (SingleFieldConstraint)cfp_p2_cfp.getConstraint(1);
        Assert.assertEquals((String)"Person", (String)cfp_p2_sfp2.getFactType());
        Assert.assertEquals((String)"age", (String)cfp_p2_sfp2.getFieldName());
        Assert.assertEquals((String)"==", (String)cfp_p2_sfp2.getOperator());
        Assert.assertEquals((String)"44", (String)cfp_p2_sfp2.getValue());
        Assert.assertEquals((int)1, (int)cfp_p2_sfp2.getConstraintValueType());
    }

    @Test
    public void testReciprocal_CompositeFactPatternWithOrAndCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n( Person( age == 42 ) or Person( age == 43 || age == 44) )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        CompositeFactPattern cfp = new CompositeFactPattern();
        cfp.setType("or");
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Person");
        SingleFieldConstraint fp1_sfp1 = new SingleFieldConstraint();
        fp1_sfp1.setFactType("Person");
        fp1_sfp1.setFieldName("age");
        fp1_sfp1.setOperator("==");
        fp1_sfp1.setValue("42");
        fp1_sfp1.setFieldType("Integer");
        fp1_sfp1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)fp1_sfp1);
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Person");
        CompositeFieldConstraint fp2_cfp = new CompositeFieldConstraint();
        fp2_cfp.setCompositeJunctionType("||");
        fp2.addConstraint((FieldConstraint)fp2_cfp);
        SingleFieldConstraint fp2_sfp1 = new SingleFieldConstraint();
        fp2_sfp1.setFactType("Person");
        fp2_sfp1.setFieldName("age");
        fp2_sfp1.setOperator("==");
        fp2_sfp1.setValue("43");
        fp2_sfp1.setFieldType("Integer");
        fp2_sfp1.setConstraintValueType(1);
        fp2_cfp.addConstraint((FieldConstraint)fp2_sfp1);
        SingleFieldConstraint fp2_sfp2 = new SingleFieldConstraint();
        fp2_sfp2.setFactType("Person");
        fp2_sfp2.setFieldName("age");
        fp2_sfp2.setOperator("==");
        fp2_sfp2.setValue("44");
        fp2_sfp2.setFieldType("Integer");
        fp2_sfp2.setConstraintValueType(1);
        fp2_cfp.addConstraint((FieldConstraint)fp2_sfp2);
        cfp.addFactPattern((IFactPattern)fp1);
        cfp.addFactPattern((IFactPattern)fp2);
        m.addLhsItem((IPattern)cfp);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testNestedFieldConstraints() {
        String drl = "rule \"rule1\"\nwhen\nParentType( this != null, this.parentChildField != null, this.parentChildField.childField == \"hello\" )\nthen\nend";
        this.addModelField("org.test.ParentType", "parentChildField", "org.test.ChildType", "ChildType");
        this.addModelField("org.test.ChildType", "childField", "java.lang.String", "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"ParentType", (String)fp.getFactType());
        Assert.assertEquals((int)3, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp0 = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((String)"ParentType", (String)sfp0.getFactType());
        Assert.assertEquals((String)"this", (String)sfp0.getFieldName());
        Assert.assertEquals((String)"this", (String)sfp0.getFieldType());
        Assert.assertEquals((String)"!= null", (String)sfp0.getOperator());
        Assert.assertNull((Object)sfp0.getValue());
        Assert.assertEquals((int)0, (int)sfp0.getConstraintValueType());
        Assert.assertNull((Object)sfp0.getParent());
        Assert.assertTrue((boolean)(fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)fp.getConstraint(1);
        Assert.assertEquals((String)"ParentType", (String)sfp1.getFactType());
        Assert.assertEquals((String)"parentChildField", (String)sfp1.getFieldName());
        Assert.assertEquals((String)"ChildType", (String)sfp1.getFieldType());
        Assert.assertEquals((String)"!= null", (String)sfp1.getOperator());
        Assert.assertNull((Object)sfp1.getValue());
        Assert.assertEquals((int)0, (int)sfp1.getConstraintValueType());
        Assert.assertSame((Object)sfp0, (Object)sfp1.getParent());
        Assert.assertTrue((boolean)(fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)fp.getConstraint(2);
        Assert.assertEquals((String)"childField", (String)sfp2.getFieldName());
        Assert.assertEquals((String)"java.lang.String", (String)sfp2.getFieldType());
        Assert.assertEquals((String)"==", (String)sfp2.getOperator());
        Assert.assertEquals((String)"hello", (String)sfp2.getValue());
        Assert.assertEquals((int)1, (int)sfp2.getConstraintValueType());
        Assert.assertSame((Object)sfp1, (Object)sfp2.getParent());
    }

    @Test
    public void testReciprocal_NestedFieldConstraints() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nParentType( this != null, this.parentChildField != null, this.parentChildField.childField == \"hello\" )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("ParentType");
        SingleFieldConstraint fp1_sfp1 = new SingleFieldConstraint();
        fp1_sfp1.setFactType("ParentType");
        fp1_sfp1.setFieldName("this");
        fp1_sfp1.setFieldType("this");
        fp1_sfp1.setOperator("!= null");
        fp1_sfp1.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp2 = new SingleFieldConstraint();
        fp1_sfp2.setFactType("ParentType");
        fp1_sfp2.setFieldName("parentChildField");
        fp1_sfp2.setFieldType("ChildType");
        fp1_sfp2.setOperator("!= null");
        fp1_sfp2.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp2);
        fp1_sfp2.setParent((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp3 = new SingleFieldConstraint();
        fp1_sfp3.setFactType("ChildType");
        fp1_sfp3.setFieldName("childField");
        fp1_sfp3.setFieldType("String");
        fp1_sfp3.setOperator("==");
        fp1_sfp3.setValue("hello");
        fp1_sfp3.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)fp1_sfp3);
        fp1_sfp3.setParent((FieldConstraint)fp1_sfp2);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testNestedFieldConstraintsAsExpression() {
        String drl = "rule \"rule1\"\nwhen\nPerson( contact.telephone > 12345 )\nthen\nend";
        this.addModelField("org.test.Person", "contact", "org.test.Contact", "Contact");
        this.addModelField("org.test.Contact", "telephone", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Person", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((String)"telephone", (String)ebLeftSide.getFieldName());
        Assert.assertEquals((String)"java.lang.Integer", (String)ebLeftSide.getFieldType());
        Assert.assertEquals((String)">", (String)ebLeftSide.getOperator());
        Assert.assertEquals((String)"12345", (String)ebLeftSide.getValue());
        Assert.assertEquals((int)3, (int)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getName());
        Assert.assertEquals((String)"org.test.Person", (String)expressionUnboundFact.getClassType());
        Assert.assertEquals((String)"Person", (String)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertEquals(null, (Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((String)"contact", (String)expressionField1.getName());
        Assert.assertEquals((String)"Contact", (String)expressionField1.getClassType());
        Assert.assertEquals((String)"Contact", (String)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((String)"telephone", (String)expressionField2.getName());
        Assert.assertEquals((String)"java.lang.Integer", (String)expressionField2.getClassType());
        Assert.assertEquals((String)"Integer", (String)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testNestedFieldConstraintsOnlyLeafOperator() {
        String drl = "rule \"rule1\"\nwhen\nParentType( parentChildField.childField == \"hello\" )\nthen\nend";
        this.addModelField("org.test.ParentType", "parentChildField", "org.test.ChildType", "ChildType");
        this.addModelField("org.test.ChildType", "childField", "java.lang.String", "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((String)"childField", (String)ebLeftSide.getFieldName());
        Assert.assertEquals((String)"java.lang.String", (String)ebLeftSide.getFieldType());
        Assert.assertEquals((String)"==", (String)ebLeftSide.getOperator());
        Assert.assertEquals((String)"hello", (String)ebLeftSide.getValue());
        Assert.assertEquals((int)3, (int)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((String)"ParentType", (String)expressionUnboundFact.getName());
        Assert.assertEquals((String)"org.test.ParentType", (String)expressionUnboundFact.getClassType());
        Assert.assertEquals((String)"ParentType", (String)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((String)"parentChildField", (String)expressionField1.getName());
        Assert.assertEquals((String)"ChildType", (String)expressionField1.getClassType());
        Assert.assertEquals((String)"ChildType", (String)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((String)"childField", (String)expressionField2.getName());
        Assert.assertEquals((String)"java.lang.String", (String)expressionField2.getClassType());
        Assert.assertEquals((String)"String", (String)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testReciprocal_NestedFieldConstraintsOnlyLeafOperator() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nParentType( this.parentChildField.childField == \"hello\" )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("ParentType");
        SingleFieldConstraint fp1_sfp1 = new SingleFieldConstraint();
        fp1_sfp1.setFactType("ParentType");
        fp1_sfp1.setFieldName("this");
        fp1_sfp1.setFieldType("this");
        fp1_sfp1.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp2 = new SingleFieldConstraint();
        fp1_sfp2.setFactType("ParentType");
        fp1_sfp2.setFieldName("parentChildField");
        fp1_sfp2.setFieldType("ChildType");
        fp1_sfp2.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp2);
        fp1_sfp2.setParent((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp3 = new SingleFieldConstraint();
        fp1_sfp3.setFactType("ChildType");
        fp1_sfp3.setFieldName("childField");
        fp1_sfp3.setFieldType("String");
        fp1_sfp3.setOperator("==");
        fp1_sfp3.setValue("hello");
        fp1_sfp3.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)fp1_sfp3);
        fp1_sfp3.setParent((FieldConstraint)fp1_sfp2);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testCalendarsAttribute() {
        String drl = "rule \"rule1\"\ncalendars \"myCalendar\", \"Yet Another Calendar\"\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertEquals((int)1, (int)m.attributes.length);
        Assert.assertEquals((String)"calendars", (String)m.attributes[0].getAttributeName());
        Assert.assertEquals((String)"myCalendar, Yet Another Calendar", (String)m.attributes[0].getValue());
    }

    @Test
    public void testFunctionCall() {
        String drl = "package org.mortgages;\nimport org.mortgages.LoanApplication;\n\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n  then\n    keke.clear(  );\nend\n";
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("keke", "java.util.ArrayList");
        Mockito.when((Object)this.dmo.getPackageGlobals()).thenReturn(globals);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod actionGlobalCollectionAdd = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((String)"clear", (String)actionGlobalCollectionAdd.getMethodName());
        Assert.assertEquals((String)"keke", (String)actionGlobalCollectionAdd.getVariable());
        Assert.assertEquals((int)1, (int)actionGlobalCollectionAdd.getState());
        Assert.assertEquals((int)0, (int)actionGlobalCollectionAdd.getFieldValues().length);
    }

    @Test
    public void testGlobalCollectionAdd() {
        String drl = "package org.mortgages;\n\nimport org.mortgages.LoanApplication;\n\nrule \"Bankruptcy history\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n  then\n    keke.add( a );\nend";
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("keke", "java.util.ArrayList");
        Mockito.when((Object)this.dmo.getPackageGlobals()).thenReturn(globals);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionGlobalCollectionAdd));
        ActionGlobalCollectionAdd actionGlobalCollectionAdd = (ActionGlobalCollectionAdd)m.rhs[0];
        Assert.assertEquals((String)"keke", (String)actionGlobalCollectionAdd.getGlobalName());
        Assert.assertEquals((String)"a", (String)actionGlobalCollectionAdd.getFactName());
    }

    @Test
    public void testFieldConstraintLessThanOrEqualTo() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age <= 22 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((String)"rule1", (String)m.name);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((String)"Applicant", (String)fp.getFactType());
        Assert.assertEquals((int)1, (int)fp.getNumberOfConstraints());
        FieldConstraint fc = fp.getConstraint(0);
        Assert.assertNotNull((Object)fc);
        Assert.assertTrue((boolean)(fc instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc = (SingleFieldConstraint)fc;
        Assert.assertEquals((String)"<=", (String)sfc.getOperator());
        Assert.assertEquals((String)"22", (String)sfc.getValue());
    }

    @Test
    public void testExpressionWithListSize() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    Company( emps.size() == 0 )\n  then\nend";
        this.addModelField("Company", "emps", "java.util.List", "List");
        this.addModelField("java.util.List", "size", "int", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertEquals((int)1, (int)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern factPattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((int)1, (int)factPattern.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(factPattern.getConstraintList().getConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide constraint = (SingleFieldConstraintEBLeftSide)factPattern.getConstraintList().getConstraints()[0];
        Assert.assertEquals((String)"size", (String)constraint.getFieldName());
        Assert.assertEquals((String)"int", (String)constraint.getFieldType());
        Assert.assertEquals((String)"0", (String)constraint.getValue());
        Assert.assertEquals((String)"==", (String)constraint.getOperator());
        Assert.assertEquals((int)1, (int)constraint.getConstraintValueType());
    }

    @Test
    public void testMVELInlineList() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    c : Company( )\n  then\n    c.setEmps( [\"item1\", \"item2\"] );\nend";
        this.addModelField("Company", "emps", "java.util.List", "List");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertEquals((int)1, (int)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionSetField));
        ActionSetField actionSetField = (ActionSetField)m.rhs[0];
        Assert.assertEquals((String)"c", (String)actionSetField.getVariable());
        Assert.assertEquals((int)1, (int)actionSetField.getFieldValues().length);
        ActionFieldValue actionFieldValue = actionSetField.getFieldValues()[0];
        Assert.assertEquals((String)"[\"item1\", \"item2\"]", (String)actionFieldValue.getValue());
        Assert.assertEquals((String)"emps", (String)actionFieldValue.getField());
        Assert.assertEquals((int)3, (int)actionFieldValue.getNature());
        Assert.assertEquals((String)"Collection", (String)actionFieldValue.getType());
    }

    @Test
    public void testFunctionInRHS() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    application : Application( )\n  then\n    application.setApr( application.getApr() + 5 );\n    update( application )end";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionUpdateField));
        ActionUpdateField field = (ActionUpdateField)m.rhs[0];
        Assert.assertTrue((boolean)(field.getFieldValues()[0] instanceof ActionFieldValue));
        ActionFieldValue value = field.getFieldValues()[0];
        Assert.assertEquals((String)"apr", (String)value.getField());
        Assert.assertEquals((String)"application.getApr() + 5", (String)value.getValue());
        Assert.assertEquals((int)3, (int)value.getNature());
        Assert.assertEquals((String)"Numeric", (String)value.getType());
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((String)cleanExpected, (String)cleanActual);
    }
}

