/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.commons.backend.rule.TestEnum;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionGlobalCollectionAdd;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.CEPWindow;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.DSLComplexVariableValue;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.DSLVariableValue;
import org.drools.workbench.models.datamodel.rule.ExpressionCollection;
import org.drools.workbench.models.datamodel.rule.ExpressionField;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionMethod;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionText;
import org.drools.workbench.models.datamodel.rule.ExpressionUnboundFact;
import org.drools.workbench.models.datamodel.rule.ExpressionVariable;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RuleModelDRLPersistenceUnmarshallingTest {
    private PackageDataModelOracle dmo;
    private Map<String, ModelField[]> packageModelFields = new HashMap<String, ModelField[]>();
    private Map<String, String[]> projectJavaEnumDefinitions = new HashMap<String, String[]>();
    private Map<String, List<MethodInfo>> projectMethodInformation = new HashMap<String, List<MethodInfo>>();

    @Before
    public void setUp() throws Exception {
        this.dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)this.dmo.getProjectModelFields()).thenReturn(this.packageModelFields);
        Mockito.when((Object)this.dmo.getProjectJavaEnumDefinitions()).thenReturn(this.projectJavaEnumDefinitions);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(this.projectMethodInformation);
    }

    @After
    public void cleanUp() throws Exception {
        this.packageModelFields.clear();
        this.projectJavaEnumDefinitions.clear();
        this.projectMethodInformation.clear();
    }

    private void addModelField(String factName, String fieldName, String clazz, String type) {
        ModelField[] modelFields = new ModelField[]{new ModelField(fieldName, clazz, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type)};
        if (this.packageModelFields.containsKey(factName)) {
            ArrayList<Object> existingModelFields = new ArrayList<Object>(Arrays.asList((Object[])this.packageModelFields.get(factName)));
            existingModelFields.add(modelFields[0]);
            modelFields = existingModelFields.toArray(modelFields);
        }
        this.packageModelFields.put(factName, modelFields);
    }

    private void addJavaEnumDefinition(String factName, String fieldName, String[] values) {
        String key = factName + "#" + fieldName;
        this.projectJavaEnumDefinitions.put(key, values);
    }

    private void addMethodInformation(String factName, String name, List<String> params, String returnType, String parametricReturnType, String genericType) {
        MethodInfo mi = new MethodInfo(name, params, returnType, parametricReturnType, genericType);
        List<MethodInfo> existingMethodInfo = this.projectMethodInformation.get(factName);
        if (existingMethodInfo == null) {
            existingMethodInfo = new ArrayList<MethodInfo>();
            this.projectMethodInformation.put(factName, existingMethodInfo);
        }
        existingMethodInfo.add(mi);
    }

    @Test
    public void testFactPattern() {
        String drl = "rule \"rule1\"\nwhen\nApplicant()\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)0L, (long)fp.getNumberOfConstraints());
    }

    @Test
    public void testFactPatternWithBinding() {
        String drl = "rule \"rule1\"\nwhen\n$a : Applicant()\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((Object)"$a", (Object)fp.getBoundName());
        Assert.assertEquals((long)0L, (long)fp.getNumberOfConstraints());
    }

    @Test
    public void testSingleFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age < 55 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"<", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"55", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintWithBinding() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( $a : age < 55 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"<", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"55", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((Object)"$a", (Object)sfp.getFieldBinding());
    }

    @Test
    public void testCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age < 55 || age > 70 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp = (CompositeFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"||", (Object)cfp.getCompositeJunctionType());
        Assert.assertEquals((long)2L, (long)cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)cfp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp1.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp1.getFieldName());
        Assert.assertEquals((Object)"<", (Object)sfp1.getOperator());
        Assert.assertEquals((Object)"55", (Object)sfp1.getValue());
        Assert.assertEquals((long)1L, (long)sfp1.getConstraintValueType());
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)cfp.getConstraint(1);
        Assert.assertEquals((Object)"Applicant", (Object)sfp2.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp2.getFieldName());
        Assert.assertEquals((Object)">", (Object)sfp2.getOperator());
        Assert.assertEquals((Object)"70", (Object)sfp2.getValue());
        Assert.assertEquals((long)1L, (long)sfp2.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintIsNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age == null )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"== null", (Object)sfp.getOperator());
        Assert.assertNull((Object)sfp.getValue());
        Assert.assertEquals((long)0L, (long)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintIsNotNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age != null )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"!= null", (Object)sfp.getOperator());
        Assert.assertNull((Object)sfp.getValue());
        Assert.assertEquals((long)0L, (long)sfp.getConstraintValueType());
    }

    @Test
    public void testCompositeFieldConstraintWithNotNullOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age != null && age > 70 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp = (CompositeFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"&&", (Object)cfp.getCompositeJunctionType());
        Assert.assertEquals((long)2L, (long)cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)cfp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp1.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp1.getFieldName());
        Assert.assertEquals((Object)"!= null", (Object)sfp1.getOperator());
        Assert.assertNull((Object)sfp1.getValue());
        Assert.assertEquals((long)0L, (long)sfp1.getConstraintValueType());
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)cfp.getConstraint(1);
        Assert.assertEquals((Object)"Applicant", (Object)sfp2.getFactType());
        Assert.assertEquals((Object)"age", (Object)sfp2.getFieldName());
        Assert.assertEquals((Object)">", (Object)sfp2.getOperator());
        Assert.assertEquals((Object)"70", (Object)sfp2.getValue());
        Assert.assertEquals((long)1L, (long)sfp2.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintCEPOperator() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( dob after \"26-Jun-2013\" )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"dob", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"after", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"26-Jun-2013", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
    }

    @Test
    public void testSingleFieldConstraintCEPOperator1Parameter() {
        String drl = "rule \"rule1\"\nwhen\n$e : Event()\nEvent( this after[1d] $e )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((Object)"Event", (Object)fp1.getFactType());
        Assert.assertEquals((Object)"$e", (Object)fp1.getBoundName());
        Assert.assertEquals((long)0L, (long)fp1.getNumberOfConstraints());
        IPattern p2 = m.lhs[1];
        Assert.assertTrue((boolean)(p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)p2;
        Assert.assertEquals((Object)"Event", (Object)fp2.getFactType());
        Assert.assertNull((Object)fp2.getBoundName());
        Assert.assertEquals((long)1L, (long)fp2.getNumberOfConstraints());
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((Object)"Event", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"this", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"after", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"$e", (Object)sfp.getValue());
        Assert.assertEquals((long)2L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((long)3L, (long)sfp.getParameters().size());
        Assert.assertEquals((Object)"1d", (Object)sfp.getParameter("0"));
        Assert.assertEquals((Object)"1", (Object)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.visibleParameterSet"));
        Assert.assertEquals((Object)"org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder", (Object)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperator1Parameter() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n$e : Event()\nEvent( this after[1d] $e )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        fp1.setBoundName("$e");
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Event");
        SingleFieldConstraint sfp = new SingleFieldConstraint();
        sfp.setFactType("Event");
        sfp.setFieldName("this");
        sfp.setOperator("after");
        sfp.setValue("$e");
        sfp.setConstraintValueType(2);
        sfp.getParameters().put("0", "1d");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.visibleParameterSet", "1");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder");
        fp2.addConstraint((FieldConstraint)sfp);
        m.addLhsItem((IPattern)fp1);
        m.addLhsItem((IPattern)fp2);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testSingleFieldConstraintCEPOperator2Parameters() {
        String drl = "rule \"rule1\"\nwhen\n$e : Event()\nEvent( this after[1d, 2d] $e )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((Object)"Event", (Object)fp1.getFactType());
        Assert.assertEquals((Object)"$e", (Object)fp1.getBoundName());
        Assert.assertEquals((long)0L, (long)fp1.getNumberOfConstraints());
        IPattern p2 = m.lhs[1];
        Assert.assertTrue((boolean)(p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)p2;
        Assert.assertEquals((Object)"Event", (Object)fp2.getFactType());
        Assert.assertNull((Object)fp2.getBoundName());
        Assert.assertEquals((long)1L, (long)fp2.getNumberOfConstraints());
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((Object)"Event", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"this", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"after", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"$e", (Object)sfp.getValue());
        Assert.assertEquals((long)2L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((long)4L, (long)sfp.getParameters().size());
        Assert.assertEquals((Object)"1d", (Object)sfp.getParameter("0"));
        Assert.assertEquals((Object)"2d", (Object)sfp.getParameter("1"));
        Assert.assertEquals((Object)"2", (Object)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.visibleParameterSet"));
        Assert.assertEquals((Object)"org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder", (Object)sfp.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperator2Parameters() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n$e : Event()\nEvent( this after[1d, 2d] $e )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        fp1.setBoundName("$e");
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Event");
        SingleFieldConstraint sfp = new SingleFieldConstraint();
        sfp.setFactType("Event");
        sfp.setFieldName("this");
        sfp.setOperator("after");
        sfp.setValue("$e");
        sfp.setConstraintValueType(2);
        sfp.getParameters().put("0", "1d");
        sfp.getParameters().put("1", "2d");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.visibleParameterSet", "2");
        sfp.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPOperatorParameterDRLBuilder");
        fp2.addConstraint((FieldConstraint)sfp);
        m.addLhsItem((IPattern)fp1);
        m.addLhsItem((IPattern)fp2);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testSingleFieldConstraintCEPOperatorTimeWindow() {
        String drl = "rule \"rule1\"\nwhen\nEvent() over window:time (1d)\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((Object)"Event", (Object)fp1.getFactType());
        Assert.assertNull((Object)fp1.getBoundName());
        Assert.assertEquals((long)0L, (long)fp1.getNumberOfConstraints());
        Assert.assertNotNull((Object)fp1.getWindow());
        CEPWindow window = fp1.getWindow();
        Assert.assertEquals((Object)"over window:time", (Object)window.getOperator());
        Assert.assertEquals((long)2L, (long)window.getParameters().size());
        Assert.assertEquals((Object)"1d", (Object)window.getParameter("1"));
        Assert.assertEquals((Object)"org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder", (Object)window.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperatorTimeWindow() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nEvent() over window:time (1d)\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        CEPWindow window = new CEPWindow();
        window.setOperator("over window:time");
        window.getParameters().put("1", "1d");
        window.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder");
        fp1.setWindow(window);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testSingleFieldConstraintCEPOperatorTimeLength() {
        String drl = "rule \"rule1\"\nwhen\nEvent() over window:length (10)\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p1 = m.lhs[0];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((Object)"Event", (Object)fp1.getFactType());
        Assert.assertNull((Object)fp1.getBoundName());
        Assert.assertEquals((long)0L, (long)fp1.getNumberOfConstraints());
        Assert.assertNotNull((Object)fp1.getWindow());
        CEPWindow window = fp1.getWindow();
        Assert.assertEquals((Object)"over window:length", (Object)window.getOperator());
        Assert.assertEquals((long)2L, (long)window.getParameters().size());
        Assert.assertEquals((Object)"10", (Object)window.getParameter("1"));
        Assert.assertEquals((Object)"org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder", (Object)window.getParameter("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator"));
    }

    @Test
    public void testReciprocal_SingleFieldConstraintCEPOperatorTimeLength() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nEvent() over window:length (10)\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Event");
        CEPWindow window = new CEPWindow();
        window.setOperator("over window:length");
        window.getParameters().put("1", "10");
        window.getParameters().put("org.drools.workbench.models.commons.backend.rule.operatorParameterGenerator", "org.drools.workbench.models.commons.backend.rule.CEPWindowOperatorParameterDRLBuilder");
        fp1.setWindow(window);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testExtends() {
        String drl = "rule \"rule1\" extends \"rule2\" \nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((Object)"rule2", (Object)m.parentName);
    }

    @Test
    public void testRuleNameWithoutTheQuotes() {
        String drl = "rule rule1\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
    }

    @Test
    public void testMetaData() {
        String drl = "rule rule1\n@author( Bob )\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.metadataList.length);
        Assert.assertEquals((Object)"author", (Object)m.metadataList[0].getAttributeName());
        Assert.assertEquals((Object)"Bob", (Object)m.metadataList[0].getValue());
    }

    @Test
    public void testAttributes() {
        String drl = "rule rule1\nsalience 42\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.attributes.length);
        Assert.assertEquals((Object)"salience", (Object)m.attributes[0].getAttributeName());
        Assert.assertEquals((Object)"42", (Object)m.attributes[0].getValue());
    }

    @Test
    public void testEval() {
        String drl = "rule rule1\nwhen\neval( true )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FreeFormLine));
        Assert.assertEquals((Object)"eval( true )", (Object)((FreeFormLine)m.lhs[0]).getText());
    }

    @Test
    public void testLHSFreeFormLine() {
        String drl = "rule rule1\nwhen\n//A comment\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FreeFormLine));
        Assert.assertEquals((Object)"//A comment", (Object)((FreeFormLine)m.lhs[0]).getText());
    }

    @Test
    public void testRHSFreeFormLine() {
        String drl = "rule rule1\nwhen\nthen\nint test = (int)(1-0.8);\nSystem.out.println( \"Hello Mario!\" );\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof FreeFormLine));
        Assert.assertEquals((Object)"int test = (int)(1-0.8);", (Object)((FreeFormLine)m.rhs[0]).getText());
        Assert.assertTrue((boolean)(m.rhs[1] instanceof FreeFormLine));
        Assert.assertEquals((Object)"System.out.println( \"Hello Mario!\" );", (Object)((FreeFormLine)m.rhs[1]).getText());
    }

    @Test
    public void testLHSFreeFormLineWithDsl() {
        String drl = "rule rule1\nwhen\n>//A comment\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, Collections.EMPTY_LIST, this.dmo, new String[0]);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FreeFormLine));
        Assert.assertEquals((Object)"//A comment", (Object)((FreeFormLine)m.lhs[0]).getText());
    }

    @Test
    public void testRHSFreeFormLineWithDsl() {
        String drl = "rule rule1\nwhen\nthen\n>int test = (int)(1-0.8);\n>System.out.println( \"Hello Mario!\" );\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, Collections.EMPTY_LIST, this.dmo, new String[0]);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof FreeFormLine));
        Assert.assertEquals((Object)"int test = (int)(1-0.8);", (Object)((FreeFormLine)m.rhs[0]).getText());
        Assert.assertTrue((boolean)(m.rhs[1] instanceof FreeFormLine));
        Assert.assertEquals((Object)"System.out.println( \"Hello Mario!\" );", (Object)((FreeFormLine)m.rhs[1]).getText());
    }

    @Test
    public void testVarAssignment() {
        String drl = "rule rule1\nwhen\n d : Double()\nthen\ndouble test = d.doubleValue();\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof FreeFormLine));
        Assert.assertEquals((Object)"double test = d.doubleValue();", (Object)((FreeFormLine)m.rhs[0]).getText());
    }

    @Test
    public void testRHSOrder() {
        String drl = "rule \"Low Down Payment based on Appraisal\"\n  dialect \"mvel\"\n  ruleflow-group \"apr-calculation\"\n  salience -3\n  no-loop true\n when\n    appraised : Appraisal( )\n    application : Application( mortgageAmount > ( appraised.value * 8 / 10 ) )\n then\n    double ratio = application.getMortgageAmount().doubleValue() / appraised.getValue().doubleValue();\n    int brackets = (int)((ratio - 0.8) / 0.05);\n    brackets++;\n    double aprSurcharge = 0.75 * brackets;\n    System.out.println( \"aprSurcharge added is \" + aprSurcharge );\n    application.setApr(  application.getApr() + aprSurcharge );\n    System.out.println(\"Executed Rule: \" + drools.getRule().getName() );\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)7L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof FreeFormLine));
        Assert.assertTrue((boolean)(m.rhs[1] instanceof FreeFormLine));
        Assert.assertTrue((boolean)(m.rhs[2] instanceof FreeFormLine));
        Assert.assertTrue((boolean)(m.rhs[3] instanceof FreeFormLine));
        Assert.assertTrue((boolean)(m.rhs[4] instanceof FreeFormLine));
        Assert.assertTrue((boolean)(m.rhs[5] instanceof ActionSetField));
        Assert.assertTrue((boolean)(m.rhs[6] instanceof FreeFormLine));
    }

    @Test
    public void testNestedFieldExpressions() {
        String drl = "rule rule1\nwhen\nPerson( address.postalCode == 12345 )\nthen\nend";
        this.addModelField("org.test.Person", "address", "org.test.Address", "Address");
        this.addModelField("org.test.Address", "postalCode", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((Object)"postalCode", (Object)ebLeftSide.getFieldName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ebLeftSide.getFieldType());
        Assert.assertEquals((Object)"==", (Object)ebLeftSide.getOperator());
        Assert.assertEquals((Object)"12345", (Object)ebLeftSide.getValue());
        Assert.assertEquals((long)3L, (long)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getName());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getClassType());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"address", (Object)expressionField1.getName());
        Assert.assertEquals((Object)"org.test.Address", (Object)expressionField1.getClassType());
        Assert.assertEquals((Object)"Address", (Object)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"postalCode", (Object)expressionField2.getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)expressionField2.getClassType());
        Assert.assertEquals((Object)"Integer", (Object)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testNestedFieldExpressionsWithAFunction() {
        String drl = "rule rule1\nwhen\nPerson( address.postalCode == myFunction() )\nthen\nend";
        this.addModelField("org.test.Person", "address", "org.test.Address", "Address");
        this.addModelField("org.test.Address", "postalCode", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((Object)"postalCode", (Object)ebLeftSide.getFieldName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ebLeftSide.getFieldType());
        Assert.assertEquals((Object)"==", (Object)ebLeftSide.getOperator());
        Assert.assertEquals((Object)"myFunction()", (Object)ebLeftSide.getValue());
        Assert.assertEquals((long)3L, (long)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getName());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getClassType());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"address", (Object)expressionField1.getName());
        Assert.assertEquals((Object)"org.test.Address", (Object)expressionField1.getClassType());
        Assert.assertEquals((Object)"Address", (Object)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"postalCode", (Object)expressionField2.getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)expressionField2.getClassType());
        Assert.assertEquals((Object)"Integer", (Object)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testNestedFieldExpressionsWithAnotherExpression() {
        String drl = "rule rule1\nwhen\np : Person( address.postalCode == p.address.postalCode) )\nthen\nend";
        this.addModelField("org.test.Person", "address", "org.test.Address", "Address");
        this.addModelField("org.test.Person", "this", "org.test.Person", "this");
        this.addModelField("org.test.Address", "postalCode", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((Object)"postalCode", (Object)ebLeftSide.getFieldName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ebLeftSide.getFieldType());
        Assert.assertEquals((Object)"==", (Object)ebLeftSide.getOperator());
        Assert.assertEquals((Object)"", (Object)ebLeftSide.getValue());
        Assert.assertEquals((long)3L, (long)ebLeftSide.getExpressionValue().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionValue().getParts().get(0) instanceof ExpressionVariable));
        ExpressionVariable expressionVariable = (ExpressionVariable)ebLeftSide.getExpressionValue().getParts().get(0);
        Assert.assertEquals((Object)"p", (Object)expressionVariable.getName());
        Assert.assertEquals((Object)"org.test.Person", (Object)expressionVariable.getClassType());
        Assert.assertEquals((Object)"this", (Object)expressionVariable.getGenericType());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionValue().getParts().get(1) instanceof ExpressionField));
        ExpressionField ef1 = (ExpressionField)ebLeftSide.getExpressionValue().getParts().get(1);
        Assert.assertEquals((Object)"address", (Object)ef1.getName());
        Assert.assertEquals((Object)"org.test.Address", (Object)ef1.getClassType());
        Assert.assertEquals((Object)"Address", (Object)ef1.getGenericType());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionValue().getParts().get(2) instanceof ExpressionField));
        ExpressionField ef2 = (ExpressionField)ebLeftSide.getExpressionValue().getParts().get(2);
        Assert.assertEquals((Object)"postalCode", (Object)ef2.getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ef2.getClassType());
        Assert.assertEquals((Object)"Integer", (Object)ef2.getGenericType());
        Assert.assertEquals((long)3L, (long)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getName());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getClassType());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"address", (Object)expressionField1.getName());
        Assert.assertEquals((Object)"org.test.Address", (Object)expressionField1.getClassType());
        Assert.assertEquals((Object)"Address", (Object)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"postalCode", (Object)expressionField2.getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)expressionField2.getClassType());
        Assert.assertEquals((Object)"Integer", (Object)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testSingleFieldConstraintContainsOperator() {
        String drl = "rule \"rule1\"\nwhen\n$is : IncomeSource( )\nApplicant( incomes contains $is )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        IPattern p0 = m.lhs[0];
        Assert.assertTrue((boolean)(p0 instanceof FactPattern));
        FactPattern fp0 = (FactPattern)p0;
        Assert.assertEquals((Object)"IncomeSource", (Object)fp0.getFactType());
        Assert.assertEquals((Object)"$is", (Object)fp0.getBoundName());
        IPattern p1 = m.lhs[1];
        Assert.assertTrue((boolean)(p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)p1;
        Assert.assertEquals((Object)"Applicant", (Object)fp1.getFactType());
        Assert.assertEquals((long)0L, (long)fp0.getNumberOfConstraints());
        Assert.assertEquals((long)1L, (long)fp1.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((Object)"Applicant", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"incomes", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"contains", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"$is", (Object)sfp.getValue());
        Assert.assertEquals((long)2L, (long)sfp.getConstraintValueType());
    }

    @Test
    public void testCompositeFactPatternWithOr() {
        String drl = "rule \"rule1\"\nwhen\n( Person( age == 42 ) or Person( age == 43 ) )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof CompositeFactPattern));
        CompositeFactPattern cfp = (CompositeFactPattern)p;
        Assert.assertEquals((Object)"or", (Object)cfp.getType());
        Assert.assertEquals((long)2L, (long)cfp.getPatterns().length);
        IFactPattern cfp_p1 = cfp.getPatterns()[0];
        Assert.assertTrue((boolean)(cfp_p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)cfp_p1;
        Assert.assertEquals((Object)"Person", (Object)fp1.getFactType());
        Assert.assertEquals((long)1L, (long)fp1.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_sfp1 = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)cfp_sfp1.getFactType());
        Assert.assertEquals((Object)"age", (Object)cfp_sfp1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cfp_sfp1.getOperator());
        Assert.assertEquals((Object)"42", (Object)cfp_sfp1.getValue());
        Assert.assertEquals((long)1L, (long)cfp_sfp1.getConstraintValueType());
        IFactPattern cfp_p2 = cfp.getPatterns()[1];
        Assert.assertTrue((boolean)(cfp_p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)cfp_p2;
        Assert.assertEquals((Object)"Person", (Object)fp2.getFactType());
        Assert.assertTrue((boolean)(fp2.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_sfp2 = (SingleFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)cfp_sfp2.getFactType());
        Assert.assertEquals((Object)"age", (Object)cfp_sfp2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cfp_sfp2.getOperator());
        Assert.assertEquals((Object)"43", (Object)cfp_sfp2.getValue());
        Assert.assertEquals((long)1L, (long)cfp_sfp2.getConstraintValueType());
    }

    @Test
    public void testReciprocal_CompositeFactPatternWithOr() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n( Person( age == 42 ) or Person( age == 43 ) )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        CompositeFactPattern cfp = new CompositeFactPattern();
        cfp.setType("or");
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Person");
        SingleFieldConstraint cfp_sfp1 = new SingleFieldConstraint();
        cfp_sfp1.setFactType("Person");
        cfp_sfp1.setFieldName("age");
        cfp_sfp1.setOperator("==");
        cfp_sfp1.setValue("42");
        cfp_sfp1.setFieldType("Integer");
        cfp_sfp1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)cfp_sfp1);
        cfp.addFactPattern((IFactPattern)fp1);
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Person");
        SingleFieldConstraint cfp_sfp2 = new SingleFieldConstraint();
        cfp_sfp2.setFactType("Person");
        cfp_sfp2.setFieldName("age");
        cfp_sfp2.setOperator("==");
        cfp_sfp2.setValue("43");
        cfp_sfp2.setFieldType("Integer");
        cfp_sfp2.setConstraintValueType(1);
        fp2.addConstraint((FieldConstraint)cfp_sfp2);
        cfp.addFactPattern((IFactPattern)fp2);
        m.addLhsItem((IPattern)cfp);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testCompositeFactPatternWithOrAndCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\nwhen\n( Person( age == 42 ) or Person( age == 43 || age == 44) )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof CompositeFactPattern));
        CompositeFactPattern cfp = (CompositeFactPattern)p;
        Assert.assertEquals((Object)"or", (Object)cfp.getType());
        Assert.assertEquals((long)2L, (long)cfp.getPatterns().length);
        IFactPattern cfp_p1 = cfp.getPatterns()[0];
        Assert.assertTrue((boolean)(cfp_p1 instanceof FactPattern));
        FactPattern fp1 = (FactPattern)cfp_p1;
        Assert.assertEquals((Object)"Person", (Object)fp1.getFactType());
        Assert.assertEquals((long)1L, (long)fp1.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp1.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_sfp1 = (SingleFieldConstraint)fp1.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)cfp_sfp1.getFactType());
        Assert.assertEquals((Object)"age", (Object)cfp_sfp1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cfp_sfp1.getOperator());
        Assert.assertEquals((Object)"42", (Object)cfp_sfp1.getValue());
        Assert.assertEquals((long)1L, (long)cfp_sfp1.getConstraintValueType());
        IFactPattern cfp_p2 = cfp.getPatterns()[1];
        Assert.assertTrue((boolean)(cfp_p2 instanceof FactPattern));
        FactPattern fp2 = (FactPattern)cfp_p2;
        Assert.assertEquals((long)1L, (long)fp2.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp2.getConstraint(0) instanceof CompositeFieldConstraint));
        CompositeFieldConstraint cfp_p2_cfp = (CompositeFieldConstraint)fp2.getConstraint(0);
        Assert.assertEquals((Object)"||", (Object)cfp_p2_cfp.getCompositeJunctionType());
        Assert.assertEquals((long)2L, (long)cfp_p2_cfp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(cfp_p2_cfp.getConstraint(0) instanceof SingleFieldConstraint));
        Assert.assertTrue((boolean)(cfp_p2_cfp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint cfp_p2_sfp1 = (SingleFieldConstraint)cfp_p2_cfp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)cfp_p2_sfp1.getFactType());
        Assert.assertEquals((Object)"age", (Object)cfp_p2_sfp1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cfp_p2_sfp1.getOperator());
        Assert.assertEquals((Object)"43", (Object)cfp_p2_sfp1.getValue());
        Assert.assertEquals((long)1L, (long)cfp_p2_sfp1.getConstraintValueType());
        SingleFieldConstraint cfp_p2_sfp2 = (SingleFieldConstraint)cfp_p2_cfp.getConstraint(1);
        Assert.assertEquals((Object)"Person", (Object)cfp_p2_sfp2.getFactType());
        Assert.assertEquals((Object)"age", (Object)cfp_p2_sfp2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cfp_p2_sfp2.getOperator());
        Assert.assertEquals((Object)"44", (Object)cfp_p2_sfp2.getValue());
        Assert.assertEquals((long)1L, (long)cfp_p2_sfp2.getConstraintValueType());
    }

    @Test
    public void testReciprocal_CompositeFactPatternWithOrAndCompositeFieldConstraint() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\n( Person( age == 42 ) or Person( age == 43 || age == 44) )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        CompositeFactPattern cfp = new CompositeFactPattern();
        cfp.setType("or");
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Person");
        SingleFieldConstraint fp1_sfp1 = new SingleFieldConstraint();
        fp1_sfp1.setFactType("Person");
        fp1_sfp1.setFieldName("age");
        fp1_sfp1.setOperator("==");
        fp1_sfp1.setValue("42");
        fp1_sfp1.setFieldType("Integer");
        fp1_sfp1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)fp1_sfp1);
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Person");
        CompositeFieldConstraint fp2_cfp = new CompositeFieldConstraint();
        fp2_cfp.setCompositeJunctionType("||");
        fp2.addConstraint((FieldConstraint)fp2_cfp);
        SingleFieldConstraint fp2_sfp1 = new SingleFieldConstraint();
        fp2_sfp1.setFactType("Person");
        fp2_sfp1.setFieldName("age");
        fp2_sfp1.setOperator("==");
        fp2_sfp1.setValue("43");
        fp2_sfp1.setFieldType("Integer");
        fp2_sfp1.setConstraintValueType(1);
        fp2_cfp.addConstraint((FieldConstraint)fp2_sfp1);
        SingleFieldConstraint fp2_sfp2 = new SingleFieldConstraint();
        fp2_sfp2.setFactType("Person");
        fp2_sfp2.setFieldName("age");
        fp2_sfp2.setOperator("==");
        fp2_sfp2.setValue("44");
        fp2_sfp2.setFieldType("Integer");
        fp2_sfp2.setConstraintValueType(1);
        fp2_cfp.addConstraint((FieldConstraint)fp2_sfp2);
        cfp.addFactPattern((IFactPattern)fp1);
        cfp.addFactPattern((IFactPattern)fp2);
        m.addLhsItem((IPattern)cfp);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testNestedFieldConstraints() {
        String drl = "rule \"rule1\"\nwhen\nParentType( this != null, this.parentChildField != null, this.parentChildField.childField == \"hello\" )\nthen\nend";
        this.addModelField("org.test.ParentType", "parentChildField", "org.test.ChildType", "ChildType");
        this.addModelField("org.test.ChildType", "childField", "java.lang.String", "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"ParentType", (Object)fp.getFactType());
        Assert.assertEquals((long)3L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp0 = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"ParentType", (Object)sfp0.getFactType());
        Assert.assertEquals((Object)"this", (Object)sfp0.getFieldName());
        Assert.assertEquals((Object)"this", (Object)sfp0.getFieldType());
        Assert.assertEquals((Object)"!= null", (Object)sfp0.getOperator());
        Assert.assertNull((Object)sfp0.getValue());
        Assert.assertEquals((long)0L, (long)sfp0.getConstraintValueType());
        Assert.assertNull((Object)sfp0.getParent());
        Assert.assertTrue((boolean)(fp.getConstraint(1) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp1 = (SingleFieldConstraint)fp.getConstraint(1);
        Assert.assertEquals((Object)"ParentType", (Object)sfp1.getFactType());
        Assert.assertEquals((Object)"parentChildField", (Object)sfp1.getFieldName());
        Assert.assertEquals((Object)"org.test.ChildType", (Object)sfp1.getFieldType());
        Assert.assertEquals((Object)"!= null", (Object)sfp1.getOperator());
        Assert.assertNull((Object)sfp1.getValue());
        Assert.assertEquals((long)0L, (long)sfp1.getConstraintValueType());
        Assert.assertSame((Object)sfp0, (Object)sfp1.getParent());
        Assert.assertTrue((boolean)(fp.getConstraint(2) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp2 = (SingleFieldConstraint)fp.getConstraint(2);
        Assert.assertEquals((Object)"childField", (Object)sfp2.getFieldName());
        Assert.assertEquals((Object)"java.lang.String", (Object)sfp2.getFieldType());
        Assert.assertEquals((Object)"==", (Object)sfp2.getOperator());
        Assert.assertEquals((Object)"hello", (Object)sfp2.getValue());
        Assert.assertEquals((long)1L, (long)sfp2.getConstraintValueType());
        Assert.assertSame((Object)sfp1, (Object)sfp2.getParent());
    }

    @Test
    public void testReciprocal_NestedFieldConstraints() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nParentType( this != null, this.parentChildField != null, this.parentChildField.childField == \"hello\" )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("ParentType");
        SingleFieldConstraint fp1_sfp1 = new SingleFieldConstraint();
        fp1_sfp1.setFactType("ParentType");
        fp1_sfp1.setFieldName("this");
        fp1_sfp1.setFieldType("this");
        fp1_sfp1.setOperator("!= null");
        fp1_sfp1.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp2 = new SingleFieldConstraint();
        fp1_sfp2.setFactType("ParentType");
        fp1_sfp2.setFieldName("parentChildField");
        fp1_sfp2.setFieldType("ChildType");
        fp1_sfp2.setOperator("!= null");
        fp1_sfp2.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp2);
        fp1_sfp2.setParent((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp3 = new SingleFieldConstraint();
        fp1_sfp3.setFactType("ChildType");
        fp1_sfp3.setFieldName("childField");
        fp1_sfp3.setFieldType("String");
        fp1_sfp3.setOperator("==");
        fp1_sfp3.setValue("hello");
        fp1_sfp3.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)fp1_sfp3);
        fp1_sfp3.setParent((FieldConstraint)fp1_sfp2);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testNestedFieldConstraintsAsExpression() {
        String drl = "rule \"rule1\"\nwhen\nPerson( contact.telephone > 12345 )\nthen\nend";
        this.addModelField("org.test.Person", "contact", "org.test.Contact", "Contact");
        this.addModelField("org.test.Contact", "telephone", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((Object)"telephone", (Object)ebLeftSide.getFieldName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ebLeftSide.getFieldType());
        Assert.assertEquals((Object)">", (Object)ebLeftSide.getOperator());
        Assert.assertEquals((Object)"12345", (Object)ebLeftSide.getValue());
        Assert.assertEquals((long)3L, (long)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getName());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getClassType());
        Assert.assertEquals((Object)"Person", (Object)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertEquals(null, (Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"contact", (Object)expressionField1.getName());
        Assert.assertEquals((Object)"org.test.Contact", (Object)expressionField1.getClassType());
        Assert.assertEquals((Object)"Contact", (Object)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"telephone", (Object)expressionField2.getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)expressionField2.getClassType());
        Assert.assertEquals((Object)"Integer", (Object)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testNestedFieldConstraintsOnlyLeafOperator() {
        String drl = "rule \"rule1\"\nwhen\nParentType( parentChildField.childField == \"hello\" )\nthen\nend";
        this.addModelField("org.test.ParentType", "parentChildField", "org.test.ChildType", "ChildType");
        this.addModelField("org.test.ChildType", "childField", "java.lang.String", "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        Assert.assertTrue((boolean)(((FactPattern)m.lhs[0]).getFieldConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide ebLeftSide = (SingleFieldConstraintEBLeftSide)((FactPattern)m.lhs[0]).getFieldConstraints()[0];
        Assert.assertEquals((Object)"childField", (Object)ebLeftSide.getFieldName());
        Assert.assertEquals((Object)"java.lang.String", (Object)ebLeftSide.getFieldType());
        Assert.assertEquals((Object)"==", (Object)ebLeftSide.getOperator());
        Assert.assertEquals((Object)"hello", (Object)ebLeftSide.getValue());
        Assert.assertEquals((long)3L, (long)ebLeftSide.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact expressionUnboundFact = (ExpressionUnboundFact)ebLeftSide.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"ParentType", (Object)expressionUnboundFact.getName());
        Assert.assertEquals((Object)"ParentType", (Object)expressionUnboundFact.getClassType());
        Assert.assertEquals((Object)"ParentType", (Object)expressionUnboundFact.getGenericType());
        Assert.assertEquals((Object)m.lhs[0], (Object)expressionUnboundFact.getFact());
        Assert.assertNull((Object)expressionUnboundFact.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionUnboundFact.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField1 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"parentChildField", (Object)expressionField1.getName());
        Assert.assertEquals((Object)"org.test.ChildType", (Object)expressionField1.getClassType());
        Assert.assertEquals((Object)"ChildType", (Object)expressionField1.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(0), (Object)expressionField1.getPrevious());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(2), (Object)expressionField1.getNext());
        Assert.assertTrue((boolean)(ebLeftSide.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField expressionField2 = (ExpressionField)ebLeftSide.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"childField", (Object)expressionField2.getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)expressionField2.getClassType());
        Assert.assertEquals((Object)"String", (Object)expressionField2.getGenericType());
        Assert.assertEquals(ebLeftSide.getExpressionLeftSide().getParts().get(1), (Object)expressionField2.getPrevious());
        Assert.assertNull((Object)expressionField2.getNext());
    }

    @Test
    public void testReciprocal_NestedFieldConstraintsOnlyLeafOperator() {
        String drl = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nParentType( this.parentChildField.childField == \"hello\" )\nthen\nend";
        RuleModel m = new RuleModel();
        m.name = "rule1";
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("ParentType");
        SingleFieldConstraint fp1_sfp1 = new SingleFieldConstraint();
        fp1_sfp1.setFactType("ParentType");
        fp1_sfp1.setFieldName("this");
        fp1_sfp1.setFieldType("this");
        fp1_sfp1.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp2 = new SingleFieldConstraint();
        fp1_sfp2.setFactType("ParentType");
        fp1_sfp2.setFieldName("parentChildField");
        fp1_sfp2.setFieldType("ChildType");
        fp1_sfp2.setConstraintValueType(0);
        fp1.addConstraint((FieldConstraint)fp1_sfp2);
        fp1_sfp2.setParent((FieldConstraint)fp1_sfp1);
        SingleFieldConstraint fp1_sfp3 = new SingleFieldConstraint();
        fp1_sfp3.setFactType("ChildType");
        fp1_sfp3.setFieldName("childField");
        fp1_sfp3.setFieldType("String");
        fp1_sfp3.setOperator("==");
        fp1_sfp3.setValue("hello");
        fp1_sfp3.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)fp1_sfp3);
        fp1_sfp3.setParent((FieldConstraint)fp1_sfp2);
        m.addLhsItem((IPattern)fp1);
        String actualDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, actualDrl);
    }

    @Test
    public void testCalendarsAttribute() {
        String drl = "rule \"rule1\"\ncalendars \"myCalendar\", \"Yet Another Calendar\"\nwhen\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertEquals((long)1L, (long)m.attributes.length);
        Assert.assertEquals((Object)"calendars", (Object)m.attributes[0].getAttributeName());
        Assert.assertEquals((Object)"myCalendar, Yet Another Calendar", (Object)m.attributes[0].getValue());
    }

    @Test
    public void testFunctionCall() {
        String drl = "package org.mortgages;\nimport org.mortgages.LoanApplication;\n\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n  then\n    keke.clear(  );\nend\n";
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("keke", "java.util.ArrayList");
        Mockito.when((Object)this.dmo.getPackageGlobals()).thenReturn(globals);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod actionGlobalCollectionAdd = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"clear", (Object)actionGlobalCollectionAdd.getMethodName());
        Assert.assertEquals((Object)"keke", (Object)actionGlobalCollectionAdd.getVariable());
        Assert.assertEquals((long)1L, (long)actionGlobalCollectionAdd.getState());
        Assert.assertEquals((long)0L, (long)actionGlobalCollectionAdd.getFieldValues().length);
    }

    @Test
    public void testMethodCall() {
        String drl = "package org.mortgages;\nimport org.mortgages.LoanApplication;\nimport java.util.Map;\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n    m : Map()\n  then\n    m.put(\"key\", a );\nend\n";
        HashMap globals = new HashMap();
        Mockito.when((Object)this.dmo.getPackageGlobals()).thenReturn(globals);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertEquals((long)2L, (long)m.getImports().getImports().size());
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod mc = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"put", (Object)mc.getMethodName());
        Assert.assertEquals((Object)"m", (Object)mc.getVariable());
        Assert.assertEquals((long)1L, (long)mc.getState());
        Assert.assertEquals((long)2L, (long)mc.getFieldValues().length);
        ActionFieldFunction f1 = mc.getFieldValue(0);
        Assert.assertEquals((Object)"key", (Object)f1.getValue());
        ActionFieldFunction f2 = mc.getFieldValue(1);
        Assert.assertEquals((Object)"a", (Object)f2.getValue());
        String marshalled = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        System.out.println(marshalled);
        this.assertEqualsIgnoreWhitespace(drl, marshalled);
    }

    @Test
    public void testMethodCallCheckParameterDataTypes1() {
        String drl = "package org.mortgages;\nimport org.mortgages.LoanApplication;\nimport java.util.Map;\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n    m : Map()\n  then\n    m.put(\"key\", a );\nend\n";
        HashMap methodInformation = new HashMap();
        ArrayList<MethodInfo> mapMethodInformation = new ArrayList<MethodInfo>();
        mapMethodInformation.add(new MethodInfo("put", Arrays.asList("java.lang.Object", "java.lang.Object"), "void", "void", "java.util.Map"));
        methodInformation.put("java.util.Map", mapMethodInformation);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(methodInformation);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod mc = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"put", (Object)mc.getMethodName());
        Assert.assertEquals((Object)"m", (Object)mc.getVariable());
        Assert.assertEquals((long)1L, (long)mc.getState());
        Assert.assertEquals((long)2L, (long)mc.getFieldValues().length);
        ActionFieldFunction f1 = mc.getFieldValue(0);
        Assert.assertEquals((Object)"\"key\"", (Object)f1.getValue());
        Assert.assertEquals((Object)"java.lang.Object", (Object)f1.getType());
        Assert.assertEquals((long)1L, (long)f1.getNature());
        ActionFieldFunction f2 = mc.getFieldValue(1);
        Assert.assertEquals((Object)"a", (Object)f2.getValue());
        Assert.assertEquals((Object)"java.lang.Object", (Object)f2.getType());
        Assert.assertEquals((long)2L, (long)f2.getNature());
        String marshalled = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        System.out.println(marshalled);
        this.assertEqualsIgnoreWhitespace(drl, marshalled);
    }

    @Test
    public void testMethodCallCheckParameterDataTypes2() {
        String drl = "package org.mortgages;\nimport org.mortgages.MyType;\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    t : MyType( )\n  then\n    t.doSomething( 1 * 2 );\nend\n";
        HashMap methodInformation = new HashMap();
        ArrayList<MethodInfo> mapMethodInformation = new ArrayList<MethodInfo>();
        mapMethodInformation.add(new MethodInfo("doSomething", Arrays.asList("Integer"), "void", "void", "org.mortgages.MyType"));
        methodInformation.put("org.mortgages.MyType", mapMethodInformation);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(methodInformation);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod mc = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"doSomething", (Object)mc.getMethodName());
        Assert.assertEquals((Object)"t", (Object)mc.getVariable());
        Assert.assertEquals((long)1L, (long)mc.getState());
        Assert.assertEquals((long)1L, (long)mc.getFieldValues().length);
        ActionFieldFunction f1 = mc.getFieldValue(0);
        Assert.assertEquals((Object)"1 * 2", (Object)f1.getValue());
        Assert.assertEquals((Object)"Integer", (Object)f1.getType());
        Assert.assertEquals((long)3L, (long)f1.getNature());
        String marshalled = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        System.out.println(marshalled);
        this.assertEqualsIgnoreWhitespace(drl, marshalled);
    }

    @Test
    public void testMethodCallCheckParameterDataTypes3() {
        String drl = "package org.mortgages;\nimport org.mortgages.MyType;\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    i : Integer( )\n    t : MyType( )\n  then\n    t.doSomething( i );\nend\n";
        HashMap methodInformation = new HashMap();
        ArrayList<MethodInfo> mapMethodInformation = new ArrayList<MethodInfo>();
        mapMethodInformation.add(new MethodInfo("doSomething", Arrays.asList("Integer"), "void", "void", "org.mortgages.MyType"));
        methodInformation.put("org.mortgages.MyType", mapMethodInformation);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(methodInformation);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod mc = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"doSomething", (Object)mc.getMethodName());
        Assert.assertEquals((Object)"t", (Object)mc.getVariable());
        Assert.assertEquals((long)1L, (long)mc.getState());
        Assert.assertEquals((long)1L, (long)mc.getFieldValues().length);
        ActionFieldFunction f1 = mc.getFieldValue(0);
        Assert.assertEquals((Object)"i", (Object)f1.getValue());
        Assert.assertEquals((Object)"Integer", (Object)f1.getType());
        Assert.assertEquals((long)2L, (long)f1.getNature());
        String marshalled = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        System.out.println(marshalled);
        this.assertEqualsIgnoreWhitespace(drl, marshalled);
    }

    @Test
    public void testGlobalCollectionAdd() {
        String drl = "package org.mortgages;\n\nimport org.mortgages.LoanApplication;\n\nrule \"Bankruptcy history\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n  then\n    keke.add( a );\nend";
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("keke", "java.util.ArrayList");
        Mockito.when((Object)this.dmo.getPackageGlobals()).thenReturn(globals);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionGlobalCollectionAdd));
        ActionGlobalCollectionAdd actionGlobalCollectionAdd = (ActionGlobalCollectionAdd)m.rhs[0];
        Assert.assertEquals((Object)"keke", (Object)actionGlobalCollectionAdd.getGlobalName());
        Assert.assertEquals((Object)"a", (Object)actionGlobalCollectionAdd.getFactName());
    }

    @Test
    public void testFieldConstraintLessThanOrEqualTo() {
        String drl = "rule \"rule1\"\nwhen\nApplicant( age <= 22 )\nthen\nend";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getNumberOfConstraints());
        FieldConstraint fc = fp.getConstraint(0);
        Assert.assertNotNull((Object)fc);
        Assert.assertTrue((boolean)(fc instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc = (SingleFieldConstraint)fc;
        Assert.assertEquals((Object)"<=", (Object)sfc.getOperator());
        Assert.assertEquals((Object)"22", (Object)sfc.getValue());
    }

    @Test
    public void testExpressionWithListSize() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    Company( emps.size() == 0 )\n  then\nend";
        this.addModelField("Company", "emps", "java.util.List", "List");
        this.addMethodInformation("java.util.List", "size", new ArrayList<String>(), "int", null, "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern factPattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((long)1L, (long)factPattern.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(factPattern.getConstraintList().getConstraints()[0] instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide constraint = (SingleFieldConstraintEBLeftSide)factPattern.getConstraintList().getConstraints()[0];
        Assert.assertEquals((Object)"size", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"int", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"0", (Object)constraint.getValue());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((long)1L, (long)constraint.getConstraintValueType());
    }

    @Test
    public void testMVELInlineList() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    c : Company( )\n  then\n    c.setEmps( [\"item1\", \"item2\"] );\nend";
        this.addModelField("Company", "emps", "java.util.List", "Collection");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionSetField));
        ActionSetField actionSetField = (ActionSetField)m.rhs[0];
        Assert.assertEquals((Object)"c", (Object)actionSetField.getVariable());
        Assert.assertEquals((long)1L, (long)actionSetField.getFieldValues().length);
        ActionFieldValue actionFieldValue = actionSetField.getFieldValues()[0];
        Assert.assertEquals((Object)"[\"item1\", \"item2\"]", (Object)actionFieldValue.getValue());
        Assert.assertEquals((Object)"emps", (Object)actionFieldValue.getField());
        Assert.assertEquals((long)3L, (long)actionFieldValue.getNature());
        Assert.assertEquals((Object)"Collection", (Object)actionFieldValue.getType());
    }

    @Test
    public void testFunctionInRHS() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    application : Application( )\n  then\n    application.setApr( application.getApr() + 5 );\n    update( application )end";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionUpdateField));
        ActionUpdateField field = (ActionUpdateField)m.rhs[0];
        Assert.assertTrue((boolean)(field.getFieldValues()[0] instanceof ActionFieldValue));
        ActionFieldValue value = field.getFieldValues()[0];
        Assert.assertEquals((Object)"apr", (Object)value.getField());
        Assert.assertEquals((Object)"application.getApr() + 5", (Object)value.getValue());
        Assert.assertEquals((long)3L, (long)value.getNature());
        Assert.assertEquals((Object)"Numeric", (Object)value.getType());
    }

    @Test
    public void testFieldVars() throws Exception {
        String drl = "rule \"Borked\"\n  dialect \"mvel\"\n  when\n    Customer( var:contact )\n  then\nend";
        this.addModelField("Customer", "contact", "Contact", "Contact");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern.getFieldConstraints()[0];
        Assert.assertEquals((Object)"var", (Object)constraint.getFieldBinding());
        Assert.assertEquals((Object)"Customer", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"contact", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"Contact", (Object)constraint.getFieldType());
    }

    @Test
    public void testFieldVarsWithImports() throws Exception {
        String drl = "import org.test.Customer\nrule \"Borked\"\n  dialect \"mvel\"\n  when\n    Customer( var:contact )\n  then\nend";
        this.addModelField("org.test.Customer", "contact", "org.test.Contact", "org.test.Contact");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern.getFieldConstraints()[0];
        Assert.assertEquals((Object)"var", (Object)constraint.getFieldBinding());
        Assert.assertEquals((Object)"Customer", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"contact", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"org.test.Contact", (Object)constraint.getFieldType());
    }

    @Test
    public void testFieldVarsFactTypeInTheSamePackage() throws Exception {
        String drl = "package org.test\nrule \"Borked\"\n  dialect \"mvel\"\n  when\n    Customer( var:contact )\n  then\nend";
        this.addModelField("org.test.Customer", "contact", "org.test.Contact", "org.test.Contact");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern.getFieldConstraints()[0];
        Assert.assertEquals((Object)"var", (Object)constraint.getFieldBinding());
        Assert.assertEquals((Object)"Customer", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"contact", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"org.test.Contact", (Object)constraint.getFieldType());
    }

    @Test
    public void testSingleFieldConstraintEBLeftSide() throws Exception {
        String drl = "rule \" broken \"dialect \"mvel\"  when    Customer( contact != null , contact.tel1 > \"15\" )  thenend";
        this.addModelField("Customer", "contact", "Contact", "Contact");
        this.addModelField("Contact", "tel1", "String", "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern.getFieldConstraints()[0];
        Assert.assertEquals((Object)"Customer", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"contact", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"Contact", (Object)constraint.getFieldType());
        SingleFieldConstraintEBLeftSide constraint2 = (SingleFieldConstraintEBLeftSide)pattern.getFieldConstraints()[1];
        Assert.assertEquals((Object)"tel1", (Object)constraint2.getFieldName());
        Assert.assertEquals((Object)"String", (Object)constraint2.getFieldType());
        Assert.assertEquals((Object)"15", (Object)constraint2.getValue());
        Assert.assertEquals((Object)">", (Object)constraint2.getOperator());
        Assert.assertEquals((long)3L, (long)constraint2.getExpressionLeftSide().getParts().size());
        ExpressionPart part1 = (ExpressionPart)constraint2.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"Customer", (Object)part1.getName());
        Assert.assertEquals((Object)"Customer", (Object)part1.getClassType());
        Assert.assertEquals((Object)"Customer", (Object)part1.getGenericType());
        ExpressionPart part2 = (ExpressionPart)constraint2.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"contact", (Object)part2.getName());
        Assert.assertEquals((Object)"Contact", (Object)part2.getClassType());
        Assert.assertEquals((Object)"Contact", (Object)part2.getGenericType());
        ExpressionPart part3 = (ExpressionPart)constraint2.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"tel1", (Object)part3.getName());
        Assert.assertEquals((Object)"String", (Object)part3.getClassType());
        Assert.assertEquals((Object)"String", (Object)part3.getGenericType());
    }

    @Test
    public void testExpressionEditorLeftToOperator() throws Exception {
        String drl = "rule \"r1\"\ndialect \"mvel\"\nwhen\n a: Applicant()\n Applicant( age == a.age )\nthen\nend";
        this.addModelField("Applicant", "this", "Applicant", "this");
        this.addModelField("Applicant", "age", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern1 = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"a", (Object)pattern1.getBoundName());
        FactPattern pattern2 = (FactPattern)m.lhs[1];
        Assert.assertEquals((long)1L, (long)pattern2.getConstraintList().getNumberOfConstraints());
        Assert.assertTrue((boolean)(pattern2.getConstraintList().getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern2.getConstraintList().getConstraint(0);
        Assert.assertEquals((Object)"age", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((long)6L, (long)constraint.getConstraintValueType());
        Assert.assertEquals((Object)"", (Object)constraint.getValue());
        Assert.assertEquals((long)2L, (long)constraint.getExpressionValue().getParts().size());
        Assert.assertTrue((boolean)(constraint.getExpressionValue().getParts().get(0) instanceof ExpressionVariable));
        ExpressionVariable expressionVariable = (ExpressionVariable)constraint.getExpressionValue().getParts().get(0);
        Assert.assertEquals((Object)"a", (Object)expressionVariable.getName());
        Assert.assertEquals((Object)"Applicant", (Object)expressionVariable.getClassType());
        Assert.assertEquals((Object)"this", (Object)expressionVariable.getGenericType());
        Assert.assertEquals(constraint.getExpressionValue().getParts().get(1), (Object)expressionVariable.getNext());
        Assert.assertTrue((boolean)(constraint.getExpressionValue().getParts().get(1) instanceof ExpressionField));
        ExpressionField expressionField = (ExpressionField)constraint.getExpressionValue().getParts().get(1);
        Assert.assertEquals((Object)"age", (Object)expressionField.getName());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)expressionField.getClassType());
        Assert.assertEquals((Object)"Integer", (Object)expressionField.getGenericType());
    }

    @Test
    public void testEnumeration() throws Exception {
        String drl = "import org.drools.workbench.models.commons.backend.rule.TestEnum;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nOuterClassWithEnums( outerField == TestEnum.VALUE1 )\nthen\nend";
        this.addModelField("OuterClassWithEnums", "outerField", TestEnum.class.getSimpleName(), "Comparable");
        this.addJavaEnumDefinition("OuterClassWithEnums", "outerField", new String[]{"TestEnum.VALUE1=TestEnum.VALUE1", "TestEnum.VALUE2=TestEnum.VALUE2"});
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((long)1L, (long)pattern.getNumberOfConstraints());
        Assert.assertTrue((boolean)(pattern.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern.getConstraint(0);
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"outerField", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"Comparable", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((Object)"TestEnum.VALUE1", (Object)constraint.getValue());
        Assert.assertEquals((long)4L, (long)constraint.getConstraintValueType());
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, drl2);
    }

    @Test
    public void testFullyQualifiedClassNameEnumeration() throws Exception {
        String drl = "import org.drools.workbench.models.commons.backend.rule.TestEnum;\nimport org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nOuterClassWithEnums( outerField == TestEnum.VALUE1 )\nthen\nend";
        this.addModelField("org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums", "outerField", TestEnum.class.getSimpleName(), "Comparable");
        this.addJavaEnumDefinition("org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums", "outerField", new String[]{"TestEnum.VALUE1=TestEnum.VALUE1", "TestEnum.VALUE2=TestEnum.VALUE2"});
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((long)1L, (long)pattern.getNumberOfConstraints());
        Assert.assertTrue((boolean)(pattern.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint constraint = (SingleFieldConstraint)pattern.getConstraint(0);
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"outerField", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"Comparable", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((Object)"TestEnum.VALUE1", (Object)constraint.getValue());
        Assert.assertEquals((long)4L, (long)constraint.getConstraintValueType());
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, drl2);
    }

    @Test
    public void testEnumerationNestedClasses() throws Exception {
        String drl = "import org.drools.workbench.models.commons.backend.rule.TestEnum;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nOuterClassWithEnums( innerClass.innerField == TestEnum.VALUE1 )\nthen\nend";
        this.addModelField("OuterClassWithEnums", "innerClass", "InnerClassWithEnums", "InnerClassWithEnums");
        this.addModelField("InnerClassWithEnums", "innerField", TestEnum.class.getSimpleName(), "Comparable");
        this.addJavaEnumDefinition("InnerClassWithEnums", "innerField", new String[]{"TestEnum.VALUE1=TestEnum.VALUE1", "TestEnum.VALUE2=TestEnum.VALUE2"});
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((long)1L, (long)pattern.getNumberOfConstraints());
        Assert.assertTrue((boolean)(pattern.getConstraint(0) instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide constraint = (SingleFieldConstraintEBLeftSide)pattern.getConstraint(0);
        Assert.assertEquals((long)3L, (long)constraint.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact eubf = (ExpressionUnboundFact)constraint.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)eubf.getName());
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)eubf.getClassType());
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)eubf.getGenericType());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField ef1 = (ExpressionField)constraint.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"innerClass", (Object)ef1.getName());
        Assert.assertEquals((Object)"InnerClassWithEnums", (Object)ef1.getClassType());
        Assert.assertEquals((Object)"InnerClassWithEnums", (Object)ef1.getGenericType());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField ef2 = (ExpressionField)constraint.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"innerField", (Object)ef2.getName());
        Assert.assertEquals((Object)"TestEnum", (Object)ef2.getClassType());
        Assert.assertEquals((Object)"Comparable", (Object)ef2.getGenericType());
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"innerField", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"TestEnum", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((Object)"TestEnum.VALUE1", (Object)constraint.getValue());
        Assert.assertEquals((long)4L, (long)constraint.getConstraintValueType());
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, drl2);
    }

    @Test
    public void testFullyQualifiedClassNameEnumerationNestedClasses() throws Exception {
        String drl = "import org.drools.workbench.models.commons.backend.rule.TestEnum;\nimport org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums;\nimport org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums.InnerClassWithEnums;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nOuterClassWithEnums( innerClass.innerField == TestEnum.VALUE1 )\nthen\nend";
        this.addModelField("org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums", "innerClass", "org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums$InnerClassWithEnums", "OuterClassWithEnums$InnerClassWithEnums");
        this.addModelField("org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums$InnerClassWithEnums", "innerField", TestEnum.class.getSimpleName(), "Comparable");
        this.addJavaEnumDefinition("org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums$InnerClassWithEnums", "innerField", new String[]{"TestEnum.VALUE1=TestEnum.VALUE1", "TestEnum.VALUE2=TestEnum.VALUE2"});
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        FactPattern pattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((long)1L, (long)pattern.getNumberOfConstraints());
        Assert.assertTrue((boolean)(pattern.getConstraint(0) instanceof SingleFieldConstraintEBLeftSide));
        SingleFieldConstraintEBLeftSide constraint = (SingleFieldConstraintEBLeftSide)pattern.getConstraint(0);
        Assert.assertEquals((long)3L, (long)constraint.getExpressionLeftSide().getParts().size());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        ExpressionUnboundFact eubf = (ExpressionUnboundFact)constraint.getExpressionLeftSide().getParts().get(0);
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)eubf.getName());
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)eubf.getClassType());
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)eubf.getGenericType());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(1) instanceof ExpressionField));
        ExpressionField ef1 = (ExpressionField)constraint.getExpressionLeftSide().getParts().get(1);
        Assert.assertEquals((Object)"innerClass", (Object)ef1.getName());
        Assert.assertEquals((Object)"org.drools.workbench.models.commons.backend.rule.OuterClassWithEnums$InnerClassWithEnums", (Object)ef1.getClassType());
        Assert.assertEquals((Object)"OuterClassWithEnums$InnerClassWithEnums", (Object)ef1.getGenericType());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(2) instanceof ExpressionField));
        ExpressionField ef2 = (ExpressionField)constraint.getExpressionLeftSide().getParts().get(2);
        Assert.assertEquals((Object)"innerField", (Object)ef2.getName());
        Assert.assertEquals((Object)"TestEnum", (Object)ef2.getClassType());
        Assert.assertEquals((Object)"Comparable", (Object)ef2.getGenericType());
        Assert.assertEquals((Object)"OuterClassWithEnums", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"innerField", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"TestEnum", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((Object)"TestEnum.VALUE1", (Object)constraint.getValue());
        Assert.assertEquals((long)4L, (long)constraint.getConstraintValueType());
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace(drl, drl2);
    }

    @Test
    public void testCalendars() {
        String drl = "package org.mortgages;\n\nimport java.lang.Number;\nrule \"Test\"\n  calendars \"a\" ,\"b\"\n  dialect \"mvel\"\n  when\n  then\nend\n";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m.attributes[0]);
        RuleAttribute attribute = m.attributes[0];
        Assert.assertEquals((Object)"calendars", (Object)attribute.getAttributeName());
        Assert.assertEquals((Object)"a, b", (Object)attribute.getValue());
    }

    @Test
    public void testFromRestrictions() {
        String drl = "package org.mortgages;\n\nimport java.lang.Number;\nrule \"Test\"\n  dialect \"mvel\"\n  when\n    reserva : Reserva( )\n    itinerario : Itinerario( destino == \"USA\" ) from reserva.itinerarios\n  then\nend\n";
        this.addModelField("org.mortgages.Reserva", "itinerarios", "java.lang.List", "Collection");
        this.addModelField("org.mortgages.Itinerario", "destino", "String", "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertTrue((boolean)(m.lhs[1] instanceof FromCompositeFactPattern));
        FromCompositeFactPattern factPattern = (FromCompositeFactPattern)m.lhs[1];
        Assert.assertNotNull((Object)factPattern.getFactPattern().getConstraintList());
        Assert.assertEquals((long)1L, (long)factPattern.getFactPattern().getConstraintList().getNumberOfConstraints());
        SingleFieldConstraint constraint = (SingleFieldConstraint)factPattern.getFactPattern().getFieldConstraints()[0];
        Assert.assertEquals((Object)"Itinerario", (Object)constraint.getFactType());
        Assert.assertEquals((Object)"destino", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"String", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"USA", (Object)constraint.getValue());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
    }

    @Test
    public void testFactsWithSameName() {
        String drl = "package org.pkg1;\n\nimport java.lang.Number;\nrule \"Test\"\n  dialect \"mvel\"\n  when\n    Fact( field.field )\n  then\nend\n";
        this.addModelField("org.pkg1.Fact", "field", "org.pkg1.SubFact", "SubFact");
        this.addModelField("org.pkg1.SubFact", "field", "String", "String");
        this.addModelField("org.pkg2.Fact", "someOtherField", "org.pkg2.SubFact", "SubFact");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
    }

    @Test
    public void testFactsWithSameNameImports() {
        String drl = "package org.test;\n\nimport org.pkg1.Fact;\nrule \"Test\"\n  dialect \"mvel\"\n  when\n    Fact( field.field )\n  then\nend\n";
        this.addModelField("org.pkg1.Fact", "field", "org.pkg1.SubFact", "SubFact");
        this.addModelField("org.pkg1.SubFact", "field", "String", "String");
        this.addModelField("org.pkg2.Fact", "someOtherField", "org.pkg2.SubFact", "SubFact");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
    }

    @Test
    public void testFromBoundVariable() {
        String drl = "import java.lang.Number;\nimport org.drools.workbench.models.commons.backend.rule.Counter;\nrule \"rule1\"\nwhen\ncc : Counter()\nNumber() from cc.number\nthen\nend";
        this.addModelField("org.drools.workbench.models.commons.backend.rule.Counter", "number", "java.lang.Number", "Numeric");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)"rule1", (Object)m.name);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        IPattern p0 = m.lhs[0];
        Assert.assertTrue((boolean)(p0 instanceof FactPattern));
        FactPattern fp0 = (FactPattern)p0;
        Assert.assertEquals((Object)"Counter", (Object)fp0.getFactType());
        Assert.assertEquals((Object)"cc", (Object)fp0.getBoundName());
        Assert.assertEquals((long)0L, (long)fp0.getNumberOfConstraints());
        IPattern p1 = m.lhs[1];
        Assert.assertTrue((boolean)(p1 instanceof FromCompositeFactPattern));
        FromCompositeFactPattern fcfp1 = (FromCompositeFactPattern)p1;
        FactPattern fp1 = fcfp1.getFactPattern();
        ExpressionFormLine efl1 = fcfp1.getExpression();
        Assert.assertNotNull((Object)fp1);
        Assert.assertNotNull((Object)efl1);
        Assert.assertEquals((Object)"Number", (Object)fp1.getFactType());
        Assert.assertEquals((long)0L, (long)fp1.getNumberOfConstraints());
        Assert.assertEquals((long)2L, (long)efl1.getParts().size());
        Assert.assertTrue((boolean)(efl1.getParts().get(0) instanceof ExpressionVariable));
        Assert.assertTrue((boolean)(efl1.getParts().get(1) instanceof ExpressionField));
        ExpressionVariable eflv1 = (ExpressionVariable)efl1.getParts().get(0);
        Assert.assertEquals((Object)"cc", (Object)eflv1.getName());
        Assert.assertEquals((Object)"Counter", (Object)eflv1.getClassType());
        Assert.assertEquals((Object)"Numeric", (Object)eflv1.getGenericType());
        ExpressionField eflf1 = (ExpressionField)efl1.getParts().get(1);
        Assert.assertEquals((Object)"number", (Object)eflf1.getName());
        Assert.assertEquals((Object)"java.lang.Number", (Object)eflf1.getClassType());
        Assert.assertEquals((Object)"Numeric", (Object)eflf1.getGenericType());
    }

    @Test
    public void testFromAccumulate() {
        String drl = "import java.lang.Number;\nimport org.mortgages.Applicant;\nrule \"rule1\"\nwhen\n  total : Number( intValue > 0 ) from accumulate ( Applicant( age < 30 ), count() )\nthen\nend";
        this.addModelField("java.lang.Number", "intValue", "java.lang.Integer", "Numeric");
        this.addModelField("org.mortgages.Applicant", "age", "java.lang.Integer", "Numeric");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FromAccumulateCompositeFactPattern));
        FromAccumulateCompositeFactPattern pattern = (FromAccumulateCompositeFactPattern)m.lhs[0];
        Assert.assertNotNull((Object)pattern.getFactPattern());
        FactPattern factPattern = pattern.getFactPattern();
        Assert.assertEquals((Object)"total", (Object)factPattern.getBoundName());
        Assert.assertNotNull((Object)factPattern.getConstraintList());
        Assert.assertEquals((long)1L, (long)factPattern.getConstraintList().getNumberOfConstraints());
        FieldConstraint constraint = factPattern.getConstraintList().getConstraint(0);
        Assert.assertTrue((boolean)(constraint instanceof SingleFieldConstraint));
        SingleFieldConstraint fieldConstraint = (SingleFieldConstraint)constraint;
        Assert.assertEquals((Object)"Number", (Object)fieldConstraint.getFactType());
        Assert.assertEquals((Object)"intValue", (Object)fieldConstraint.getFieldName());
        Assert.assertEquals((Object)"Integer", (Object)fieldConstraint.getFieldType());
        Assert.assertEquals((Object)">", (Object)fieldConstraint.getOperator());
        Assert.assertEquals((Object)"0", (Object)fieldConstraint.getValue());
    }

    @Test
    public void testSimpleDSLExpansionLHS() {
        String drl = "rule \"rule1\"\nwhen\nEs gibt einen Vertrag\n- Rabatt nicht mehr als 123\nthen\nend\n";
        String dslDefinition = "Es gibt einen Vertrag";
        String dslFile = "[condition][vertrag]Es gibt einen Vertrag=vertrag : Vertrag()";
        String dslDefinition2 = "- Rabatt nicht mehr als {rabatt}";
        String dslFile2 = "[condition][vertrag]- Rabatt nicht mehr als {rabatt}=rabatt < {rabatt}";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, new ArrayList(), this.dmo, new String[]{"[condition][vertrag]Es gibt einen Vertrag=vertrag : Vertrag()", "[condition][vertrag]- Rabatt nicht mehr als {rabatt}=rabatt < {rabatt}"});
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof DSLSentence));
        DSLSentence dslSentence = (DSLSentence)m.lhs[0];
        Assert.assertEquals((Object)"Es gibt einen Vertrag", (Object)dslSentence.getDefinition());
        Assert.assertEquals((long)0L, (long)dslSentence.getValues().size());
        DSLSentence dslSentence2 = (DSLSentence)m.lhs[1];
        Assert.assertEquals((Object)"- Rabatt nicht mehr als {rabatt}", (Object)dslSentence2.getDefinition());
        Assert.assertEquals((long)1L, (long)dslSentence2.getValues().size());
        Assert.assertTrue((boolean)(dslSentence2.getValues().get(0) instanceof DSLVariableValue));
        DSLVariableValue dslComplexVariableValue = (DSLVariableValue)dslSentence2.getValues().get(0);
        Assert.assertEquals((Object)"123", (Object)dslComplexVariableValue.getValue());
    }

    @Test
    public void testDSL() {
        String drl = "package org.mortgages;\nrule \"testdsl\"\n  dialect \"mvel\"\n  when\n    There is a test rated applicant older than 111 years\n  then\nend";
        String dslDefinition = "There is a {rating} rated applicant older than {age} years";
        String dslFile = "[when]" + dslDefinition + "= Applicant( creditRating == \"{rating}\", age > {age} )";
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.mortgages");
        RuleModel model = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, new ArrayList(), this.dmo, new String[]{dslFile});
        Assert.assertEquals((long)1L, (long)model.lhs.length);
        DSLSentence dslSentence = (DSLSentence)model.lhs[0];
        Assert.assertEquals((Object)"test", (Object)((DSLVariableValue)dslSentence.getValues().get(0)).getValue());
        Assert.assertEquals((Object)"111", (Object)((DSLVariableValue)dslSentence.getValues().get(1)).getValue());
    }

    @Test
    public void testDSLDollar() {
        String drl = "package org.mortgages;\nrule \"testdsl\"\n  dialect \"mvel\"\n  when\n    Price is $111\n  then\nend";
        String dslDefinition = "Price is ${p}";
        String dslFile = "[when]" + dslDefinition + "= Item( price == \"{p}\" )";
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.mortgages");
        RuleModel model = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, new ArrayList(), this.dmo, new String[]{dslFile});
        Assert.assertEquals((long)1L, (long)model.lhs.length);
        DSLSentence dslSentence = (DSLSentence)model.lhs[0];
        Assert.assertEquals((Object)"Price is ${p}", (Object)dslSentence.getDefinition());
        Assert.assertEquals((Object)"111", (Object)((DSLVariableValue)dslSentence.getValues().get(0)).getValue());
    }

    @Test
    public void testDSLExpansionLHS() {
        String drl = "rule \"rule1\"\nwhen\nThe credit rating is AA\nthen\nend\n";
        String dslDefinition = "The credit rating is {rating:ENUM:Applicant.creditRating}";
        String dslFile = "[when]The credit rating is {rating:ENUM:Applicant.creditRating}=Applicant( creditRating == {rating} )";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, new ArrayList(), this.dmo, new String[]{"[when]The credit rating is {rating:ENUM:Applicant.creditRating}=Applicant( creditRating == {rating} )"});
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof DSLSentence));
        DSLSentence dslSentence = (DSLSentence)m.lhs[0];
        Assert.assertEquals((Object)"The credit rating is {rating:ENUM:Applicant.creditRating}", (Object)dslSentence.getDefinition());
        Assert.assertEquals((long)1L, (long)dslSentence.getValues().size());
        Assert.assertTrue((boolean)(dslSentence.getValues().get(0) instanceof DSLComplexVariableValue));
        DSLComplexVariableValue dslComplexVariableValue = (DSLComplexVariableValue)dslSentence.getValues().get(0);
        Assert.assertEquals((Object)"AA", (Object)dslComplexVariableValue.getValue());
        Assert.assertEquals((Object)"ENUM:Applicant.creditRating", (Object)dslComplexVariableValue.getId());
    }

    @Test
    public void testDSLExpansionRHS() {
        String drl = "rule \"rule1\"\nwhen\n$a : Applicant()then\nSet applicant name to Bobend\n";
        String dslDefinition = "Set applicant name to {name:\\w+ \\w+}";
        String dslFile = "[then]Set applicant name to {name:\\w+ \\w+}=$a.setName( \"{name}\" )";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, new ArrayList(), this.dmo, new String[]{"[then]Set applicant name to {name:\\w+ \\w+}=$a.setName( \"{name}\" )"});
        Assert.assertNotNull((Object)m);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern pattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"Applicant", (Object)pattern.getFactType());
        Assert.assertEquals((Object)"$a", (Object)pattern.getBoundName());
        Assert.assertTrue((boolean)(m.rhs[0] instanceof DSLSentence));
        DSLSentence dslSentence = (DSLSentence)m.rhs[0];
        Assert.assertEquals((Object)"Set applicant name to {name:\\w+ \\w+}", (Object)dslSentence.getDefinition());
        Assert.assertEquals((long)1L, (long)dslSentence.getValues().size());
        Assert.assertTrue((boolean)(dslSentence.getValues().get(0) instanceof DSLComplexVariableValue));
        DSLComplexVariableValue dslComplexVariableValue = (DSLComplexVariableValue)dslSentence.getValues().get(0);
        Assert.assertEquals((Object)"Bob", (Object)dslComplexVariableValue.getValue());
        Assert.assertEquals((Object)"\\w+ \\w+", (Object)dslComplexVariableValue.getId());
    }

    @Test
    public void testFunctionCalls() {
        String drl = "package org.mortgages\nimport java.lang.Number\nimport java.lang.String\nrule \"rule1\"\ndialect \"mvel\"\nwhen\n  s : String()\nthen\n  s.indexOf( s );\n  s.indexOf( 0 );\nend\n";
        HashMap methodInformation = new HashMap();
        ArrayList<MethodInfo> mapMethodInformation = new ArrayList<MethodInfo>();
        mapMethodInformation.add(new MethodInfo("indexOf", Arrays.asList("String"), "int", null, "String"));
        mapMethodInformation.add(new MethodInfo("indexOf", Arrays.asList("Integer"), "int", null, "String"));
        methodInformation.put("java.lang.String", mapMethodInformation);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(methodInformation);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        Assert.assertTrue((boolean)(m.rhs[1] instanceof ActionCallMethod));
        ActionCallMethod actionCallMethod1 = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((long)1L, (long)actionCallMethod1.getState());
        Assert.assertEquals((Object)"indexOf", (Object)actionCallMethod1.getMethodName());
        Assert.assertEquals((Object)"s", (Object)actionCallMethod1.getVariable());
        Assert.assertEquals((long)1L, (long)actionCallMethod1.getFieldValues().length);
        Assert.assertEquals((Object)"indexOf", (Object)actionCallMethod1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"s", (Object)actionCallMethod1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)2L, (long)actionCallMethod1.getFieldValues()[0].getNature());
        Assert.assertEquals((Object)"String", (Object)actionCallMethod1.getFieldValues()[0].getType());
        ActionCallMethod actionCallMethod2 = (ActionCallMethod)m.rhs[1];
        Assert.assertEquals((long)1L, (long)actionCallMethod2.getState());
        Assert.assertEquals((Object)"indexOf", (Object)actionCallMethod2.getMethodName());
        Assert.assertEquals((Object)"s", (Object)actionCallMethod2.getVariable());
        Assert.assertEquals((long)1L, (long)actionCallMethod2.getFieldValues().length);
        Assert.assertEquals((Object)"indexOf", (Object)actionCallMethod2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"0", (Object)actionCallMethod2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)actionCallMethod2.getFieldValues()[0].getNature());
        Assert.assertEquals((Object)"Numeric", (Object)actionCallMethod2.getFieldValues()[0].getType());
    }

    @Test
    public void testRHSInsertFactWithFieldAsVariable() {
        String drl = "package org.mortgages\nimport org.test.Person\nrule \"variable\"\ndialect \"mvel\"\nwhen\nPerson( $f : field1 == 44 )\nthen\nPerson fact0 = new Person();\nfact0.setField1( $f );\ninsert( fact0 );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"field1", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"==", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"44", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((Object)"$f", (Object)sfp.getFieldBinding());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionInsertFact));
        ActionInsertFact ap = (ActionInsertFact)a;
        Assert.assertEquals((Object)"Person", (Object)ap.getFactType());
        Assert.assertEquals((Object)"fact0", (Object)ap.getBoundName());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)2L, (long)afv.getNature());
        Assert.assertEquals((Object)"=$f", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSInsertFactWithFieldAsLiteral() {
        String drl = "package org.mortgages\nimport org.test.Person\nrule \"variable\"\ndialect \"mvel\"\nwhen\nPerson( field1 == 44 )\nthen\nPerson fact0 = new Person();\nfact0.setField1( 55 );\ninsert( fact0 );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"field1", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"==", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"44", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionInsertFact));
        ActionInsertFact ap = (ActionInsertFact)a;
        Assert.assertEquals((Object)"Person", (Object)ap.getFactType());
        Assert.assertEquals((Object)"fact0", (Object)ap.getBoundName());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)1L, (long)afv.getNature());
        Assert.assertEquals((Object)"55", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSUpdateFactWithFieldAsVariable() {
        String drl = "package org.mortgages\nimport org.test.Person\nrule \"variable\"\ndialect \"mvel\"\nwhen\n$p : Person( $f : field1 == 44 )\nthen\n$p.setField1( $f );\nupdate( $p );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((Object)"$p", (Object)fp.getBoundName());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"field1", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"==", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"44", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((Object)"$f", (Object)sfp.getFieldBinding());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionUpdateField));
        ActionUpdateField ap = (ActionUpdateField)a;
        Assert.assertEquals((Object)"$p", (Object)ap.getVariable());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)2L, (long)afv.getNature());
        Assert.assertEquals((Object)"=$f", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSUpdateFactWithFieldAsLiteral() {
        String drl = "package org.mortgages\nimport org.test.Person\nrule \"variable\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField1( 55 );\nupdate( $p );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)0L, (long)fp.getNumberOfConstraints());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionUpdateField));
        ActionUpdateField ap = (ActionUpdateField)a;
        Assert.assertEquals((Object)"$p", (Object)ap.getVariable());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)1L, (long)afv.getNature());
        Assert.assertEquals((Object)"55", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSInsertFactWithFieldAsVariableSamePackage() {
        String drl = "package org.test\nrule \"variable\"\ndialect \"mvel\"\nwhen\nPerson( $f : field1 == 44 )\nthen\nPerson fact0 = new Person();\nfact0.setField1( $f );\ninsert( fact0 );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"field1", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"==", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"44", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((Object)"$f", (Object)sfp.getFieldBinding());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionInsertFact));
        ActionInsertFact ap = (ActionInsertFact)a;
        Assert.assertEquals((Object)"Person", (Object)ap.getFactType());
        Assert.assertEquals((Object)"fact0", (Object)ap.getBoundName());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)2L, (long)afv.getNature());
        Assert.assertEquals((Object)"=$f", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSInsertFactWithFieldAsLiteralSamePackage() {
        String drl = "package org.test\nrule \"variable\"\ndialect \"mvel\"\nwhen\nPerson( field1 == 44 )\nthen\nPerson fact0 = new Person();\nfact0.setField1( 55 );\ninsert( fact0 );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"field1", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"==", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"44", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionInsertFact));
        ActionInsertFact ap = (ActionInsertFact)a;
        Assert.assertEquals((Object)"Person", (Object)ap.getFactType());
        Assert.assertEquals((Object)"fact0", (Object)ap.getBoundName());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)1L, (long)afv.getNature());
        Assert.assertEquals((Object)"55", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSUpdateFactWithFieldAsVariableSamePackage() {
        String drl = "package org.test\nrule \"variable\"\ndialect \"mvel\"\nwhen\n$p : Person( $f : field1 == 44 )\nthen\n$p.setField1( $f );\nupdate( $p );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((Object)"$p", (Object)fp.getBoundName());
        Assert.assertEquals((long)1L, (long)fp.getConstraintList().getConstraints().length);
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfp = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"Person", (Object)sfp.getFactType());
        Assert.assertEquals((Object)"field1", (Object)sfp.getFieldName());
        Assert.assertEquals((Object)"==", (Object)sfp.getOperator());
        Assert.assertEquals((Object)"44", (Object)sfp.getValue());
        Assert.assertEquals((long)1L, (long)sfp.getConstraintValueType());
        Assert.assertEquals((Object)"$f", (Object)sfp.getFieldBinding());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionUpdateField));
        ActionUpdateField ap = (ActionUpdateField)a;
        Assert.assertEquals((Object)"$p", (Object)ap.getVariable());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)2L, (long)afv.getNature());
        Assert.assertEquals((Object)"=$f", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSUpdateFactWithFieldAsLiteralSamePackage() {
        String drl = "package org.test\nrule \"variable\"\ndialect \"mvel\"\nwhen\n$p : Person()\nthen\n$p.setField1( 55 );\nupdate( $p );\nend";
        this.addModelField("org.test.Person", "field1", "java.lang.Integer", "Integer");
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"Person", (Object)fp.getFactType());
        Assert.assertEquals((long)0L, (long)fp.getNumberOfConstraints());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionUpdateField));
        ActionUpdateField ap = (ActionUpdateField)a;
        Assert.assertEquals((Object)"$p", (Object)ap.getVariable());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"field1", (Object)afv.getField());
        Assert.assertEquals((long)1L, (long)afv.getNature());
        Assert.assertEquals((Object)"55", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
    }

    @Test
    public void testRHSUpdateFactWithFormula() {
        String drl = "package org.mortgages;\nimport org.test.ShoppingCart\nrule \"r1\"\ndialect \"mvel\"\nwhen\n$sc : ShoppingCart( )\nthen\n$sc.setCartItemPromoSavings( ($sc.cartItemPromoSavings == 0.0) ? 0.0 : $sc.cartItemPromoSavings * -1 );\nupdate( $sc );\nend\n";
        this.addModelField("org.test.ShoppingCart", "cartItemPromoSavings", "java.lang.Double", "Double");
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"ShoppingCart", (Object)fp.getFactType());
        Assert.assertEquals((Object)"$sc", (Object)fp.getBoundName());
        Assert.assertEquals((long)0L, (long)fp.getNumberOfConstraints());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionUpdateField));
        ActionUpdateField ap = (ActionUpdateField)a;
        Assert.assertEquals((Object)"$sc", (Object)ap.getVariable());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"cartItemPromoSavings", (Object)afv.getField());
        Assert.assertEquals((Object)"($sc.cartItemPromoSavings == 0.0) ? 0.0 : $sc.cartItemPromoSavings * -1", (Object)afv.getValue());
        Assert.assertEquals((long)3L, (long)afv.getNature());
    }

    @Test
    public void testRHSUpdateFactWithFormulaSamePackage() {
        String drl = "package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\n$sc : ShoppingCart( )\nthen\n$sc.setCartItemPromoSavings( ($sc.cartItemPromoSavings == 0.0) ? 0.0 : $sc.cartItemPromoSavings * -1 );\nupdate( $sc );\nend\n";
        this.addModelField("org.test.ShoppingCart", "cartItemPromoSavings", "java.lang.Double", "Double");
        Mockito.when((Object)this.dmo.getPackageName()).thenReturn((Object)"org.test");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        IPattern p = m.lhs[0];
        Assert.assertTrue((boolean)(p instanceof FactPattern));
        FactPattern fp = (FactPattern)p;
        Assert.assertEquals((Object)"ShoppingCart", (Object)fp.getFactType());
        Assert.assertEquals((Object)"$sc", (Object)fp.getBoundName());
        Assert.assertEquals((long)0L, (long)fp.getNumberOfConstraints());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        IAction a = m.rhs[0];
        Assert.assertTrue((boolean)(a instanceof ActionUpdateField));
        ActionUpdateField ap = (ActionUpdateField)a;
        Assert.assertEquals((Object)"$sc", (Object)ap.getVariable());
        Assert.assertEquals((long)1L, (long)ap.getFieldValues().length);
        ActionFieldValue afv = ap.getFieldValues()[0];
        Assert.assertEquals((Object)"cartItemPromoSavings", (Object)afv.getField());
        Assert.assertEquals((Object)"($sc.cartItemPromoSavings == 0.0) ? 0.0 : $sc.cartItemPromoSavings * -1", (Object)afv.getValue());
        Assert.assertEquals((long)3L, (long)afv.getNature());
    }

    @Test
    public void testFunctionsWithVariableParameters() throws Exception {
        String drl = "package org.mortgages;\nrule \"test\"\n dialect \"mvel\"\n when\n  Calculator( s : summer)\n  Applicant( $age : age)\n then\n  s.sum( $age, $age );\nend";
        this.addModelField("Calculator", "summer", "Summer", "Summer");
        this.addModelField("Applicant", "age", "java.lang.Integer", "Integer");
        HashMap map = new HashMap();
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("Integer");
        params.add("Integer");
        methodInfos.add(new MethodInfo("sum", params, "java.lang.Integer", null, "Summer"));
        map.put("Calculator", methodInfos);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(map);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        ActionCallMethod actionCallMethod = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"sum", (Object)actionCallMethod.getMethodName());
        Assert.assertEquals((Object)"s", (Object)actionCallMethod.getVariable());
        Assert.assertEquals((long)2L, (long)actionCallMethod.getFieldValues().length);
        Assert.assertEquals((Object)"sum", (Object)actionCallMethod.getFieldValue(0).getField());
        Assert.assertEquals((Object)"$age", (Object)actionCallMethod.getFieldValue(0).getValue());
        Assert.assertEquals((long)2L, (long)actionCallMethod.getFieldValue(0).getNature());
        Assert.assertEquals((Object)"Integer", (Object)actionCallMethod.getFieldValue(0).getType());
        Assert.assertEquals((Object)"sum", (Object)actionCallMethod.getFieldValue(1).getField());
        Assert.assertEquals((Object)"$age", (Object)actionCallMethod.getFieldValue(1).getValue());
        Assert.assertEquals((long)2L, (long)actionCallMethod.getFieldValue(1).getNature());
        Assert.assertEquals((Object)"Integer", (Object)actionCallMethod.getFieldValue(1).getType());
    }

    @Test
    public void testListSize() throws Exception {
        String drl = "package org.mortgages;\nimport java.lang.Number;\nrule \"Test\"\n  dialect \"mvel\"\n  when\n    Person( addresses.size() == 0 )\n  then\nend\n";
        this.addModelField("Person", "addresses", "java.util.List", "Collection");
        this.addMethodInformation("java.util.List", "size", new ArrayList<String>(), "int", null, "Integer");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Person#addresses", "Address");
        Mockito.when((Object)this.dmo.getProjectFieldParametersType()).thenReturn(map);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        FactPattern pattern = (FactPattern)m.lhs[0];
        Assert.assertEquals((long)1L, (long)pattern.getConstraintList().getConstraints().length);
        SingleFieldConstraintEBLeftSide constraint = (SingleFieldConstraintEBLeftSide)pattern.getConstraint(0);
        Assert.assertEquals((Object)"size", (Object)constraint.getFieldName());
        Assert.assertEquals((Object)"int", (Object)constraint.getFieldType());
        Assert.assertEquals((Object)"0", (Object)constraint.getValue());
        Assert.assertEquals((Object)"==", (Object)constraint.getOperator());
        Assert.assertEquals((long)1L, (long)constraint.getConstraintValueType());
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(0) instanceof ExpressionUnboundFact));
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(1) instanceof ExpressionCollection));
        Assert.assertTrue((boolean)(constraint.getExpressionLeftSide().getParts().get(2) instanceof ExpressionMethod));
        this.assertEqualsIgnoreWhitespace(drl, RuleModelDRLPersistenceImpl.getInstance().marshal(m));
    }

    @Test
    public void testCollectWithFreeFormDRL_MethodsDefined() throws Exception {
        String drl = "package org.sample.resourceassignment;\nrule \"r1\"\ndialect \"mvel\"\nwhen\n$trans : Transactions()\n$transactions : java.util.List( eval( size > 0 ) ) from collect ( Transaction() from $trans.getRecCategorization().get(\"APES-01\") )\nthen\nend";
        this.addModelField("Transactions", "recCategorization", "java.util.Map", "Collection");
        this.addMethodInformation("Transactions", "getRecCategorization()", new ArrayList<String>(), "java.util.Map", null, "Collection");
        this.addMethodInformation("java.util.Map", "get", (List<String>)new ArrayList<String>(){
            {
                this.add("p0");
            }
        }, "java.lang.String", null, "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        IPattern p0 = m.lhs[0];
        Assert.assertTrue((boolean)(p0 instanceof FactPattern));
        FactPattern fp0 = (FactPattern)p0;
        Assert.assertEquals((Object)"Transactions", (Object)fp0.getFactType());
        Assert.assertEquals((Object)"$trans", (Object)fp0.getBoundName());
        Assert.assertEquals((long)0L, (long)fp0.getNumberOfConstraints());
        IPattern p1 = m.lhs[1];
        Assert.assertTrue((boolean)(p1 instanceof FromCollectCompositeFactPattern));
        FromCollectCompositeFactPattern fp1 = (FromCollectCompositeFactPattern)p1;
        Assert.assertEquals((Object)"java.util.List", (Object)fp1.getFactPattern().getFactType());
        Assert.assertEquals((Object)"$transactions", (Object)fp1.getFactPattern().getBoundName());
        Assert.assertEquals((long)1L, (long)fp1.getFactPattern().getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp1.getFactPattern().getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint fp1sfc = (SingleFieldConstraint)fp1.getFactPattern().getConstraint(0);
        Assert.assertEquals((Object)"size > 0", (Object)fp1sfc.getValue());
        Assert.assertEquals((long)5L, (long)fp1sfc.getConstraintValueType());
        Assert.assertTrue((boolean)(fp1.getRightPattern() instanceof FromCompositeFactPattern));
        FromCompositeFactPattern fp2 = (FromCompositeFactPattern)fp1.getRightPattern();
        Assert.assertNotNull((Object)fp2.getFactPattern());
        FactPattern fp3 = fp2.getFactPattern();
        Assert.assertEquals((Object)"Transaction", (Object)fp3.getFactType());
        Assert.assertEquals((long)0L, (long)fp3.getNumberOfConstraints());
        Assert.assertNotNull((Object)fp2.getExpression());
        ExpressionFormLine efl = fp2.getExpression();
        Assert.assertEquals((long)3L, (long)efl.getParts().size());
        Assert.assertTrue((boolean)(efl.getParts().get(0) instanceof ExpressionVariable));
        ExpressionVariable ev = (ExpressionVariable)efl.getParts().get(0);
        Assert.assertEquals((Object)"$trans", (Object)ev.getName());
        Assert.assertEquals((Object)"Transactions", (Object)ev.getClassType());
        Assert.assertTrue((boolean)(efl.getParts().get(1) instanceof ExpressionMethod));
        ExpressionMethod em = (ExpressionMethod)efl.getParts().get(1);
        Assert.assertEquals((Object)"getRecCategorization()", (Object)em.getName());
        Assert.assertEquals((Object)"java.util.Map", (Object)em.getClassType());
        Assert.assertEquals((Object)"Collection", (Object)em.getGenericType());
        Assert.assertTrue((boolean)(efl.getParts().get(2) instanceof ExpressionText));
        ExpressionText et = (ExpressionText)efl.getParts().get(2);
        Assert.assertEquals((Object)"get(\"APES-01\")", (Object)et.getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)et.getClassType());
        Assert.assertEquals((Object)"String", (Object)et.getGenericType());
        Assert.assertEquals((long)0L, (long)m.rhs.length);
    }

    @Test
    public void testCollectWithFreeFormDRL_MethodsUndefined() throws Exception {
        String drl = "package org.sample.resourceassignment;\nrule \"r1\"\ndialect \"mvel\"\nwhen\n$trans : Transactions()\n$transactions : java.util.List( eval( size > 0 ) ) from collect ( Transaction() from $trans.getRecCategorization().get(\"APES-01\") )\nthen\nend";
        this.addModelField("Transactions", "recCategorization", "java.util.Map", "Collection");
        this.addMethodInformation("java.util.Map", "get", (List<String>)new ArrayList<String>(){
            {
                this.add("p0");
            }
        }, "java.lang.String", null, "String");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.lhs.length);
        IPattern p0 = m.lhs[0];
        Assert.assertTrue((boolean)(p0 instanceof FactPattern));
        FactPattern fp0 = (FactPattern)p0;
        Assert.assertEquals((Object)"Transactions", (Object)fp0.getFactType());
        Assert.assertEquals((Object)"$trans", (Object)fp0.getBoundName());
        Assert.assertEquals((long)0L, (long)fp0.getNumberOfConstraints());
        IPattern p1 = m.lhs[1];
        Assert.assertTrue((boolean)(p1 instanceof FromCollectCompositeFactPattern));
        FromCollectCompositeFactPattern fp1 = (FromCollectCompositeFactPattern)p1;
        Assert.assertEquals((Object)"java.util.List", (Object)fp1.getFactPattern().getFactType());
        Assert.assertEquals((Object)"$transactions", (Object)fp1.getFactPattern().getBoundName());
        Assert.assertEquals((long)1L, (long)fp1.getFactPattern().getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp1.getFactPattern().getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint fp1sfc = (SingleFieldConstraint)fp1.getFactPattern().getConstraint(0);
        Assert.assertEquals((Object)"size > 0", (Object)fp1sfc.getValue());
        Assert.assertEquals((long)5L, (long)fp1sfc.getConstraintValueType());
        Assert.assertTrue((boolean)(fp1.getRightPattern() instanceof FromCompositeFactPattern));
        FromCompositeFactPattern fp2 = (FromCompositeFactPattern)fp1.getRightPattern();
        Assert.assertNotNull((Object)fp2.getFactPattern());
        FactPattern fp3 = fp2.getFactPattern();
        Assert.assertEquals((Object)"Transaction", (Object)fp3.getFactType());
        Assert.assertEquals((long)0L, (long)fp3.getNumberOfConstraints());
        Assert.assertNotNull((Object)fp2.getExpression());
        ExpressionFormLine efl = fp2.getExpression();
        Assert.assertEquals((long)3L, (long)efl.getParts().size());
        Assert.assertTrue((boolean)(efl.getParts().get(0) instanceof ExpressionVariable));
        ExpressionVariable ev = (ExpressionVariable)efl.getParts().get(0);
        Assert.assertEquals((Object)"$trans", (Object)ev.getName());
        Assert.assertEquals((Object)"Transactions", (Object)ev.getClassType());
        Assert.assertTrue((boolean)(efl.getParts().get(1) instanceof ExpressionText));
        ExpressionText et1 = (ExpressionText)efl.getParts().get(1);
        Assert.assertEquals((Object)"getRecCategorization()", (Object)et1.getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)et1.getClassType());
        Assert.assertEquals((Object)"String", (Object)et1.getGenericType());
        Assert.assertTrue((boolean)(efl.getParts().get(2) instanceof ExpressionText));
        ExpressionText et2 = (ExpressionText)efl.getParts().get(2);
        Assert.assertEquals((Object)"get(\"APES-01\")", (Object)et2.getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)et2.getClassType());
        Assert.assertEquals((Object)"String", (Object)et2.getGenericType());
        Assert.assertEquals((long)0L, (long)m.rhs.length);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

