/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.imports;

import org.drools.workbench.models.commons.backend.imports.ImportsWriter;
import org.drools.workbench.models.datamodel.imports.HasImports;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.junit.Assert;
import org.junit.Test;

public class ImportsWriterTest {
    @Test
    public void testNullModel() {
        HasImports model = new HasImports(){
            private Imports imports = null;

            public Imports getImports() {
                return this.imports;
            }

            public void setImports(Imports imports) {
            }
        };
        StringBuilder sb = new StringBuilder();
        ImportsWriter.write((StringBuilder)sb, (HasImports)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((boolean)drl.isEmpty());
    }

    @Test
    public void testEmptyModel() {
        HasImports model = new HasImports(){
            private Imports imports = new Imports();

            public Imports getImports() {
                return this.imports;
            }

            public void setImports(Imports imports) {
            }
        };
        StringBuilder sb = new StringBuilder();
        ImportsWriter.write((StringBuilder)sb, (HasImports)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((boolean)drl.isEmpty());
    }

    @Test
    public void testSingleImportModel() {
        String expectedDrl = "import java.lang.String;\n\n";
        HasImports model = new HasImports(){
            private Imports imports = new Imports();
            {
                this.imports.addImport(new Import("java.lang.String"));
            }

            public Imports getImports() {
                return this.imports;
            }

            public void setImports(Imports imports) {
            }
        };
        StringBuilder sb = new StringBuilder();
        ImportsWriter.write((StringBuilder)sb, (HasImports)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)"import java.lang.String;\n\n", (Object)drl);
    }

    @Test
    public void testMultipleImportsModel() {
        String expectedDrl = "import java.lang.String;\nimport java.lang.Double;\n\n";
        HasImports model = new HasImports(){
            private Imports imports = new Imports();
            {
                this.imports.addImport(new Import("java.lang.String"));
                this.imports.addImport(new Import("java.lang.Double"));
            }

            public Imports getImports() {
                return this.imports;
            }

            public void setImports(Imports imports) {
            }
        };
        StringBuilder sb = new StringBuilder();
        ImportsWriter.write((StringBuilder)sb, (HasImports)model);
        String drl = sb.toString();
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)"import java.lang.String;\nimport java.lang.Double;\n\n", (Object)drl);
    }
}

