/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.commons.backend.rule.RuleModelPersistence;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionExecuteWorkItem;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionGlobalCollectionAdd;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionInsertLogicalFact;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.ActionWorkItemFieldValue;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.DSLComplexVariableValue;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.DSLVariableValue;
import org.drools.workbench.models.datamodel.rule.ExpressionField;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionMethod;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.ExpressionText;
import org.drools.workbench.models.datamodel.rule.ExpressionUnboundFact;
import org.drools.workbench.models.datamodel.rule.ExpressionVariable;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromEntryPointFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.drools.workbench.models.datamodel.workitems.PortableBooleanParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableFloatParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableIntegerParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleModelDRLPersistenceTest {
    private static final Logger logger = LoggerFactory.getLogger(RuleModelDRLPersistenceTest.class);
    private RuleModelPersistence ruleModelPersistence;

    @Before
    public void setUp() throws Exception {
        this.ruleModelPersistence = RuleModelDRLPersistenceImpl.getInstance();
    }

    @Test
    public void testGenerateEmptyDRL() {
        String expected = "rule \"null\"\n\tdialect \"mvel\"\n\twhen\n\tthen\nend\n";
        this.checkMarshalling(expected, new RuleModel());
    }

    private void checkMarshalling(String expected, RuleModel m) {
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        if (expected != null) {
            this.assertEqualsIgnoreWhitespace(expected, drl);
        }
    }

    private void checkMarshallingUsingDsl(String expected, RuleModel m) {
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        if (expected != null) {
            this.assertEqualsIgnoreWhitespace(expected, drl);
        }
    }

    @Test
    public void testFreeForm() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.setText("Person()");
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.setText("fun()");
        m.rhs[0] = fr;
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("Person()") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("fun()") > drl.indexOf("Person()") ? 1 : 0) != 0);
    }

    @Test
    public void testBasics() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testInsertLogical() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsertLogical( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertLogicalFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testAttr() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("enabled", "true");
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("enabled true") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalendars() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("calendars", "a, b");
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("calendars \"a\", \"b\"") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalendarsWithQuotes() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("calendars", "\"a\", \"b\"");
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("calendars \"a\", \"b\"") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalendarsWithQuotesAroundWholeValue() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("calendars", "\"a, b\"");
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("calendars \"a\", \"b\"") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnumNoType() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == \"CheeseType.CHEDDAR\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("CheeseType.CHEDDAR");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEnumTypeString() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == \"CHEDDAR\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("CHEDDAR");
        con.setFieldType("String");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testExtends() {
        String expected = "rule \"my rule\" extends \"secondRule\"\n\tdialect \"mvel\"\n\twhen\n\tthen\n\nend\n";
        RuleModel m = new RuleModel();
        m.parentName = "secondRule";
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testSumAsGivenValue() {
        String expected = "rule \"my rule\" \n  dialect \"mvel\"\n  when\n    m:Message()\n  then\n    modify( m ) {\n      setText( \"Hello \" + \"world\" )\n    }\nend\n";
        RuleModel m = new RuleModel();
        FactPattern factPattern = new FactPattern();
        factPattern.setFactType("Message");
        factPattern.setBoundName("m");
        m.lhs = new IPattern[]{factPattern};
        ActionUpdateField actionUpdateField = new ActionUpdateField();
        actionUpdateField.setVariable("m");
        ActionFieldValue actionFieldValue = new ActionFieldValue();
        actionFieldValue.setField("text");
        actionFieldValue.setType("String");
        actionFieldValue.setNature(3);
        actionFieldValue.setValue("\"Hello \" + \"world\"");
        actionUpdateField.setFieldValues(new ActionFieldValue[]{actionFieldValue});
        m.rhs = new IAction[]{actionUpdateField};
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testNotNull() {
        String expected = "rule \"my rule\" \n  dialect \"mvel\"\n  when\n    Customer( contact != null , contact.tel1 > 15 )\n  then\nend\n";
        RuleModel m = new RuleModel();
        FactPattern factPattern = new FactPattern();
        factPattern.setFactType("Customer");
        m.lhs = new IPattern[]{factPattern};
        SingleFieldConstraint constraint1 = new SingleFieldConstraint("Customer", "contact", "Contact", null);
        constraint1.setOperator("!= null");
        factPattern.addConstraint((FieldConstraint)constraint1);
        SingleFieldConstraint constraint2 = new SingleFieldConstraint("Customer", "contact", "Contact", null);
        factPattern.addConstraint((FieldConstraint)constraint2);
        SingleFieldConstraint constraint3 = new SingleFieldConstraint("Contact", "tel1", "Integer", (FieldConstraint)constraint2);
        constraint3.setOperator(">");
        constraint3.setValue("15");
        factPattern.addConstraint((FieldConstraint)constraint3);
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testCallFunction() throws Exception {
        String expected = "package org.mortgages;\nimport org.mortgages.LoanApplication;\n\nrule \"my rule\"\n  dialect \"mvel\"\n  when\n    a : LoanApplication( )\n  then\n    keke.clear(  );\nend\n";
        RuleModel m = new RuleModel();
        m.setPackageName("org.mortgages");
        m.getImports().addImport(new Import("org.mortgages.LoanApplication"));
        m.name = "my rule";
        FactPattern factPattern = new FactPattern();
        factPattern.setFactType("LoanApplication");
        factPattern.setBoundName("a");
        m.lhs = new IPattern[]{factPattern};
        ActionCallMethod actionCallMethod = new ActionCallMethod();
        actionCallMethod.setState(1);
        actionCallMethod.setMethodName("clear");
        actionCallMethod.setVariable("keke");
        m.rhs = new IAction[]{actionCallMethod};
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEnumTypeNumeric() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( age == 100 )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("==");
        con.setValue("100");
        con.setFieldType("Integer");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEnumTypeStringInOperator() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type in ( \"CHEDDAR\", \"STILTON\" ) )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("in");
        con.setValue("( \"CHEDDAR\",\"STILTON\" )");
        con.setFieldType("String");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEnumTypeBoolean() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( smelly == true )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("smelly");
        con.setOperator("==");
        con.setValue("true");
        con.setFieldType("Boolean");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEnumTypeDate() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( dateMade == \"31-Jan-2010\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("dateMade");
        con.setOperator("==");
        con.setValue("31-Jan-2010");
        con.setFieldType("Date");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEnumTypeComparable() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == Cheese.CHEDDAR )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("Cheese.CHEDDAR");
        con.setFieldType("Comparable");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testMoreComplexRendering() {
        RuleModel m = this.getComplexModel(false);
        String expected = "rule \"Complex Rule\"\nno-loop true\nsalience -10\nagenda-group \"aGroup\"\ndialect \"mvel\"\nwhen\n  p1 : Person( f1 : age < 42 )\n  not (Cancel( )) \nthen\n  modify( p1 ) {\n    setStatus( \"rejected\" ),\n    setName( \"Fred\" )\n  }\n  retract( p1 );\nend\n";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testMoreComplexRenderingWithDsl() {
        RuleModel m = this.getComplexModel(true);
        String expected = "rule \"Complex Rule\"\nno-loop true\nsalience -10\nagenda-group \"aGroup\"\ndialect \"mvel\"\nwhen\n  >p1 : Person( f1 : age < 42 )\n  >not (Cancel( )) \nthen\n  >modify( p1 ) {\n    >setStatus( \"rejected\" ),\n    >setName( \"Fred\" )\n  >}\n  >retract( p1 );\nSend an email to administrator\nend\n";
        this.checkMarshallingUsingDsl(expected, m);
        String drl = this.ruleModelPersistence.marshal(m);
        this.assertEqualsIgnoreWhitespace(expected, drl);
        String dslFile = "[then]Send an email to {administrator}=sendMailTo({administrator});";
        RuleModel unmarshalledModel = this.ruleModelPersistence.unmarshalUsingDSL(drl, null, (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class), new String[]{dslFile});
        IAction[] actions = unmarshalledModel.rhs;
        DSLSentence dslSentence = (DSLSentence)actions[actions.length - 1];
        Assert.assertEquals((Object)"Send an email to {administrator}", (Object)dslSentence.getDefinition());
        this.checkMarshallingUsingDsl(expected, unmarshalledModel);
    }

    @Test
    public void testDSLExpansion() {
        String expected = "rule \"Rule With DSL\"\n\tdialect \"mvel\"\n\twhen\n\t\tThe credit rating is AA\n\tthen\nend\n";
        String dslDefinition = "The credit rating is {rating:ENUM:Applicant.creditRating}";
        DSLSentence dsl = new DSLSentence();
        dsl.setDefinition("The credit rating is {rating:ENUM:Applicant.creditRating}");
        List values = dsl.getValues();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertTrue((boolean)(values.get(0) instanceof DSLComplexVariableValue));
        Assert.assertEquals((Object)"rating", (Object)((DSLVariableValue)values.get(0)).getValue());
        Assert.assertEquals((Object)"ENUM:Applicant.creditRating", (Object)((DSLComplexVariableValue)values.get(0)).getId());
        ((DSLVariableValue)dsl.getValues().get(0)).setValue("AA");
        String expansion = dsl.interpolate();
        Assert.assertEquals((Object)"The credit rating is AA", (Object)expansion);
        Assert.assertEquals((Object)dsl.getDefinition(), (Object)"The credit rating is {rating:ENUM:Applicant.creditRating}");
        RuleModel m = new RuleModel();
        m.name = "Rule With DSL";
        m.addLhsItem((IPattern)dsl);
        String drl = this.ruleModelPersistence.marshal(m);
        this.assertEqualsIgnoreWhitespace(expected, drl);
        String dslFile = "[when]The credit rating is {rating:ENUM:Applicant.creditRating}=Credit( rating == {rating} )";
        RuleModel unmarshalledModel = this.ruleModelPersistence.unmarshalUsingDSL(drl, null, null, new String[]{dslFile});
        DSLSentence dslSentence = (DSLSentence)unmarshalledModel.lhs[0];
        Assert.assertEquals((Object)"The credit rating is {rating:ENUM:Applicant.creditRating}", (Object)dslSentence.getDefinition());
        Assert.assertEquals((long)1L, (long)dslSentence.getValues().size());
        Assert.assertTrue((boolean)(dslSentence.getValues().get(0) instanceof DSLComplexVariableValue));
        DSLComplexVariableValue dslComplexVariableValue = (DSLComplexVariableValue)dslSentence.getValues().get(0);
        Assert.assertEquals((Object)"AA", (Object)dslComplexVariableValue.getValue());
        Assert.assertEquals((Object)"ENUM:Applicant.creditRating", (Object)dslComplexVariableValue.getId());
        this.assertEqualsIgnoreWhitespace(expected, this.ruleModelPersistence.marshal(unmarshalledModel));
    }

    @Test
    public void testDSLExpansionContainingRegex() {
        String expected = "rule \"RegexDslRule\"\ndialect \"mvel\"\nwhen\nWhen the ages is less than  57\nthen\nend\n";
        String dslDefinition = "When the ages is less than {num:1?[0-9]?[0-9]}";
        DSLSentence dsl = new DSLSentence();
        dsl.setDefinition("When the ages is less than {num:1?[0-9]?[0-9]}");
        List values = dsl.getValues();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertTrue((boolean)(values.get(0) instanceof DSLComplexVariableValue));
        Assert.assertEquals((Object)"num", (Object)((DSLVariableValue)values.get(0)).getValue());
        Assert.assertEquals((Object)"1?[0-9]?[0-9]", (Object)((DSLComplexVariableValue)values.get(0)).getId());
        ((DSLVariableValue)dsl.getValues().get(0)).setValue("57");
        String expansion = dsl.interpolate();
        Assert.assertEquals((Object)"When the ages is less than 57", (Object)expansion);
        Assert.assertEquals((Object)dsl.getDefinition(), (Object)"When the ages is less than {num:1?[0-9]?[0-9]}");
        RuleModel m = new RuleModel();
        m.name = "RegexDslRule";
        m.addLhsItem((IPattern)dsl);
        String drl = this.ruleModelPersistence.marshal(m);
        this.assertEqualsIgnoreWhitespace(expected, drl);
        String dslFile = "[when]When the ages is less than {num:1?[0-9]?[0-9]}=applicant:Applicant(age<{num})";
        RuleModel model = this.ruleModelPersistence.unmarshalUsingDSL(drl, null, null, new String[]{dslFile});
        DSLSentence dslSentence = (DSLSentence)model.lhs[0];
        Assert.assertEquals((Object)"When the ages is less than {num:1?[0-9]?[0-9]}", (Object)dslSentence.getDefinition());
        Assert.assertEquals((long)1L, (long)dslSentence.getValues().size());
        Assert.assertTrue((boolean)(dslSentence.getValues().get(0) instanceof DSLComplexVariableValue));
        DSLComplexVariableValue dslComplexVariableValue = (DSLComplexVariableValue)dslSentence.getValues().get(0);
        Assert.assertEquals((Object)"57", (Object)dslComplexVariableValue.getValue());
        Assert.assertEquals((Object)"1?[0-9]?[0-9]", (Object)dslComplexVariableValue.getId());
        this.assertEqualsIgnoreWhitespace(drl, this.ruleModelPersistence.marshal(model));
    }

    @Test
    public void testDSLExpansionLHS() {
        String dslDefinition = "The credit rating is {rating:ENUM:Applicant.creditRating}";
        String drlExpected = "rule \"r1\"\ndialect \"mvel\"\nwhen\nThe credit rating is AA\nthen\nend";
        DSLSentence dsl = new DSLSentence();
        dsl.setDefinition("The credit rating is {rating:ENUM:Applicant.creditRating}");
        ((DSLVariableValue)dsl.getValues().get(0)).setValue("AA");
        RuleModel m = new RuleModel();
        m.name = "r1";
        m.addLhsItem((IPattern)dsl);
        String drlActual = this.ruleModelPersistence.marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"r1\"\ndialect \"mvel\"\nwhen\nThe credit rating is AA\nthen\nend", drlActual);
    }

    private RuleModel getComplexModel(boolean useDsl) {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addAttribute(new RuleAttribute("salience", "-10"));
        m.addAttribute(new RuleAttribute("agenda-group", "aGroup"));
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        con.setOperator("<");
        con.setValue("42");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern((IFactPattern)new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField upd1 = new ActionUpdateField();
        upd1.setVariable("p1");
        upd1.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        upd1.addFieldValue(new ActionFieldValue("name", "Fred", "String"));
        m.addRhsItem((IAction)upd1);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        if (useDsl) {
            DSLSentence sen = new DSLSentence();
            sen.setDefinition("Send an email to {administrator}");
            m.addRhsItem((IAction)sen);
        }
        return m;
    }

    @Test
    public void testFieldBindingWithNoConstraints() {
        RuleModel m = this.getModelWithNoConstraints();
        String s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        logger.debug(s);
        Assert.assertTrue((boolean)s.contains("Person( f1 : age)"));
        this.checkMarshalling(s, m);
    }

    @Test
    public void textIsNullOperator() {
        RuleModel m = new RuleModel();
        m.name = "IsNullOperator";
        FactPattern pat = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("== null");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        String s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( age == null )") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(s, m);
    }

    @Test
    public void textIsNotNullOperator() {
        RuleModel m = new RuleModel();
        m.name = "IsNotNullOperator";
        FactPattern pat = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("!= null");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        String s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( age != null )") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(s, m);
    }

    private RuleModel getModelWithNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        return m;
    }

    @Test
    public void testOrComposite() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("( Person( age == 42 ) or Person( age == 43 ) )") > 0 ? 1 : 0) != 0);
        this.checkMarshalling(result, m);
    }

    @Test
    public void testExistsMultiPatterns() throws Exception {
        RuleModel m = this.getCompositeFOL("exists");
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
        this.checkMarshalling(result, m);
    }

    @Test
    public void testNotMultiPatterns() throws Exception {
        RuleModel m = this.getCompositeFOL("not");
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("not (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
        this.checkMarshalling(result, m);
    }

    @Test
    public void testSingleExists() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("exists");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        m.addLhsItem((IPattern)cp);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        logger.debug(result);
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 )) ") > 0 ? 1 : 0) != 0);
        this.checkMarshalling(result, m);
    }

    private RuleModel getCompositeFOL(String type) {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern(type);
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        return m;
    }

    @Test
    public void testCompositeConstraints() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.setBoundName("p1");
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("goo");
        X.setFieldType("String");
        X.setConstraintValueType(1);
        X.setValue("foo");
        X.setOperator("==");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = new ConnectiveConstraint();
        X.getConnectives()[0].setConstraintValueType(1);
        X.getConnectives()[0].setFieldType("String");
        X.getConnectives()[0].setOperator("|| ==");
        X.getConnectives()[0].setValue("bar");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("goo2");
        Y.setFieldType("String");
        Y.setConstraintValueType(1);
        Y.setValue("foo");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.setFieldType("String");
        Q1.setFieldName("goo");
        Q1.setOperator("==");
        Q1.setValue("whee");
        Q1.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.setFieldType("String");
        Q2.setFieldName("gabba");
        Q2.setOperator("==");
        Q2.setValue("whee");
        Q2.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.setFieldName("goo3");
        Z.setConstraintValueType(1);
        Z.setFieldType("String");
        Z.setValue("foo");
        Z.setOperator("==");
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"with composite\"\n\tdialect \"mvel\"\n\twhen\n\t\tp1 : Person( )\n\t\tGoober( goo == \"foo\"  || == \"bar\" || goo2 == \"foo\" || ( goo == \"whee\" && gabba == \"whee\" ), goo3 == \"foo\" )\n\tthen\n\t\tinsert( new Whee() );\nend\n";
        this.assertEqualsIgnoreWhitespace(expected, actual);
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testFieldsDeclaredButNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "boo";
        FactPattern p = new FactPattern("Person");
        p.addConstraint((FieldConstraint)new SingleFieldConstraint("field1"));
        m.addLhsItem((IPattern)p);
        String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"boo\" \tdialect \"mvel\"\n when Person() then end";
        this.checkMarshalling(expected, m);
        SingleFieldConstraint con = (SingleFieldConstraint)p.getConstraintList().getConstraint(0);
        con.setFieldBinding("q");
        expected = "rule \"boo\" dialect \"mvel\" when Person(q : field1) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralStrings() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test literal strings\"\tdialect \"mvel\"\n when      Person(field1 == \"goo\", field2 == variableHere) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionString1() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsString1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionText("field1"));
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsString1\"\tdialect \"mvel\"\n when      Person( field1 == \"goo\" ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionString2() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsString2";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.String", "String"));
        con.setOperator("==");
        con.setValue("Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"test expressionsString2\"\tdialect \"mvel\"\n when      Person( field1 == \"Cheddar\" ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionJavaEnum() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsJavaEnum";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "CHEESE", "Comparable"));
        con.setOperator("==");
        con.setValue("CHEESE.Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsJavaEnum\"\tdialect \"mvel\"\n when      Person( field1 == CHEESE.Cheddar ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionNumber() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNumber";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.Integer", "Integer"));
        con.setOperator("==");
        con.setValue("55");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsNumber\"\tdialect \"mvel\"\n when      Person( field1 == 55 ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionDate() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsDate";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.util.Date", "Date"));
        con.setOperator("==");
        con.setValue("27-Jun-2011");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsDate\"\tdialect \"mvel\"\n when      Person( field1 == \"27-Jun-2011\" ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionBoolean() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsBoolean";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.Boolean", "Boolean"));
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsBoolean\"\tdialect \"mvel\"\n when      Person( field1 == true ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionNestedString() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedString";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("name", "java.lang.String", "String"));
        con.setOperator("==");
        con.setValue("Cheedar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsNestedString\"\tdialect \"mvel\"\n when      Person( favouriteCheese.name == \"Cheedar\" ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionNestedNumber() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedNumber";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("age", "java.lang.Integer", "Integer"));
        con.setOperator("==");
        con.setValue("55");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsNestedNumber\"\tdialect \"mvel\"\n when      Person( favouriteCheese.age == 55 ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionNestedDate() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedDate";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("dateBrought", "java.util.Date", "Date"));
        con.setOperator("==");
        con.setValue("27-Jun-2011");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsNestedDate\"\tdialect \"mvel\"\n when      Person( favouriteCheese.dateBrought == \"27-Jun-2011\" ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionNestedJavaEnum() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedJavaEnum";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("genericName", "CHEESE", "Comparable"));
        con.setOperator("==");
        con.setValue("CHEESE.Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsNestedJavaEnum\"\tdialect \"mvel\"\n when      Person( favouriteCheese.genericName == CHEESE.Cheddar ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSExpressionNestedBoolean() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedBoolean";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("smelly", "java.lang.Boolean", "Boolean"));
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test expressionsNestedBoolean\"\tdialect \"mvel\"\n when      Person( favouriteCheese.smelly == true ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralNumerics() {
        RuleModel m = new RuleModel();
        m.name = "test literal numerics";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test literal numerics\"\tdialect \"mvel\"\n when      Person(field1 == 44, field2 == variableHere) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralBigDecimalMvel() {
        RuleModel m = new RuleModel();
        m.name = "test literal bigdecimal";
        m.addAttribute(new RuleAttribute("dialect", "mvel"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigDecimal");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigDecimal"));
        m.addRhsItem((IAction)ai);
        String expected = "rule \"test literal bigdecimal\" \n\tdialect \"mvel\"\n when \n     Person(field1 == 44B) \n then \nPerson fact0 = new Person(); \nfact0.setField1( 55B ); \ninsert( fact0 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralBigIntegerMvel() {
        RuleModel m = new RuleModel();
        m.name = "test literal biginteger";
        m.addAttribute(new RuleAttribute("dialect", "mvel"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigInteger");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigInteger"));
        m.addRhsItem((IAction)ai);
        String expected = "rule \"test literal biginteger\" \n\tdialect \"mvel\"\n when \n     Person(field1 == 44I ) \n then \nPerson fact0 = new Person(); \nfact0.setField1( 55I ); \ninsert( fact0 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralBigDecimalJava() {
        RuleModel m = new RuleModel();
        m.name = "test literal bigdecimal";
        m.addAttribute(new RuleAttribute("dialect", "java"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigDecimal");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigDecimal"));
        m.addRhsItem((IAction)ai);
        String expected = "rule \"test literal bigdecimal\" \n\tdialect \"java\"\n when \n     Person(field1 == 44B) \n then \nPerson fact0 = new Person(); \nfact0.setField1( new java.math.BigDecimal( \"55\" ) ); \ninsert( fact0 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralBigIntegerJava() {
        RuleModel m = new RuleModel();
        m.name = "test literal biginteger";
        m.addAttribute(new RuleAttribute("dialect", "java"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigInteger");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigInteger"));
        m.addRhsItem((IAction)ai);
        String expected = "rule \"test literal biginteger\" \n\tdialect \"java\"\n when \n     Person(field1 == 44I ) \n then \nPerson fact0 = new Person(); \nfact0.setField1( new java.math.BigInteger( \"55\" ) ); \ninsert( fact0 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralBooleans() {
        RuleModel m = new RuleModel();
        m.name = "test literal booleans";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Boolean");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test literal booleans\"\tdialect \"mvel\"\n when      Person(field1 == true, field2 == variableHere) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralDates() {
        RuleModel m = new RuleModel();
        m.name = "test literal dates";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Date");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("31-Jan-2010");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test literal dates\"\tdialect \"mvel\"\n when      Person(field1 == \"31-Jan-2010\", field2 == variableHere) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLiteralNoType() {
        RuleModel m = new RuleModel();
        m.name = "test literal no type";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("bananna");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test literal no type\"\tdialect \"mvel\"\n when      Person(field1 == \"bananna\", field2 == variableHere) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testInOperatorString() {
        RuleModel m = new RuleModel();
        m.name = "in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("in");
        con.setValue("value1, value2");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"in\" \ndialect \"mvel\" \nwhen \n     Person(field1 in ( \"value1\", \"value2\" ) ) \n then \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testInOperatorNumber() {
        RuleModel m = new RuleModel();
        m.name = "in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("in");
        con.setValue("55, 66");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"in\" \ndialect \"mvel\" \nwhen \n     Person(field1 in ( 55, 66 ) ) \n then \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testNotInOperatorString() {
        RuleModel m = new RuleModel();
        m.name = "not in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("not in");
        con.setValue("value1, value2");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"not in\" \ndialect \"mvel\" \nwhen \n     Person(field1 not in ( \"value1\", \"value2\" ) ) \n then \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testNotInOperatorNumber() {
        RuleModel m = new RuleModel();
        m.name = "not in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("not in");
        con.setValue("55, 66");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"not in\" \ndialect \"mvel\" \nwhen \n     Person(field1 not in ( 55, 66 ) ) \n then \nend";
        this.checkMarshalling(expected, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateInsertAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionInsertFact ai = new ActionInsertFact("Birthday");
            ai.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)ai);
            String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("fact0.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            this.checkMarshalling(null, m);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateModifyAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionUpdateField am = new ActionUpdateField("$p");
            am.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)am);
            String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("modify( $p ) {") != -1 ? 1 : 0) != 0);
            this.checkMarshalling(null, m);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateUpdateAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionSetField au = new ActionSetField("$p");
            au.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)au);
            String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("update( $p );") == -1 ? 1 : 0) != 0);
            this.checkMarshalling(null, m);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    @Test
    public void testRHSExecuteWorkItem1() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern p = new FactPattern("Person");
        p.setBoundName("$p");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("name");
        con.setOperator("==");
        con.setValue("Michael");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", Boolean.TRUE );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", 123.456f );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", 123 );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", \"hello\" );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testRHSExecuteWorkItem2() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern p = new FactPattern("Person");
        p.setBoundName("$p");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("name");
        con.setOperator("==");
        con.setValue("Michael");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setValue(Boolean.TRUE);
        p1.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setValue(Float.valueOf(123.456f));
        p2.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setValue(Integer.valueOf(123));
        p3.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setValue("hello");
        p4.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", Boolean.TRUE );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", 123.456f );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", 123 );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", \"hello\" );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testRHSExecuteWorkItemWithBindings() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Person");
        fp1.setBoundName("$p");
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("String");
        con1.setFieldName("name");
        con1.setOperator("==");
        con1.setValue("Michael");
        con1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)con1);
        m.addLhsItem((IPattern)fp1);
        FactPattern fp2 = new FactPattern("Boolean");
        fp2.setBoundName("$b");
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldType("Boolean");
        con2.setFieldName("this");
        con2.setOperator("==");
        con2.setValue("true");
        con2.setConstraintValueType(1);
        fp2.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)fp2);
        FactPattern fp3 = new FactPattern("Float");
        fp3.setBoundName("$f");
        SingleFieldConstraint con3 = new SingleFieldConstraint();
        con3.setFieldType("Float");
        con3.setFieldName("this");
        con3.setOperator("==");
        con3.setValue("123.456f");
        con3.setConstraintValueType(1);
        fp3.addConstraint((FieldConstraint)con3);
        m.addLhsItem((IPattern)fp3);
        FactPattern fp4 = new FactPattern("Integer");
        fp4.setBoundName("$i");
        SingleFieldConstraint con4 = new SingleFieldConstraint();
        con4.setFieldType("Integer");
        con4.setFieldName("this");
        con4.setOperator("==");
        con4.setValue("123");
        con4.setConstraintValueType(1);
        fp4.addConstraint((FieldConstraint)con4);
        m.addLhsItem((IPattern)fp4);
        FactPattern fp5 = new FactPattern("String");
        fp5.setBoundName("$s");
        SingleFieldConstraint con5 = new SingleFieldConstraint();
        con5.setFieldType("String");
        con5.setFieldName("this");
        con5.setOperator("==");
        con5.setValue("hello");
        con5.setConstraintValueType(1);
        fp5.addConstraint((FieldConstraint)con5);
        m.addLhsItem((IPattern)fp5);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setBinding("$b");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setBinding("$f");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setBinding("$i");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setBinding("$s");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testRHSExecuteWorkItemWithMissingBindings1() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Person");
        fp1.setBoundName("$p");
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("String");
        con1.setFieldName("name");
        con1.setOperator("==");
        con1.setValue("Michael");
        con1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)con1);
        m.addLhsItem((IPattern)fp1);
        FactPattern fp2 = new FactPattern("Boolean");
        fp2.setBoundName("$b1");
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldType("Boolean");
        con2.setFieldName("this");
        con2.setOperator("==");
        con2.setValue("true");
        con2.setConstraintValueType(1);
        fp2.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)fp2);
        FactPattern fp3 = new FactPattern("Float");
        fp3.setBoundName("$f1");
        SingleFieldConstraint con3 = new SingleFieldConstraint();
        con3.setFieldType("Float");
        con3.setFieldName("this");
        con3.setOperator("==");
        con3.setValue("123.456f");
        con3.setConstraintValueType(1);
        fp3.addConstraint((FieldConstraint)con3);
        m.addLhsItem((IPattern)fp3);
        FactPattern fp4 = new FactPattern("Integer");
        fp4.setBoundName("$i1");
        SingleFieldConstraint con4 = new SingleFieldConstraint();
        con4.setFieldType("Integer");
        con4.setFieldName("this");
        con4.setOperator("==");
        con4.setValue("123");
        con4.setConstraintValueType(1);
        fp4.addConstraint((FieldConstraint)con4);
        m.addLhsItem((IPattern)fp4);
        FactPattern fp5 = new FactPattern("String");
        fp5.setBoundName("$s1");
        SingleFieldConstraint con5 = new SingleFieldConstraint();
        con5.setFieldType("String");
        con5.setFieldName("this");
        con5.setOperator("==");
        con5.setValue("hello");
        con5.setConstraintValueType(1);
        fp5.addConstraint((FieldConstraint)con5);
        m.addLhsItem((IPattern)fp5);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setBinding("$b");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setBinding("$f");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setBinding("$i");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setBinding("$s");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b2 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f2 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i2 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s2 );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testRHSExecuteWorkItemWithMissingBindings2() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Person");
        fp1.setBoundName("$p");
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("String");
        con1.setFieldName("name");
        con1.setOperator("==");
        con1.setValue("Michael");
        con1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)con1);
        m.addLhsItem((IPattern)fp1);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setBinding("$b2");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setBinding("$f2");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setBinding("$i2");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setBinding("$s2");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testRHSActionWorkItemSetFields() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Results");
        fp1.setBoundName("$r");
        m.addLhsItem((IPattern)fp1);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerResult");
        pwd.addResult((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringResult");
        pwd.addResult((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        ActionSetField asf = new ActionSetField();
        asf.setVariable("$r");
        ActionWorkItemFieldValue fv1 = new ActionWorkItemFieldValue("ResultsBooleanResult", "Boolean", "WorkItem", "BooleanResult", Boolean.class.getName());
        asf.addFieldValue((ActionFieldValue)fv1);
        ActionWorkItemFieldValue fv2 = new ActionWorkItemFieldValue("ResultsFloatResult", "Float", "WorkItem", "FloatResult", Float.class.getName());
        asf.addFieldValue((ActionFieldValue)fv2);
        ActionWorkItemFieldValue fv3 = new ActionWorkItemFieldValue("ResultsIntegerResult", "Integer", "WorkItem", "IntegerResult", Integer.class.getName());
        asf.addFieldValue((ActionFieldValue)fv3);
        ActionWorkItemFieldValue fv4 = new ActionWorkItemFieldValue("ResultsStringResult", "String", "WorkItem", "StringResult", String.class.getName());
        asf.addFieldValue((ActionFieldValue)fv4);
        m.addRhsItem((IAction)asf);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsBooleanResult( (java.lang.Boolean) wiWorkItem.getResult( \"BooleanResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsFloatResult( (java.lang.Float) wiWorkItem.getResult( \"FloatResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsIntegerResult( (java.lang.Integer) wiWorkItem.getResult( \"IntegerResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsStringResult( (java.lang.String) wiWorkItem.getResult( \"StringResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testRHSActionWorkItemInsertFacts() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerResult");
        pwd.addResult((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringResult");
        pwd.addResult((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        ActionInsertFact aif = new ActionInsertFact();
        aif.setBoundName("$r");
        aif.setFactType("Results");
        ActionWorkItemFieldValue fv1 = new ActionWorkItemFieldValue("ResultsBooleanResult", "Boolean", "WorkItem", "BooleanResult", Boolean.class.getName());
        aif.addFieldValue((ActionFieldValue)fv1);
        ActionWorkItemFieldValue fv2 = new ActionWorkItemFieldValue("ResultsFloatResult", "Float", "WorkItem", "FloatResult", Float.class.getName());
        aif.addFieldValue((ActionFieldValue)fv2);
        ActionWorkItemFieldValue fv3 = new ActionWorkItemFieldValue("ResultsIntegerResult", "Integer", "WorkItem", "IntegerResult", Integer.class.getName());
        aif.addFieldValue((ActionFieldValue)fv3);
        ActionWorkItemFieldValue fv4 = new ActionWorkItemFieldValue("ResultsStringResult", "String", "WorkItem", "StringResult", String.class.getName());
        aif.addFieldValue((ActionFieldValue)fv4);
        m.addRhsItem((IAction)aif);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.WorkItemManager wim = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.core.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.core.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("Results $r = new Results();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsBooleanResult( (java.lang.Boolean) wiWorkItem.getResult( \"BooleanResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsFloatResult( (java.lang.Float) wiWorkItem.getResult( \"FloatResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsIntegerResult( (java.lang.Integer) wiWorkItem.getResult( \"IntegerResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsStringResult( (java.lang.String) wiWorkItem.getResult( \"StringResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("insert( $r );") != -1 ? 1 : 0) != 0);
        this.checkMarshalling(null, m);
    }

    @Test
    public void testSubConstraints() {
        RuleModel m = new RuleModel();
        m.name = "test sub constraints";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        con2.setParent((FieldConstraint)con);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test sub constraints\"\tdialect \"mvel\"\n when      Person(field1.field2 == variableHere) then end";
        this.checkMarshalling(expected, m);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    @Test
    public void testReturnValueConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(3);
        con.setValue("someFunc(x)");
        con.setOperator("==");
        con.setFieldName("goo");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( goo == ( someFunc(x) ) ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testPredicateConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(5);
        con.setValue("field soundslike \"poo\"");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( eval( field soundslike \"poo\" ) ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testConnective() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("blah");
        con.setConnectives(new ConnectiveConstraint[1]);
        con.getConnectives()[0] = connective;
        m.addLhsItem((IPattern)p);
        String expected = "rule \"test literal strings\" \tdialect \"mvel\"\n when Person( field1 == goo  || == \"blah\" ) then end";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testInvalidComposite() throws Exception {
        RuleModel m = new RuleModel();
        CompositeFactPattern com = new CompositeFactPattern("not");
        m.addLhsItem((IPattern)com);
        String s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
        m.addLhsItem((IPattern)new CompositeFactPattern("or"));
        m.addLhsItem((IPattern)new CompositeFactPattern("exists"));
        s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void testAssertWithDSL() throws Exception {
        RuleModel m = new RuleModel();
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("I CAN HAS DSL");
        m.addRhsItem((IAction)sen);
        ActionInsertFact ins = new ActionInsertFact("Shizzle");
        ActionFieldValue val = new ActionFieldValue("goo", "42", "Numeric");
        ins.setFieldValues(new ActionFieldValue[1]);
        ins.getFieldValues()[0] = val;
        m.addRhsItem((IAction)ins);
        ActionInsertLogicalFact insL = new ActionInsertLogicalFact("Shizzle");
        ActionFieldValue valL = new ActionFieldValue("goo", "42", "Numeric");
        insL.setFieldValues(new ActionFieldValue[1]);
        insL.getFieldValues()[0] = valL;
        m.addRhsItem((IAction)insL);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf(">insert") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf(">insertLogical") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultMVEL() {
        RuleModel m = new RuleModel();
        String s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        m.addAttribute(new RuleAttribute("dialect", "goober"));
        s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertFalse((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("goober") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLockOnActive() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("lock-on-active", "true"));
        m.addAttribute(new RuleAttribute("auto-focus", "true"));
        m.addAttribute(new RuleAttribute("duration", "42"));
        String s = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("lock-on-active true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("auto-focus true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("duration 42") > -1 ? 1 : 0) != 0);
        this.checkMarshalling(s, m);
    }

    @Test
    public void testAddGlobal() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\n\t\tresults.add(f);\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd add = new ActionGlobalCollectionAdd();
        add.setGlobalName("results");
        add.setFactName("f");
        m.addRhsItem((IAction)add);
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testCompositeOrConstraints() {
        RuleModel m = new RuleModel();
        m.name = "or composite";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"or composite\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" || fooField != null || fooField.barField == \"barValue\" )\nthen\ninsert( new Whee() );\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testCompositeOrConstraintsComplex() {
        RuleModel m = new RuleModel();
        m.name = "or composite complex";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        SingleFieldConstraint sfc4 = new SingleFieldConstraint();
        sfc4.setFactType("Goober");
        sfc4.setFieldName("zooField");
        sfc4.setFieldType("String");
        sfc4.setConstraintValueType(1);
        sfc4.setValue("zooValue");
        sfc4.setOperator("==");
        p.addConstraint((FieldConstraint)sfc4);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String expected = "rule \"or composite complex\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" || fooField != null || fooField.barField == \"barValue\", zooField == \"zooValue\" )\nthen\ninsert( new Whee() );\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testCompositeAndConstraints() {
        RuleModel m = new RuleModel();
        m.name = "and composite";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("&&");
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String expected = "rule \"and composite\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" && fooField != null && fooField.barField == \"barValue\" )\nthen\ninsert( new Whee() );\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testCompositeAndConstraintsComplex() {
        RuleModel m = new RuleModel();
        m.name = "and composite complex";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("&&");
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc1.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        SingleFieldConstraint sfc4 = new SingleFieldConstraint();
        sfc4.setFactType("Goober");
        sfc4.setFieldName("zooField");
        sfc4.setFieldType("String");
        sfc4.setConstraintValueType(1);
        sfc4.setValue("zooValue");
        sfc4.setOperator("==");
        p.addConstraint((FieldConstraint)sfc4);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"and composite complex\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" && fooField != null && fooField.barField == \"barValue\", zooField == \"zooValue\" )\nthen\ninsert( new Whee() );\nend";
        this.checkMarshalling(expected, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSSetMethodCallsMethodMVEL() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS SetMethodCallsMethod";
            m.addAttribute(new RuleAttribute("dialect", "mvel"));
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            m.addLhsItem((IPattern)p);
            ActionCallMethod acm = new ActionCallMethod();
            acm.setMethodName("method");
            acm.setVariable("$p");
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f1", "String", "String"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f2", "true", "Boolean"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f3", "31-Jan-2012", "Date"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f4", "100", "Integer"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f5", "100", "BigDecimal"));
            m.addRhsItem((IAction)acm);
            String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.method( \"String\", true, sdf.parse(\"31-Jan-2012\"), 100, 100B );") != -1 ? 1 : 0) != 0);
            this.checkMarshalling(null, m);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSSetMethodCallsMethodJava() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS SetMethodCallsMethod";
            m.addAttribute(new RuleAttribute("dialect", "java"));
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            m.addLhsItem((IPattern)p);
            ActionCallMethod acm = new ActionCallMethod();
            acm.setMethodName("method");
            acm.setVariable("$p");
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f1", "String", "String"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f2", "true", "Boolean"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f3", "31-Jan-2012", "Date"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f4", "100", "Integer"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f5", "100", "BigDecimal"));
            m.addRhsItem((IAction)acm);
            String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.method( \"String\", true, sdf.parse(\"31-Jan-2012\"), 100, new java.math.BigDecimal(\"100\") );") != -1 ? 1 : 0) != 0);
            this.checkMarshalling(null, m);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    @Test
    public void testFromAccumulateWithEmbeddedFromEntryPoint() {
        RuleModel m = new RuleModel();
        m.name = "r1";
        SingleFieldConstraint sfc = new SingleFieldConstraint("bar");
        sfc.setFactType("Integer");
        sfc.setFieldBinding("$a");
        sfc.setOperator("==");
        sfc.setValue("777");
        FactPattern fp = new FactPattern("Foo");
        fp.addConstraint((FieldConstraint)sfc);
        FromEntryPointFactPattern fep = new FromEntryPointFactPattern();
        fep.setEntryPointName("ep");
        fep.setFactPattern(fp);
        FromAccumulateCompositeFactPattern fac = new FromAccumulateCompositeFactPattern();
        fac.setSourcePattern((IPattern)fep);
        fac.setFactPattern(new FactPattern("java.util.List"));
        fac.setFunction("max($a)");
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1\"\ndialect \"mvel\"\nwhen\njava.util.List( ) from accumulate ( Foo( $a : bar == 777 ) from entry-point \"ep\", \nmax($a))\nthen\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testFromCollectWithEmbeddedFromEntryPoint() {
        RuleModel m = new RuleModel();
        m.name = "r1";
        SingleFieldConstraint sfc = new SingleFieldConstraint("bar");
        sfc.setFactType("Integer");
        sfc.setFieldBinding("$a");
        sfc.setOperator("==");
        sfc.setValue("777");
        FactPattern fp = new FactPattern("Foo");
        fp.addConstraint((FieldConstraint)sfc);
        FromEntryPointFactPattern fep = new FromEntryPointFactPattern();
        fep.setEntryPointName("ep");
        fep.setFactPattern(fp);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fep);
        fac.setFactPattern(new FactPattern("java.util.List"));
        m.addLhsItem((IPattern)fac);
        String expected = "rule \"r1\"\ndialect \"mvel\"\nwhen\njava.util.List( ) from collect ( Foo( $a : bar == 777 ) from entry-point \"ep\" ) \nthen\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testCompositeFactPatternWithFrom() {
        RuleModel m = new RuleModel();
        m.name = "model";
        FactPattern fp1 = new FactPattern("Data");
        fp1.setBoundName("$d");
        m.addLhsItem((IPattern)fp1);
        FactPattern fp2 = new FactPattern("Person");
        FromCompositeFactPattern ffp1 = new FromCompositeFactPattern();
        ffp1.setExpression(new ExpressionFormLine((ExpressionPart)new ExpressionVariable(fp1.getBoundName(), fp1.getFactType())));
        ffp1.setFactPattern(fp2);
        m.addLhsItem((IPattern)ffp1);
        String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"model\"\ndialect \"mvel\"\nwhen\n$d : Data( )\n(Person( ) from $d)\n\nthen\nend\n";
        this.assertEqualsIgnoreWhitespace("rule \"model\"\ndialect \"mvel\"\nwhen\n$d : Data( )\n(Person( ) from $d)\n\nthen\nend\n", actual);
    }

    @Test
    public void testCompositeFactPatternWithFromWithDSL() {
        RuleModel m = new RuleModel();
        m.name = "model";
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("A DSL phrase");
        m.addLhsItem((IPattern)sen);
        FactPattern fp1 = new FactPattern("Data");
        fp1.setBoundName("$d");
        m.addLhsItem((IPattern)fp1);
        CompositeFactPattern cp = new CompositeFactPattern("not");
        FactPattern fp2 = new FactPattern("Person");
        FromCompositeFactPattern ffp1 = new FromCompositeFactPattern();
        ffp1.setExpression(new ExpressionFormLine((ExpressionPart)new ExpressionVariable(fp1.getBoundName(), fp1.getFactType())));
        ffp1.setFactPattern(fp2);
        cp.addFactPattern((IFactPattern)ffp1);
        m.addLhsItem((IPattern)cp);
        String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"model\"\ndialect \"mvel\"\nwhen\nA DSL phrase\n>$d : Data( )\n>not ( Person( ) from $d\n)\nthen\nend\n";
        this.assertEqualsIgnoreWhitespace("rule \"model\"\ndialect \"mvel\"\nwhen\nA DSL phrase\n>$d : Data( )\n>not ( Person( ) from $d\n)\nthen\nend\n", actual);
    }

    @Test
    public void testImports() {
        String drl = "import java.util.ArrayList;\nrule \"r0\"\ndialect \"mvel\"when\nthen\nend\n";
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("import java.util.ArrayList;\nrule \"r0\"\ndialect \"mvel\"when\nthen\nend\n", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.getImports().getImports().size());
        Assert.assertEquals((Object)"java.util.ArrayList", (Object)((Import)m.getImports().getImports().get(0)).getType());
    }

    @Test
    public void testActionSetFieldValue() {
        String drl = "rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\n$a.setName( \"Michael\" );\nend\n";
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\n$a.setName( \"Michael\" );\nend\n", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern p = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"$a", (Object)p.getBoundName());
        Assert.assertEquals((Object)"Applicant", (Object)p.getFactType());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionSetField));
        ActionSetField a = (ActionSetField)m.rhs[0];
        Assert.assertEquals((Object)"$a", (Object)a.getVariable());
        Assert.assertEquals((long)1L, (long)a.getFieldValues().length);
        ActionFieldValue fv = a.getFieldValues()[0];
        Assert.assertEquals((Object)"name", (Object)fv.getField());
        Assert.assertEquals((Object)"Michael", (Object)fv.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActionSetFieldValueWithDSL() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            String dsl = "There is an Applicant";
            String dslDefinition = "[when]There is an Applicant=$a : Applicant();";
            RuleModel m = new RuleModel();
            m.name = "r0";
            DSLSentence sen = new DSLSentence();
            sen.setDefinition("There is an Applicant");
            m.addLhsItem((IPattern)sen);
            ActionInsertFact aif = new ActionInsertFact("Applicant");
            aif.addFieldValue(new ActionFieldValue("applicationDate", "13-Mar-2017", "Date"));
            m.addRhsItem((IAction)aif);
            String expected = "rule \"r0\"\ndialect \"mvel\"\nwhen\nThere is an Applicant\nthen\n>java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");\n>Applicant fact0 = new Applicant();\n>fact0.setApplicationDate( sdf.parse(\"13-Mar-2017\") );\n>insert( fact0 );\nend";
            String actual = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
            this.assertEqualsIgnoreWhitespace("rule \"r0\"\ndialect \"mvel\"\nwhen\nThere is an Applicant\nthen\n>java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");\n>Applicant fact0 = new Applicant();\n>fact0.setApplicationDate( sdf.parse(\"13-Mar-2017\") );\n>insert( fact0 );\nend", actual);
            PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
            RuleModel m2 = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(actual, Collections.emptyList(), dmo, new String[]{"[when]There is an Applicant=$a : Applicant();"});
            Assert.assertNotNull((Object)m2);
            Assert.assertEquals((long)1L, (long)m.lhs.length);
            DSLSentence dslSentence = (DSLSentence)m.lhs[0];
            Assert.assertEquals((Object)"There is an Applicant", (Object)dslSentence.getDefinition());
            Assert.assertEquals((long)0L, (long)dslSentence.getValues().size());
            Assert.assertEquals((long)1L, (long)m2.rhs.length);
            Assert.assertTrue((boolean)(m2.rhs[0] instanceof ActionInsertFact));
            ActionInsertFact a = (ActionInsertFact)m2.rhs[0];
            Assert.assertEquals((Object)"Applicant", (Object)a.getFactType());
            Assert.assertEquals((long)1L, (long)a.getFieldValues().length);
            ActionFieldValue afv = a.getFieldValues()[0];
            Assert.assertEquals((Object)"applicationDate", (Object)afv.getField());
            Assert.assertEquals((Object)"13-Mar-2017", (Object)afv.getValue());
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    @Test
    public void testActionCallMethod() {
        String drl = "rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\n$a.addName( \"Michael\" );\nend\n";
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\n$a.addName( \"Michael\" );\nend\n", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern p = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"$a", (Object)p.getBoundName());
        Assert.assertEquals((Object)"Applicant", (Object)p.getFactType());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionCallMethod));
        ActionCallMethod a = (ActionCallMethod)m.rhs[0];
        Assert.assertEquals((Object)"$a", (Object)a.getVariable());
        Assert.assertEquals((Object)"addName", (Object)a.getMethodName());
        Assert.assertEquals((long)1L, (long)a.getFieldValues().length);
        ActionFieldFunction fv = a.getFieldValue(0);
        Assert.assertEquals((Object)"Michael", (Object)fv.getValue());
    }

    @Test
    public void testAddToGlobalCollection() {
        String global = "global java.util.ArrayList list";
        String drl = "rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\nlist.add( $a );\nend\n";
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Arrays.asList(global), (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class));
        Assert.assertNotNull((Object)m);
        this.assertEqualsIgnoreWhitespace(drl, RuleModelDRLPersistenceImpl.getInstance().marshal(m));
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern p = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"$a", (Object)p.getBoundName());
        Assert.assertEquals((Object)"Applicant", (Object)p.getFactType());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionGlobalCollectionAdd));
        ActionGlobalCollectionAdd a = (ActionGlobalCollectionAdd)m.rhs[0];
        Assert.assertEquals((Object)"list", (Object)a.getGlobalName());
        Assert.assertEquals((Object)"$a", (Object)a.getFactName());
    }

    @Test
    public void testFreeFormatDRLCondition() {
        String drl = "rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nHere's something typed by the user as free-format DRL\n$b : Bananna( )\nthen\nend\n";
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nHere's something typed by the user as free-format DRL\n$b : Bananna( )\nthen\nend\n", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)3L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern fp1 = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"$a", (Object)fp1.getBoundName());
        Assert.assertEquals((Object)"Applicant", (Object)fp1.getFactType());
        Assert.assertTrue((boolean)(m.lhs[1] instanceof FreeFormLine));
        FreeFormLine ffl = (FreeFormLine)m.lhs[1];
        Assert.assertEquals((Object)"Here's something typed by the user as free-format DRL", (Object)ffl.getText());
        Assert.assertTrue((boolean)(m.lhs[2] instanceof FactPattern));
        FactPattern fp2 = (FactPattern)m.lhs[2];
        Assert.assertEquals((Object)"$b", (Object)fp2.getBoundName());
        Assert.assertEquals((Object)"Bananna", (Object)fp2.getFactType());
    }

    @Test
    public void testFreeFormatDRLAction() {
        String drl = "rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\n$a.setName( \"Michael\" );\nHere's something typed by the user as free-format DRL\n$a.setAge( 40 );\nend\n";
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("rule \"r0\"\ndialect \"mvel\"\nwhen\n$a : Applicant( )\nthen\n$a.setName( \"Michael\" );\nHere's something typed by the user as free-format DRL\n$a.setAge( 40 );\nend\n", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FreeFormLine));
        FreeFormLine ffl1 = (FreeFormLine)m.lhs[0];
        Assert.assertEquals((Object)"$a : Applicant( )", (Object)ffl1.getText());
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof FreeFormLine));
        FreeFormLine ffl2 = (FreeFormLine)m.rhs[0];
        Assert.assertEquals((Object)"$a.setName( \"Michael\" );\nHere's something typed by the user as free-format DRL\n$a.setAge( 40 );", (Object)ffl2.getText());
    }

    @Test
    public void testGenerateEmptyXML() {
        RuleModelPersistence p = RuleModelDRLPersistenceImpl.getInstance();
        String drl = p.marshal(new RuleModel());
        Assert.assertNotNull((Object)drl);
        Assert.assertFalse((boolean)drl.equals(""));
    }

    @Test
    public void testBasics2() {
        RuleModelPersistence p = RuleModelDRLPersistenceImpl.getInstance();
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd ag = new ActionGlobalCollectionAdd();
        ag.setFactName("x");
        ag.setGlobalName("g");
        m.addRhsItem((IAction)ag);
        m.name = "my rule";
        String drl = p.marshal(m);
        Assert.assertTrue((drl.indexOf("Person( )") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Accident( )") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("no-loop true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("org.kie") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("g.add( x );") > -1 ? 1 : 0) != 0);
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel rm_ = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, dmo);
        Assert.assertEquals((long)2L, (long)rm_.rhs.length);
    }

    @Test
    public void testMoreComplexRendering2() {
        RuleModel m;
        RuleModelPersistence p = RuleModelDRLPersistenceImpl.getInstance();
        String drl = p.marshal(m = this.getComplexModel());
        Assert.assertTrue((drl.indexOf("org.kie") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRoundTrip() {
        RuleModel m = this.getComplexModel();
        String drl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m2 = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, Collections.EMPTY_LIST, dmo, new String[0]);
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((Object)m.name, (Object)m2.name);
        Assert.assertEquals((long)m.lhs.length, (long)m2.lhs.length);
        Assert.assertEquals((long)m.rhs.length, (long)m2.rhs.length);
        Assert.assertEquals((long)1L, (long)m.attributes.length);
        RuleAttribute at = m.attributes[0];
        Assert.assertEquals((Object)"no-loop", (Object)at.getAttributeName());
        Assert.assertEquals((Object)"true", (Object)at.getValue());
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(m2);
        Assert.assertEquals((Object)drl, (Object)drl2);
    }

    @Test
    public void testCompositeConstraintsRoundTrip() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.setBoundName("p1");
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.setCompositeJunctionType("||");
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("goo");
        X.setConstraintValueType(1);
        X.setValue("foo");
        X.setOperator("==");
        X.setConnectives(new ConnectiveConstraint[1]);
        X.getConnectives()[0] = new ConnectiveConstraint();
        X.getConnectives()[0].setConstraintValueType(1);
        X.getConnectives()[0].setOperator("|| ==");
        X.getConnectives()[0].setValue("bar");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("goo2");
        Y.setConstraintValueType(1);
        Y.setValue("foo");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.setCompositeJunctionType("&&");
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.setFieldName("goo");
        Q1.setOperator("==");
        Q1.setValue("whee");
        Q1.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.setFieldName("gabba");
        Q2.setOperator("==");
        Q2.setValue("whee");
        Q2.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.setFieldName("goo3");
        Z.setConstraintValueType(1);
        Z.setValue("foo");
        Z.setOperator("==");
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String drl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m2 = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((Object)"with composite", (Object)m2.name);
        Assert.assertEquals((long)m2.lhs.length, (long)m.lhs.length);
        Assert.assertEquals((long)m2.rhs.length, (long)m.rhs.length);
    }

    @Test
    public void testFreeFormLine() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.setText("Person()");
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.setText("fun()");
        m.rhs[0] = fr;
        String drl = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        Assert.assertNotNull((Object)drl);
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m_ = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, Collections.EMPTY_LIST, dmo);
        Assert.assertEquals((long)1L, (long)m_.lhs.length);
        Assert.assertEquals((long)1L, (long)m_.rhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)m_.lhs[0]).getFactType());
        Assert.assertEquals((Object)"fun()", (Object)((FreeFormLine)m_.rhs[0]).getText());
    }

    private RuleModel getComplexModel() {
        RuleModel m = new RuleModel();
        m.name = "complex";
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFactType("Person");
        con.setFieldBinding("f1");
        con.setFieldName("age");
        con.setOperator("<");
        con.setValue("42");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern((IFactPattern)new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField set = new ActionUpdateField();
        set.setVariable("p1");
        set.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        m.addRhsItem((IAction)set);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("Send an email to {administrator}");
        m.addRhsItem((IAction)sen);
        return m;
    }

    @Test
    public void testLoadEmpty() {
        PackageDataModelOracle dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
        m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("", Collections.EMPTY_LIST, dmo);
        Assert.assertNotNull((Object)m);
    }

    @Test
    public void testIncompleteFieldConstraintStringWithNull() {
        String expected = "rule \"rule\" \n  dialect \"mvel\"\n  when\n    Message( text == \"\" )\n  then\nend\n";
        RuleModel m = new RuleModel();
        m.name = "rule";
        FactPattern pat = new FactPattern("Message");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("text");
        con.setOperator("==");
        con.setValue(null);
        con.setFieldType("String");
        con.setConstraintValueType(1);
        pat.addConstraint((FieldConstraint)con);
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testIncompleteFieldConstraintStringWithNonNull() {
        String expected = "rule \"rule\" \n  dialect \"mvel\"\n  when\n    Message( text == \"\" )\n  then\nend\n";
        RuleModel m = new RuleModel();
        m.name = "rule";
        FactPattern pat = new FactPattern("Message");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("text");
        con.setOperator("==");
        con.setValue("");
        con.setFieldType("String");
        con.setConstraintValueType(1);
        pat.addConstraint((FieldConstraint)con);
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testIncompleteFieldConstraintNonStringWithNull() {
        String expected = "rule \"rule\" \n  dialect \"mvel\"\n  when\n    Message()\n  then\nend\n";
        RuleModel m = new RuleModel();
        m.name = "rule";
        FactPattern pat = new FactPattern("Message");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("number");
        con.setOperator("==");
        con.setValue(null);
        con.setFieldType("Integer");
        con.setConstraintValueType(1);
        pat.addConstraint((FieldConstraint)con);
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testIncompleteFieldConstraintNonStringWithNonNull() {
        String expected = "rule \"rule\" \n  dialect \"mvel\"\n  when\n    Message()\n  then\nend\n";
        RuleModel m = new RuleModel();
        m.name = "rule";
        FactPattern pat = new FactPattern("Message");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("number");
        con.setOperator("==");
        con.setValue("");
        con.setFieldType("Integer");
        con.setConstraintValueType(1);
        pat.addConstraint((FieldConstraint)con);
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testRHSFactBindingZeroBound() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("dialect", "mvel"));
        m.name = "test";
        ActionInsertFact ai0 = new ActionInsertFact("Person");
        ai0.addFieldValue(new ActionFieldValue("field1", "55", "Long"));
        ActionInsertFact ai1 = new ActionInsertFact("Person");
        ai1.addFieldValue(new ActionFieldValue("field1", "55", "Long"));
        m.addRhsItem((IAction)ai0);
        m.addRhsItem((IAction)ai1);
        String expected = "rule \"test\" \ndialect \"mvel\"\nwhenthen \nPerson fact0 = new Person(); \nfact0.setField1( 55 ); \ninsert( fact0 ); \nPerson fact1 = new Person(); \nfact1.setField1( 55 ); \ninsert( fact1 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testRHSFactBindingFirstBound() {
        RuleModel m = new RuleModel();
        m.name = "test";
        ActionInsertFact ai0 = new ActionInsertFact("Person");
        ai0.setBoundName("fact0");
        ai0.addFieldValue(new ActionFieldValue("field1", "55", "Long"));
        ActionInsertFact ai1 = new ActionInsertFact("Person");
        ai1.addFieldValue(new ActionFieldValue("field1", "55", "Long"));
        m.addRhsItem((IAction)ai0);
        m.addRhsItem((IAction)ai1);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"test\" \ndialect \"mvel\"\nwhenthen \nPerson fact0 = new Person(); \nfact0.setField1( 55 ); \ninsert( fact0 ); \nPerson fact1 = new Person(); \nfact1.setField1( 55 ); \ninsert( fact1 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testRHSFactBindingLastBound() {
        RuleModel m = new RuleModel();
        m.name = "test";
        ActionInsertFact ai0 = new ActionInsertFact("Person");
        ai0.addFieldValue(new ActionFieldValue("field1", "55", "Long"));
        ActionInsertFact ai1 = new ActionInsertFact("Person");
        ai1.setBoundName("fact0");
        ai1.addFieldValue(new ActionFieldValue("field1", "55", "Long"));
        m.addRhsItem((IAction)ai0);
        m.addRhsItem((IAction)ai1);
        String result = RuleModelDRLPersistenceImpl.getInstance().marshal(m);
        String expected = "rule \"test\" \ndialect \"mvel\"\nwhenthen \nPerson fact1 = new Person(); \nfact1.setField1( 55 ); \ninsert( fact1 ); \nPerson fact0 = new Person(); \nfact0.setField1( 55 ); \ninsert( fact0 ); \nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testEmptyFreeForm() {
        RuleModel m = new RuleModel();
        m.name = "Empty FreeFormLine";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        m.rhs[0] = fr;
        String drl = this.ruleModelPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
    }

    @Test
    public void testRHSSetFieldWithVariable() {
        RuleModel m = new RuleModel();
        m.name = "variable";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        con.setFieldBinding("$f");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ActionFieldValue acv = new ActionFieldValue("field1", "=$f", "Object");
        acv.setNature(2);
        ai.addFieldValue(acv);
        m.addRhsItem((IAction)ai);
        String expected = "rule \"variable\"\ndialect \"mvel\"\nwhen\nPerson( $f : field1 == 44 )\nthen\nPerson fact0 = new Person();\nfact0.setField1( $f );\ninsert( fact0 );\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSFormula() {
        RuleModel m = new RuleModel();
        m.name = "test";
        FactPattern p = new FactPattern("Number");
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setValue("true");
        con1.setConstraintValueType(5);
        p.addConstraint((FieldConstraint)con1);
        SingleFieldConstraintEBLeftSide con2 = new SingleFieldConstraintEBLeftSide();
        con2.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con2.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionMethod("intValue", "int", "Integer"));
        con2.setConstraintValueType(1);
        con2.setOperator("==");
        con2.setValue("0");
        p.addConstraint((FieldConstraint)con2);
        String expected = "rule \"test\"\ndialect \"mvel\"\nwhen\nNumber( eval( true ), intValue() == 0 )\nthen\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testLHSReturnType() {
        RuleModel m = new RuleModel();
        m.name = "test";
        FactPattern p = new FactPattern("Number");
        m.addLhsItem((IPattern)p);
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("Integer");
        con1.setFieldName("this");
        con1.setOperator("!= null");
        con1.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con1);
        SingleFieldConstraintEBLeftSide con2 = new SingleFieldConstraintEBLeftSide();
        con2.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p.getFactType()));
        con2.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionMethod("intValue", "int", "Integer"));
        con2.setConstraintValueType(1);
        con2.setOperator("==");
        con2.setValue("0");
        p.addConstraint((FieldConstraint)con2);
        String expected = "rule \"test\"\ndialect \"mvel\"\nwhen\nNumber( this != null, intValue() == 0 )\nthen\nend";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testRHSChangeMultipleFieldsModifyBoth() {
        String expected = "rule \"my rule\" \n  dialect \"mvel\"\n  when\n    $p : Person()\n  then\n    modify( $p ) {\n      setName( \"Fred\" ),\n      setAge( 55 )\n    }\nend\n";
        RuleModel m = new RuleModel();
        FactPattern factPattern = new FactPattern();
        factPattern.setFactType("Person");
        factPattern.setBoundName("$p");
        m.lhs = new IPattern[]{factPattern};
        ActionUpdateField auf = new ActionUpdateField();
        auf.setVariable("$p");
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setField("name");
        afv1.setType("String");
        afv1.setNature(1);
        afv1.setValue("Fred");
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setField("age");
        afv2.setType("Integer");
        afv2.setNature(1);
        afv2.setValue("55");
        auf.setFieldValues(new ActionFieldValue[]{afv1, afv2});
        m.rhs = new IAction[]{auf};
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testRHSChangeMultipleFieldsModifyOneUpdateOther() {
        String expected = "rule \"my rule\" \n  dialect \"mvel\"\n  when\n    $p : Person()\n  then\n    modify( $p ) {\n      setName( \"Fred\" )\n    }\n  $p.setAge( 55 );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern factPattern = new FactPattern();
        factPattern.setFactType("Person");
        factPattern.setBoundName("$p");
        m.lhs = new IPattern[]{factPattern};
        ActionUpdateField auf = new ActionUpdateField();
        auf.setVariable("$p");
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setField("name");
        afv1.setType("String");
        afv1.setNature(1);
        afv1.setValue("Fred");
        auf.setFieldValues(new ActionFieldValue[]{afv1});
        ActionSetField asf = new ActionSetField();
        asf.setVariable("$p");
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setField("age");
        afv2.setType("Integer");
        afv2.setNature(1);
        afv2.setValue("55");
        asf.setFieldValues(new ActionFieldValue[]{afv2});
        m.rhs = new IAction[]{auf, asf};
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }

    @Test
    public void testRHSChangeMultipleFieldsBlockModify() {
        String expected = "rule \"my rule\" \n  dialect \"mvel\"\n  when\n    $p : Person()\n  then\n    modify( $p ) {\n      setName( \"Fred\" ),\n      setAge( 55 )\n    }\n    $p.setGender( \"X\" );end\n";
        RuleModel m = new RuleModel();
        FactPattern factPattern = new FactPattern();
        factPattern.setFactType("Person");
        factPattern.setBoundName("$p");
        m.lhs = new IPattern[]{factPattern};
        ActionUpdateField auf1 = new ActionUpdateField();
        auf1.setVariable("$p");
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setField("name");
        afv1.setType("String");
        afv1.setNature(1);
        afv1.setValue("Fred");
        auf1.setFieldValues(new ActionFieldValue[]{afv1});
        ActionSetField asf = new ActionSetField();
        asf.setVariable("$p");
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setField("gender");
        afv2.setType("String");
        afv2.setNature(1);
        afv2.setValue("X");
        asf.setFieldValues(new ActionFieldValue[]{afv2});
        ActionUpdateField auf2 = new ActionUpdateField();
        auf2.setVariable("$p");
        ActionFieldValue afv3 = new ActionFieldValue();
        afv3.setField("age");
        afv3.setType("Integer");
        afv3.setNature(1);
        afv3.setValue("55");
        auf2.setFieldValues(new ActionFieldValue[]{afv3});
        m.rhs = new IAction[]{auf1, asf, auf2};
        m.name = "my rule";
        this.checkMarshalling(expected, m);
    }
}

