/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.oracle;

import java.util.HashMap;
import org.drools.workbench.models.commons.backend.oracle.ProjectDataModelOracleUtils;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ProjectDataModelOracleUtilsTest {
    @Test
    public void getFieldFullyQualifiedClassNameTest() {
        ProjectDataModelOracle mockedDMO = (ProjectDataModelOracle)Mockito.mock(ProjectDataModelOracle.class);
        HashMap<String, ModelField[]> projectModelFields = new HashMap<String, ModelField[]>();
        Mockito.when((Object)mockedDMO.getProjectModelFields()).thenReturn(projectModelFields);
        String fullyQualifiedClassName = this.getClass().getName();
        String fieldName = "nonExistentField";
        String fqnFieldClassName = ProjectDataModelOracleUtils.getFieldFullyQualifiedClassName((ProjectDataModelOracle)mockedDMO, (String)fullyQualifiedClassName, (String)fieldName);
        Assert.assertNull((String)"Expected a null FQN field class name", (Object)fqnFieldClassName);
        projectModelFields.put(fullyQualifiedClassName, new ModelField[]{new ModelField("existentField", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, null)});
        Mockito.when((Object)mockedDMO.getProjectModelFields()).thenReturn(projectModelFields);
        fqnFieldClassName = ProjectDataModelOracleUtils.getFieldFullyQualifiedClassName((ProjectDataModelOracle)mockedDMO, (String)fullyQualifiedClassName, (String)fieldName);
        Assert.assertNull((String)"Expected a null FQN field class name", (Object)fqnFieldClassName);
        fieldName = "testField";
        String fieldType = "org.acme.test.field.type";
        projectModelFields.put(fullyQualifiedClassName, new ModelField[]{new ModelField("existentField", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, null), new ModelField(fieldName, fieldType, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.ACCESSOR, null)});
        Mockito.when((Object)mockedDMO.getProjectModelFields()).thenReturn(projectModelFields);
        fqnFieldClassName = ProjectDataModelOracleUtils.getFieldFullyQualifiedClassName((ProjectDataModelOracle)mockedDMO, (String)fullyQualifiedClassName, (String)fieldName);
        Assert.assertEquals((String)"Expected a null FQN field class name", (Object)fieldType, (Object)fqnFieldClassName);
    }
}

