/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class BaseRuleModelTest {
    protected PackageDataModelOracle dmo;
    protected Map<String, ModelField[]> packageModelFields = new HashMap<String, ModelField[]>();
    protected Map<String, String[]> projectJavaEnumDefinitions = new HashMap<String, String[]>();
    protected Map<String, List<MethodInfo>> projectMethodInformation = new HashMap<String, List<MethodInfo>>();

    @Before
    public void setUp() throws Exception {
        this.dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)this.dmo.getProjectModelFields()).thenReturn(this.packageModelFields);
        Mockito.when((Object)this.dmo.getProjectJavaEnumDefinitions()).thenReturn(this.projectJavaEnumDefinitions);
        Mockito.when((Object)this.dmo.getProjectMethodInformation()).thenReturn(this.projectMethodInformation);
    }

    @After
    public void cleanUp() throws Exception {
        this.packageModelFields.clear();
        this.projectJavaEnumDefinitions.clear();
        this.projectMethodInformation.clear();
    }

    protected void addModelField(String factName, String fieldName, String clazz, String type) {
        ModelField[] modelFields = new ModelField[]{new ModelField(fieldName, clazz, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type)};
        if (this.packageModelFields.containsKey(factName)) {
            ArrayList<Object> existingModelFields = new ArrayList<Object>(Arrays.asList((Object[])this.packageModelFields.get(factName)));
            existingModelFields.add(modelFields[0]);
            modelFields = existingModelFields.toArray(modelFields);
        }
        this.packageModelFields.put(factName, modelFields);
    }

    protected void addJavaEnumDefinition(String factName, String fieldName, String[] values) {
        String key = factName + "#" + fieldName;
        this.projectJavaEnumDefinitions.put(key, values);
    }

    protected void addMethodInformation(String factName, String name, List<String> params, String returnType, String parametricReturnType, String genericType) {
        MethodInfo mi = new MethodInfo(name, params, returnType, parametricReturnType, genericType);
        List<MethodInfo> existingMethodInfo = this.projectMethodInformation.get(factName);
        if (existingMethodInfo == null) {
            existingMethodInfo = new ArrayList<MethodInfo>();
            this.projectMethodInformation.put(factName, existingMethodInfo);
        }
        existingMethodInfo.add(mi);
    }
}

