/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import java.util.Arrays;
import java.util.Collections;
import org.drools.workbench.models.commons.backend.oracle.PackageDataModelOracleImpl;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.commons.backend.rule.actions.TestIAction;
import org.drools.workbench.models.commons.backend.rule.extensions.TestIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.extensions.TestIActionPersistenceExtensionCopy;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.junit.Assert;
import org.junit.Test;

public class RuleModelDRLPersistenceExtensionsTest {
    private static final String DRL_RULE = "rule \"TestIAction rule\"\n\tdialect \"mvel\"\n\twhen\n\tthen\n\t\ttestIAction();\nend\n";
    private static final String DSL_RULE = "rule \"TestIAction rule\"\n\tdialect \"mvel\"\n\twhen\n\tthen\n\t\t>testIAction();\nend\n";

    @Test
    public void unmarshalWithoutExtensions() {
        RuleModel ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshal(DRL_RULE, Collections.emptyList(), (PackageDataModelOracle)new PackageDataModelOracleImpl());
        Assert.assertEquals((long)1L, (long)ruleModel.rhs.length);
        IAction iAction = ruleModel.rhs[0];
        Assert.assertTrue((boolean)(iAction instanceof FreeFormLine));
    }

    @Test
    public void unmarshalWithExtensions() {
        RuleModel ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshal(DRL_RULE, Collections.emptyList(), (PackageDataModelOracle)new PackageDataModelOracleImpl(), Arrays.asList(new TestIActionPersistenceExtension()));
        Assert.assertEquals((long)1L, (long)ruleModel.rhs.length);
        IAction iAction = ruleModel.rhs[0];
        Assert.assertTrue((boolean)(iAction instanceof TestIAction));
    }

    @Test(expected=RuntimeException.class)
    public void unmarshalWithAmbiguousExtensions() {
        RuleModelDRLPersistenceImpl.getInstance().unmarshal(DRL_RULE, Collections.emptyList(), (PackageDataModelOracle)new PackageDataModelOracleImpl(), Arrays.asList(new TestIActionPersistenceExtension(), new TestIActionPersistenceExtensionCopy()));
    }

    @Test
    public void unmarshalDSLWithoutExtensions() {
        RuleModel ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(DSL_RULE, Collections.emptyList(), (PackageDataModelOracle)new PackageDataModelOracleImpl(), new String[0]);
        Assert.assertEquals((long)1L, (long)ruleModel.rhs.length);
        IAction iAction = ruleModel.rhs[0];
        Assert.assertTrue((boolean)(iAction instanceof FreeFormLine));
    }

    @Test
    public void unmarshalDSLWithExtensions() {
        RuleModel ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(DSL_RULE, Collections.emptyList(), (PackageDataModelOracle)new PackageDataModelOracleImpl(), Arrays.asList(new TestIActionPersistenceExtension()), new String[0]);
        Assert.assertEquals((long)1L, (long)ruleModel.rhs.length);
        IAction iAction = ruleModel.rhs[0];
        Assert.assertTrue((boolean)(iAction instanceof TestIAction));
    }

    @Test(expected=RuntimeException.class)
    public void unmarshalDSLWithAmbiguousExtensions() {
        RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(DRL_RULE, Collections.emptyList(), (PackageDataModelOracle)new PackageDataModelOracleImpl(), Arrays.asList(new TestIActionPersistenceExtension(), new TestIActionPersistenceExtensionCopy()), new String[0]);
    }
}

