/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule.context;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.commons.backend.rule.context.LHSGeneratorContext;
import org.drools.workbench.models.commons.backend.rule.context.LHSGeneratorContextFactory;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class LHSGeneratorContextFactoryTest {
    private LHSGeneratorContextFactory factory;

    @Before
    public void setup() {
        this.factory = new LHSGeneratorContextFactory();
    }

    @Test
    public void testNewGeneratorContext() {
        this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(0);
    }

    @Test
    public void testNewChildGeneratorContextPattern() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        this.factory.newChildGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(1);
        this.factory.newChildGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(3);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getDepth()).isEqualTo(2);
    }

    @Test
    public void testNewChildGeneratorContextFieldConstraint() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        this.factory.newChildGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(1);
        this.factory.newChildGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(3);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getDepth()).isEqualTo(2);
    }

    @Test
    public void testNewChildGeneratorContextMixedPatternFieldConstraint() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        this.factory.newChildGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(1);
        this.factory.newChildGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(3);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getDepth()).isEqualTo(2);
    }

    @Test
    public void testNewPeerGeneratorContextPattern() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getOffset()).isEqualTo(0);
        LHSGeneratorContext peer = this.factory.newPeerGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getOffset()).isEqualTo(1);
        this.factory.newPeerGeneratorContext(peer, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(3);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getOffset()).isEqualTo(2);
    }

    @Test
    public void testNewPeerGeneratorContextFieldConstraint() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getOffset()).isEqualTo(0);
        LHSGeneratorContext peer = this.factory.newPeerGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getOffset()).isEqualTo(1);
        this.factory.newPeerGeneratorContext(peer, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(3);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getOffset()).isEqualTo(2);
    }

    @Test
    public void testNewNewPeerGeneratorContextMixedPatternFieldConstraint() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(1);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(0)).getOffset()).isEqualTo(0);
        this.factory.newPeerGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(2);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(1)).getOffset()).isEqualTo(1);
        this.factory.newPeerGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((List)this.factory.getGeneratorContexts()).hasSize(3);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getDepth()).isEqualTo(0);
        Assertions.assertThat((int)((LHSGeneratorContext)this.factory.getGeneratorContexts().get(2)).getOffset()).isEqualTo(1);
    }

    @Test
    public void testGetMaximumDepth() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((int)this.factory.getMaximumDepth()).isEqualTo(0);
        this.factory.newChildGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((int)this.factory.getMaximumDepth()).isEqualTo(1);
    }

    @Test
    public void testGetMaximumPatternDepth() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        Assertions.assertThat((int)this.factory.getMaximumPatternDepth()).isEqualTo(0);
        this.factory.newChildGeneratorContext(root, (IPattern)Mockito.mock(IPattern.class));
        Assertions.assertThat((int)this.factory.getMaximumPatternDepth()).isEqualTo(1);
        this.factory.newChildGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        Assertions.assertThat((int)this.factory.getMaximumPatternDepth()).isEqualTo(1);
    }

    @Test
    public void testGetPeers() {
        LHSGeneratorContext root = this.factory.newGeneratorContext();
        LHSGeneratorContext peer1 = this.factory.newPeerGeneratorContext(root, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        LHSGeneratorContext peer2 = this.factory.newPeerGeneratorContext(peer1, (FieldConstraint)Mockito.mock(FieldConstraint.class));
        List peers = this.factory.getPeers(root);
        Assertions.assertThat((List)peers).contains((Object[])new LHSGeneratorContext[]{peer1, peer2});
    }
}

