/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.commons.backend.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.MethodInfo;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.mockito.Mockito;

public class RuleModelDRLPersistenceUnmarshallingI18NTest {
    private PackageDataModelOracle dmo;
    private Map<String, ModelField[]> packageModelFields = new HashMap<String, ModelField[]>();
    private Map<String, String[]> projectJavaEnumDefinitions = new HashMap<String, String[]>();
    private Map<String, List<MethodInfo>> projectMethodInformation = new HashMap<String, List<MethodInfo>>();

    @Before
    public void setUp() throws Exception {
        this.dmo = (PackageDataModelOracle)Mockito.mock(PackageDataModelOracle.class);
        Mockito.when((Object)this.dmo.getModuleModelFields()).thenReturn(this.packageModelFields);
        Mockito.when((Object)this.dmo.getModuleJavaEnumDefinitions()).thenReturn(this.projectJavaEnumDefinitions);
        Mockito.when((Object)this.dmo.getModuleMethodInformation()).thenReturn(this.projectMethodInformation);
    }

    @After
    public void cleanUp() throws Exception {
        this.packageModelFields.clear();
        this.projectJavaEnumDefinitions.clear();
        this.projectMethodInformation.clear();
    }

    private void addModelField(String factName, String fieldName, String clazz, String type) {
        ModelField[] modelFields = new ModelField[]{new ModelField(fieldName, clazz, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type)};
        if (this.packageModelFields.containsKey(factName)) {
            ArrayList<Object> existingModelFields = new ArrayList<Object>(Arrays.asList((Object[])this.packageModelFields.get(factName)));
            existingModelFields.add(modelFields[0]);
            modelFields = existingModelFields.toArray(modelFields);
        }
        this.packageModelFields.put(factName, modelFields);
    }

    @Test
    public void testI18N_US_InsertFact() {
        String drl = "package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nthen\nApplicant fact0 = new Applicant();\nfact0.setAge( 55 );\ninsert( fact0 );\nend";
        this.addModelField("Applicant", "age", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nthen\nApplicant fact0 = new Applicant();\nfact0.setAge( 55 );\ninsert( fact0 );\nend", new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionInsertFact));
        ActionInsertFact aif = (ActionInsertFact)m.rhs[0];
        Assert.assertEquals((Object)"Applicant", (Object)aif.getFactType());
        Assert.assertEquals((Object)"fact0", (Object)aif.getBoundName());
        Assert.assertEquals((long)1L, (long)aif.getFieldValues().length);
        ActionFieldValue afv = aif.getFieldValues()[0];
        Assert.assertEquals((Object)"age", (Object)afv.getField());
        Assert.assertEquals((Object)"55", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
        Assert.assertEquals((long)1L, (long)afv.getNature());
    }

    @Test
    public void testI18N_JP_InsertFact() {
        String drl = "package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nthen\n\u5e3d\u5b50 fact0 = new \u5e3d\u5b50();\nfact0.set\u30b5\u30a4\u30ba( 55 );\ninsert( fact0 );\nend";
        this.addModelField("\u5e3d\u5b50", "\u30b5\u30a4\u30ba", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nthen\n\u5e3d\u5b50 fact0 = new \u5e3d\u5b50();\nfact0.set\u30b5\u30a4\u30ba( 55 );\ninsert( fact0 );\nend", new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.rhs.length);
        Assert.assertTrue((boolean)(m.rhs[0] instanceof ActionInsertFact));
        ActionInsertFact aif = (ActionInsertFact)m.rhs[0];
        Assert.assertEquals((Object)"\u5e3d\u5b50", (Object)aif.getFactType());
        Assert.assertEquals((Object)"fact0", (Object)aif.getBoundName());
        Assert.assertEquals((long)1L, (long)aif.getFieldValues().length);
        ActionFieldValue afv = aif.getFieldValues()[0];
        Assert.assertEquals((Object)"\u30b5\u30a4\u30ba", (Object)afv.getField());
        Assert.assertEquals((Object)"55", (Object)afv.getValue());
        Assert.assertEquals((Object)"Integer", (Object)afv.getType());
        Assert.assertEquals((long)1L, (long)afv.getNature());
    }

    @Test
    public void testI18N_US_BoundField() {
        String drl = "package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nApplicant( $a : age )\nthen\nend";
        this.addModelField("Applicant", "age", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nApplicant( $a : age )\nthen\nend", new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern fp = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"age", (Object)sfc.getFieldName());
        Assert.assertEquals((Object)"Integer", (Object)sfc.getFieldType());
        Assert.assertEquals((Object)"$a", (Object)sfc.getFieldBinding());
    }

    @Test
    public void testI18N_JP_BoundField() {
        String drl = "package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nApplicant( \u88fd\u54c1\u756a\u53f7 : age )\nthen\nend";
        this.addModelField("Applicant", "age", "java.lang.Integer", "Integer");
        RuleModel m = RuleModelDRLPersistenceImpl.getInstance().unmarshal("package org.test;\nrule \"r1\"\ndialect \"mvel\"\nwhen\nApplicant( \u88fd\u54c1\u756a\u53f7 : age )\nthen\nend", new ArrayList(), this.dmo);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)1L, (long)m.lhs.length);
        Assert.assertTrue((boolean)(m.lhs[0] instanceof FactPattern));
        FactPattern fp = (FactPattern)m.lhs[0];
        Assert.assertEquals((Object)"Applicant", (Object)fp.getFactType());
        Assert.assertEquals((long)1L, (long)fp.getNumberOfConstraints());
        Assert.assertTrue((boolean)(fp.getConstraint(0) instanceof SingleFieldConstraint));
        SingleFieldConstraint sfc = (SingleFieldConstraint)fp.getConstraint(0);
        Assert.assertEquals((Object)"age", (Object)sfc.getFieldName());
        Assert.assertEquals((Object)"Integer", (Object)sfc.getFieldType());
        Assert.assertEquals((Object)"\u88fd\u54c1\u756a\u53f7", (Object)sfc.getFieldBinding());
    }
}

